/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.postgresql;

import inform.agent.SmartNumberConverter;
import inform.agent.db.connect.postgresql.Connection;
import inform.agent.db.connect.postgresql.ResultSet;
import inform.agent.db.types.SqlDataType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import org.postgresql.jdbc.PgPreparedStatementHelper;

class PreparedStatement
extends inform.agent.db.connect.PreparedStatement {
    PreparedStatement(String logComment, String sql, java.sql.PreparedStatement stmt, Connection connection) {
        super(logComment, sql, stmt, connection);
    }

    @Override
    public void setBlob(int parameterIndex, byte[] x, int length) throws SQLException {
        this.statement().setBinaryStream(parameterIndex, (InputStream)new ByteArrayInputStream(x, 0, length), length);
        this.setParam(parameterIndex, x, SqlDataType.BLOB);
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.setString(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        long l = (long)x;
        if ((double)l == x) {
            this.statement().setLong(parameterIndex, l);
        } else if (SmartNumberConverter.isFinite(x)) {
            PgPreparedStatementHelper.setDoubleAsNumeric(this.statement(), parameterIndex, x);
        } else {
            super.setDouble(parameterIndex, x);
            return;
        }
        this.setParam(parameterIndex, x, SqlDataType.DOUBLE);
    }

    @Override
    protected ResultSet newResultSet(java.sql.ResultSet rs, long startTime) {
        return new ResultSet(rs, this, startTime);
    }

    @Override
    public void setNull(int parameterIndex, SqlDataType type) throws SQLException {
        super.setNull(parameterIndex, type == SqlDataType.UNICODE ? SqlDataType.STRING : type);
    }
}

