/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.filters;

import inform.adt.InformException;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.filters.Range;
import inform.agent.db.filters.RowFilter;

public class BoundFilter
extends RowFilter {
    protected final Bound b0;
    protected final Bound b1;

    public BoundFilter(Bound b0, Bound b1, boolean ascending) {
        if (ascending) {
            this.b0 = b0;
            this.b1 = b1;
        } else {
            this.b0 = b1;
            this.b1 = b0;
        }
    }

    @Override
    public int locate0(Rowset rs, int r0, int r1) throws InformException {
        while (r0 < r1) {
            int m = (r0 + r1) / 2;
            int d = this.b0.test((Row)rs.get(m));
            if (d < 0) {
                r0 = m + 1;
                continue;
            }
            if (d > 0) {
                r1 = m - 1;
                continue;
            }
            r1 = m;
        }
        return r0;
    }

    @Override
    public int locate1(Rowset rs, int r0, int r1) throws InformException {
        while (r0 < r1) {
            int m = (r0 + r1 + 1) / 2;
            int d = this.b1.test((Row)rs.get(m));
            if (d < 0) {
                r1 = m - 1;
                continue;
            }
            if (d > 0) {
                r0 = m + 1;
                continue;
            }
            r0 = m;
        }
        return r1;
    }

    @Override
    public Range apply(Rowset rs, Range r) throws InformException {
        if (r.empty()) {
            return r;
        }
        int r0 = this.locate0(rs, r.first, r.last);
        if (this.b0.test((Row)rs.get(r0)) < 0) {
            return Range.EMPTY;
        }
        int r1 = this.locate1(rs, r0, r.last);
        if (this.b1.test((Row)rs.get(r1)) < 0) {
            return Range.EMPTY;
        }
        return new Range(r0, r1);
    }

    public static abstract class Bound {
        protected static final int D0 = 1;
        protected static final int D1 = -1;
        protected static final int IN = 1;
        protected static final int EDGE = 0;
        protected static final int OUT = -1;
        private final int direction;
        protected final DatabaseCaps caps;
        protected final int fieldIndex;
        protected final int nullSortKind;

        public Bound(DatabaseCaps caps, int nullSortKind, int fieldIndex, int direction) {
            this.caps = caps;
            this.fieldIndex = fieldIndex;
            this.direction = direction;
            this.nullSortKind = nullSortKind;
        }

        public final int test(Row r) throws InformException {
            if (this.fieldIndex != -1 && r.getNullFlag(this.fieldIndex)) {
                return this.direction * this.testNull();
            }
            return this.direction * this.testValue(r);
        }

        protected int testNull() throws InformException {
            return this.caps.isNullFirst(this.nullSortKind) ? -1 : 1;
        }

        protected abstract int testValue(Row var1) throws InformException;
    }
}

