/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.mtd.nodes.TableNode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class CheckConstraints
extends Request {
    private static final String SQL = "SELECT %s FROM %s t WHERE t.%s IS NOT NULL AND NOT t.%s IN ( SELECT %s FROM %s )";
    private static final int TAG_RESULT_MODE = 1;
    private static final int ROW_ID_RESULT_MODE = 1;
    private static final int VAL_RESULT_MODE = 2;
    private static final int TAG_ROW_ID = 2;
    private static final int TAG_FIELD_NAME = 3;
    private static final int TAG_FIELD_VAL = 4;

    public CheckConstraints(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        try {
            double tableId = this.getNodeID();
            TableNode node = this.getNode(tableId, TableNode.class);
            TableDescriptor desc = node.getDescriptor();
            FieldDescriptor key = desc.getPrimaryKeyFields().isEmpty() ? null : desc.getPrimaryKeyFields().get(0);
            DoubleHash<Row> rows = new DoubleHash<Row>();
            IntegerHash<Val> vals = new IntegerHash<Val>();
            try (DatabaseConnection connection = desc.getDatabaseDescriptor().connect(this, "rq:CheckConstraints");){
                for (FieldDescriptor f : desc.getFields()) {
                    if (f.getType() != DataType.DIRECTORY) continue;
                    TableNode refNode = null;
                    try {
                        refNode = this.getNode(f.getReferenceId(), TableNode.class);
                    }
                    catch (Exception ex) {
                        Core.logger.error(null, ex);
                        this.sendError(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a [%.0f] \u0434\u043b\u044f \u043f\u043e\u043b\u044f \"%s\" [%d]", f.getReferenceId(), f.getCaption(), f.getId()), "");
                        continue;
                    }
                    TableDescriptor refDesc = refNode.getDescriptor();
                    if (refDesc.getPrimaryKeyFields().isEmpty()) {
                        throw new InformException("\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b-\u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 " + refDesc.getCaption() + " \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
                    }
                    FieldDescriptor refKey = refDesc.getPrimaryKeyFields().get(0);
                    refDesc.getFieldDescriptor(f.getRefFieldId());
                    String _sql = String.format(SQL, key == null ? f.getRawName() : key.getRawName(), desc.getRawName(), f.getRawName(), f.getRawName(), refKey.getRawName(), refDesc.getDatabaseDescriptor().getTableRawName(refDesc.getRawName()));
                    try (PreparedStatement statement = connection.prepareStatement(_sql);){
                        ResultSet rs = statement.executeQuery(null);
                        if (key != null) {
                            this.processForRowIdResultMode(rows, rs, f);
                            continue;
                        }
                        this.processForValResultMode(vals, rs, f.getId());
                    }
                }
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                TaggedWriter writer = new TaggedWriter(result);
                writer.putInt32(1, key == null ? 2 : 1);
                if (key != null) {
                    this.sendForRowIdResultMode(writer, rows);
                } else {
                    this.sendForValResultMode(writer, vals, desc);
                }
                writer.flush();
                this.sendResult(result.internalBuffer(), result.size());
            }
        }
        catch (Exception ex) {
            Core.logger.error(null, ex);
            this.sendError(ex.getMessage(), "");
        }
    }

    private void processForRowIdResultMode(DoubleHash<Row> rows, ResultSet rs, FieldDescriptor f) throws SQLException {
        while (rs.next()) {
            double rowId = rs.getDouble(1);
            Row r = rows.get(rowId);
            if (r == null) {
                r = new Row(rowId);
                rows.add(r);
            }
            r.add(f);
        }
    }

    private void sendForRowIdResultMode(TaggedWriter writer, DoubleHash<Row> rows) throws IOException {
        for (Row row : rows) {
            writer.putDouble(2, row.key);
            for (FieldDescriptor fd : row) {
                writer.putString(3, fd.getCaption());
            }
        }
    }

    private void processForValResultMode(IntegerHash<Val> vals, ResultSet rs, int fid) throws SQLException {
        if (!rs.next()) {
            return;
        }
        Val vs = vals.get(fid);
        if (vs == null) {
            vs = new Val(fid);
            vals.add(vs);
        }
        do {
            vs.add(rs.getDouble(1));
        } while (rs.next());
    }

    private void sendForValResultMode(TaggedWriter writer, IntegerHash<Val> vals, TableDescriptor desc) throws IOException {
        for (Val vs : vals) {
            writer.putString(3, desc.getFieldDescriptor(vs.key).getCaption());
            for (Cursor.Double v : vs) {
                writer.putDouble(4, v.value);
            }
        }
    }

    private static class Val
    extends DoubleList
    implements IntegerHash.Entry {
        final int key;

        Val(int key) {
            super(16);
            this.key = key;
        }

        @Override
        public int key() {
            return this.key;
        }
    }

    private static class Row
    extends ArrayList<FieldDescriptor>
    implements DoubleHash.Entry {
        final double key;

        Row(double key) {
            this.key = key;
        }

        @Override
        public double key() {
            return this.key;
        }
    }
}

