/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.RequestHeader;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.Advisor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.Plan;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.request.AbstractDataRequest;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.SqlScriptNode;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class ExecuteSqlScriptNode
extends AbstractDataRequest {
    public ExecuteSqlScriptNode(RequestHeader rq) {
        super(rq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        SqlScriptNode.Descriptor sqlDescriptor = new SqlScriptNode.Descriptor(this.getRequestContent());
        Node node = MtdEngine.getNode(sqlDescriptor.getDatabaseId());
        if (node == null) {
            MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445", sqlDescriptor.getDatabaseId());
        }
        if (!(node instanceof DatabaseNode)) {
            if (sqlDescriptor.getDatabaseId() == 0.0) {
                MtdEngine.throwDetailError("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0443\u0437\u0435\u043b \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445", sqlDescriptor.getDatabaseId());
            }
            MtdEngine.throwDetailError("\u0423\u0437\u0435\u043b \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435\u043c \u0441 \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445", sqlDescriptor.getDatabaseId());
        }
        ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:ExecuteSqlScriptNode");
        DatabaseConnection connection = connectionManager.getConnection(sqlDescriptor.getDatabaseId(), "rq:GetRecordContent:logger");
        try {
            AbstractStatement statement;
            String preSql = sqlDescriptor.getPreSql();
            if (!Strings.isVoid(preSql)) {
                statement = connection.createStatement();
                try {
                    statement.setLogDangerSQL();
                    ((Statement)statement).execute(null, preSql);
                    this.idle();
                }
                finally {
                    statement.close();
                }
            }
            if (sqlDescriptor.analyze()) {
                try (Advisor advisor = connection.createAdvisor(sqlDescriptor.getSql());){
                    ResultSet rs = advisor.advise(null);
                    this.idle();
                    this.sendResult(connection, null, rs, -1, sqlDescriptor.isCheckWarnings());
                }
            }
            if (sqlDescriptor.explain()) {
                try (Plan plan = connection.createExplainPlan(sqlDescriptor.getTrace(), sqlDescriptor.getSql());){
                    PreparedStatement statement2 = plan.statement();
                    this.applyParameters(statement2, sqlDescriptor.parameters());
                    ResultSet rs = plan.explain(null);
                    this.idle();
                    this.sendResult(connection, statement2, rs, -1, sqlDescriptor.isCheckWarnings());
                }
            }
            statement = connection.prepareStatement(sqlDescriptor.getSql());
            try {
                statement.setLogDangerSQL();
                this.applyParameters((PreparedStatement)statement, sqlDescriptor.parameters());
                int uc = ((PreparedStatement)statement).execute(null);
                this.idle();
                ResultSet rs = ((PreparedStatement)statement).getResultSet();
                this.sendResult(connection, (PreparedStatement)statement, rs, uc, sqlDescriptor.isCheckWarnings());
            }
            finally {
                statement.close();
            }
            connectionManager.commit();
            connection.setDirtySqlConsole();
        }
        finally {
            connectionManager.release();
        }
    }

    private void sendResult(DatabaseConnection cn, PreparedStatement ps, ResultSet rs, int updateCount, boolean checkWarnings) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(out);
        if (updateCount > -1) {
            writer.putInt32(21, updateCount);
        }
        if (rs != null) {
            this.writeResultSet(writer, rs, 0.0, null);
        }
        if (checkWarnings) {
            StringBuilder warnings = new StringBuilder();
            if (rs != null) {
                this.appendWarnings(warnings, rs.getWarnings());
            }
            if (ps != null) {
                this.appendWarnings(warnings, ps.getWarnings());
            }
            this.appendWarnings(warnings, cn.getWarnings());
            if (warnings.length() > 0) {
                writer.putString(20, warnings.toString());
            }
        }
        writer.flush();
        this.sendResult(out.internalBuffer(), out.size());
    }

    private void appendWarnings(StringBuilder to, SQLWarning warnings) {
        while (warnings != null) {
            to.append(warnings).append('\n');
            warnings = warnings.getNextWarning();
        }
    }

    private void applyParameters(PreparedStatement statement, Iterable<SqlScriptNode.Descriptor.Parameter> parameters) throws SQLException {
        int pidx = 1;
        for (SqlScriptNode.Descriptor.Parameter p : parameters) {
            if (p.value == null) {
                statement.setNull(pidx, p.type);
            } else {
                switch (p.type) {
                    case INTEGER: {
                        statement.setInt(pidx, (Integer)p.value);
                        break;
                    }
                    case DOUBLE: {
                        statement.setDouble(pidx, (Double)p.value);
                        break;
                    }
                    case DATE_TIME: {
                        statement.setDateTime(pidx, (Double)p.value);
                        break;
                    }
                    case TIMESTAMP: {
                        statement.setTimestamp(pidx, DateTime.toSqlTime((Double)p.value));
                        break;
                    }
                    case STRING: 
                    case UNICODE: {
                        statement.setString(pidx, (String)p.value);
                        break;
                    }
                    case BOOLEAN: {
                        statement.setBoolean(pidx, (Boolean)p.value);
                        break;
                    }
                    default: {
                        throw new InformException("Unsupported parameter type (" + p.type + ")");
                    }
                }
            }
            ++pidx;
        }
    }
}

