/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.BlobDataReader;
import inform.agent.db.types.BlobValueId;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.TableNode;
import java.io.InputStream;

public class GetBlobData
extends Request {
    public GetBlobData(RequestHeader rq) {
        super(rq, RequestDuration.MIDDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        BlobValueId blobId = new BlobValueId(this.getRequestContent());
        BlobDataReader blobData = new BlobDataReader(this.getRequestSessionID(), this);
        double databaseId = this.getNodeID();
        BasicNode node = MtdEngine.getValidTranslatedNode(databaseId);
        if (node instanceof TableNode) {
            databaseId = ((TableNode)node).getDescriptor().getDbId();
        }
        try (InputStream in = blobData.readData(null, databaseId, blobId);){
            if (in != null) {
                int bytesReaden;
                byte[] buffer = new byte[4096];
                do {
                    if ((bytesReaden = in.read(buffer)) > 0) {
                        this.sendChunk(buffer, bytesReaden);
                    }
                    this.idle();
                } while (bytesReaden > -1);
            }
        }
        finally {
            blobData.release();
        }
        this.sendResult();
    }
}

