/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.request.GetRecordContent;
import inform.agent.db.utils.PackedRowContent;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.nodes.Node;
import java.io.OutputStream;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;

public class GetDirectoryRecordContents
extends Request {
    private Directory root = null;
    RequestResult result;
    TaggedWriter out;

    public GetDirectoryRecordContents(RequestHeader rq) {
        super(rq, RequestDuration.MIDDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        double userId = this.getUserID();
        Directory current = null;
        Directory parent = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 5: {
                    double tableId = in.getDouble();
                    Object node = this.getNode(tableId);
                    if (AccessMask.accessDenied(0x4000000, this.security().accessMask((Node)node))) {
                        this.sendResult();
                        return;
                    }
                    Directory directory = new Directory(TableDescriptor.get(tableId));
                    StringBuffer logInfo = new StringBuffer();
                    logInfo.append("rg: ").append(553).append(" u: ").append(NumberConverter.doubleToString(userId)).append(" t: ").append(NumberConverter.doubleToString(tableId));
                    if (this.ssContext.ownerId != 0.0) {
                        logInfo.append(" o:").append(NumberConverter.doubleToString(this.ssContext.ownerId));
                    }
                    if (this.ssContext.uid != 0) {
                        logInfo.append(" uid:").append(this.ssContext.uid);
                    }
                    directory.logInfo = logInfo.toString();
                    if (directory.table.getKind() == TableDescriptor.Kind.VIRTUAL) {
                        throw new InformException("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u044b\u0431\u043e\u0440 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439").detail(directory.logInfo);
                    }
                    directory.recordIdField = directory.table.getRecordIdField();
                    if (directory.recordIdField == null) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("\u041f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b [").append(Core.idstr(tableId)).append("] ").append(directory.table.getRawName()).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                        throw new InformException(msg.toString()).detail(directory.logInfo);
                    }
                    if (current == null) {
                        this.root = current = directory;
                        break;
                    }
                    parent = current;
                    current.next = directory;
                    current = directory;
                    break;
                }
                case 1: {
                    if (current == null) break;
                    if (current.records == null) {
                        current.records = new DoubleList(64);
                        current.recordSet = new DoubleSet();
                    }
                    double recordId = in.getDouble();
                    current.records.add(recordId);
                    current.recordSet.add(recordId);
                    break;
                }
                case 17: {
                    if (current == null || parent == null) break;
                    current.parentField = parent.table.getValidFieldDescriptor(in.getInt(), null);
                    break;
                }
                case 41: {
                    this.ssContext.ownerId = in.getDouble();
                    break;
                }
                case 42: {
                    this.ssContext.uid = in.getInt();
                }
            }
        }
        if (this.root == null || this.root.records == null || this.root.records.empty()) {
            this.sendResult();
            return;
        }
        this.rqstat.ownerId = this.ssContext.ownerId;
        this.rqstat.ownerDatasourceId = this.ssContext.uid;
        this.result = new RequestResult(this, 8192);
        this.out = this.result.getWriter();
        ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "GetDirectoryRecordContents");
        try {
            current = this.root;
            while (current != null && current.records != null && !current.records.empty()) {
                double databaseId = current.table.getDbId();
                DatabaseConnection connection = connectionManager.getConnection(databaseId, "rq:GetDirectoryRecordContents sendDirectory");
                if (!((AbstractConnectionManager)connectionManager).isPersonalSession()) {
                    connection.markAsReadonly();
                }
                Core.logger.setCollectSql(connection, true);
                try {
                    try {
                        this.sendDirectory(current, connection);
                    }
                    finally {
                        Core.logger.setCollectSql(connection, false);
                    }
                }
                catch (Throwable ex) {
                    StringBuffer logInfo = new StringBuffer();
                    logInfo.append(current.logInfo).append("\r\n").append(current.sqlText).append("\r\n");
                    throw InformException.detail(ex, logInfo.toString());
                }
                current = current.next;
            }
            this.result.sendResult();
            connectionManager.commit();
        }
        finally {
            ((AbstractConnectionManager)connectionManager).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDirectory(Directory directory, DatabaseConnection connection) throws Exception {
        this.out.putDouble(5, directory.table.getNodeId());
        int paramCount = 1;
        DatabaseDescriptor db = directory.table.getDatabaseDescriptor();
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        GetRecordContent.generateFieldList(sql, directory.table, "TT");
        sql.append(" from ");
        db.appendTableRawName(directory.table.getRawName(), sql);
        sql.append(" ").append("TT").append(" where ").append(directory.recordIdField.getRawName()).append(" in (?");
        int frameSize = directory.records.size();
        if (frameSize > 64) {
            frameSize = 64;
        }
        --frameSize;
        while (frameSize > 0) {
            sql.append(",?");
            ++paramCount;
            --frameSize;
        }
        sql.append(')');
        directory.sqlText = sql.toString();
        try (PreparedStatement statement = connection.prepareStatement(this.getClass().getSimpleName(), directory.sqlText);){
            statement.setQueryTimeout();
            ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
            PackedRowContent content = new PackedRowContent(0, 0, this.rq.client.isClientLevel(3), this, this.rq.client.isClientLevel(6));
            ArrayList<FieldDescriptor> recordFields = null;
            int[] columnsMap = null;
            boolean needSendMetadata = true;
            int recordIndex = 0;
            int recordCount = directory.records.size();
            while (recordIndex < recordCount) {
                this.idle();
                if (paramCount == 0) {
                    recordIndex = recordCount;
                } else {
                    for (int p = 0; p < paramCount; ++p) {
                        if (recordIndex < recordCount) {
                            statement.setDouble(p + 1, directory.records.get(recordIndex++));
                            continue;
                        }
                        statement.setDouble(p + 1, 0.0);
                    }
                }
                ResultSet resultSet = statement.executeQuery(null);
                int recordIdFieldIdx = resultSet.findColumn(directory.recordIdField.getRawName());
                int directoryFieldIndex = -1;
                if (directory.next != null) {
                    directoryFieldIndex = resultSet.findColumn(directory.next.parentField.getRawName());
                }
                try {
                    while (resultSet.next()) {
                        this.idle();
                        if (needSendMetadata) {
                            needSendMetadata = false;
                            ResultSetMetaData metadata = resultSet.getMetaData();
                            List<FieldDescriptor> tableFields = directory.table.getFields();
                            recordFields = new ArrayList<FieldDescriptor>();
                            for (FieldDescriptor field : tableFields) {
                                if (field.isAbstract()) continue;
                                recordFields.add(field);
                            }
                            columnsMap = new int[recordFields.size()];
                            block11: for (int index = 0; index < columnsMap.length; ++index) {
                                FieldDescriptor field;
                                field = (FieldDescriptor)recordFields.get(index);
                                columnsMap[index] = -1;
                                for (int i = 0; i < metadata.getColumnCount(); ++i) {
                                    String columnName = metadata.getColumnLabel(i + 1);
                                    if (!columnName.equalsIgnoreCase(field.getRawName())) continue;
                                    columnsMap[index] = i + 1;
                                    continue block11;
                                }
                            }
                            data.reset();
                            content.packMetadata(recordFields, (OutputStream)data);
                            this.out.putRaw(27, data);
                        }
                        double rowId = 0.0;
                        if (directory.recordIdField.getType().isNumberPresentation()) {
                            rowId = resultSet.getDouble(recordIdFieldIdx);
                        }
                        this.out.putDouble(1, rowId);
                        directory.recordSet.remove(rowId);
                        if (directory.next != null && directoryFieldIndex >= 0) {
                            double recordId = resultSet.getAsDouble(directoryFieldIndex);
                            if (!resultSet.wasNull()) {
                                if (directory.next.records == null) {
                                    directory.next.records = new DoubleList(64);
                                    directory.next.recordSet = new DoubleSet();
                                    directory.next.records.add(recordId);
                                    directory.next.recordSet.add(recordId);
                                } else if (directory.next.recordSet.add(recordId)) {
                                    directory.next.records.add(recordId);
                                }
                            }
                        }
                        data.reset();
                        content.packRecordContent(resultSet, recordFields, columnsMap, directory.table.getNodeId(), rowId, data);
                        this.out.putRaw(2, data);
                        this.result.sendChunkIf(3072);
                    }
                }
                finally {
                    resultSet.close();
                }
                for (Cursor.Double absent : directory.recordSet) {
                    this.out.putDouble(51, absent.value);
                }
            }
            this.result.sendChunk();
        }
    }

    private static class Directory {
        final TableDescriptor table;
        FieldDescriptor recordIdField;
        FieldDescriptor parentField;
        DoubleSet recordSet;
        DoubleList records;
        Directory next;
        String logInfo;
        String sqlText;

        Directory(TableDescriptor table) {
            this.table = table;
        }
    }
}

