/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;

public class RecordRefsCountRequest
extends Request {
    private static final int TAG_DIR_TABLE_ID = 1;
    private static final int TAG_TABLE_ID = 2;
    private static final int TAG_REC_ID = 3;
    private static final int TAG_REC_COUNT = 4;
    private static DoubleSet Recs;
    private static double dir_tableId;
    private static double tableId;
    private static double recordId;
    private static IntegerSet Fields;

    public RecordRefsCountRequest(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    @Override
    public void execute() throws Throwable {
        Recs = new DoubleSet();
        dir_tableId = -1.0;
        tableId = -1.0;
        recordId = -1.0;
        Fields = new IntegerSet();
        int count = 0;
        if (this.readInput()) {
            this.getRecords();
            if (!Recs.empty()) {
                count = Recs.size();
            }
        }
        ByteArrayOutputStream ar = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(ar);
        writer.putInt32(4, count);
        writer.flush();
        this.sendResult(ar.internalBuffer(), ar.size());
    }

    private boolean readInput() throws Throwable {
        boolean res = false;
        TaggedReader reader = this.createRequestContentReader();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    dir_tableId = reader.getDouble();
                    break;
                }
                case 2: {
                    tableId = reader.getDouble();
                    break;
                }
                case 3: {
                    recordId = reader.getDouble();
                }
            }
        }
        boolean bl = res = dir_tableId != -1.0 && tableId != -1.0 && recordId != -1.0;
        if (res) {
            TableDescriptor tDesc = new TableDescriptor(tableId, false);
            for (FieldDescriptor f : tDesc.getFields()) {
                if (f.isVirtual() || f.getType() != DataType.DIRECTORY || f.getReferenceId() != dir_tableId) continue;
                Fields.add(f.getId());
            }
            res = !Fields.empty();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRecords() throws Throwable {
        Recs.clear();
        TableDescriptor tDesc = new TableDescriptor(tableId, false);
        String tName = tDesc.getRawName();
        if (tName == null) {
            return;
        }
        FieldDescriptor PrimaryKeyFieldDesc = tDesc.getRecordIdField();
        if (PrimaryKeyFieldDesc == null) {
            return;
        }
        DatabaseDescriptor databaseDescriptor = tDesc.getDatabaseDescriptor();
        try (DatabaseConnection conn = databaseDescriptor.connect(this, "rq:RecordRefsCountRequest");){
            StringBuilder SelectStr = new StringBuilder();
            SelectStr.append(PrimaryKeyFieldDesc.getRawName());
            StringBuilder WhereStr = new StringBuilder();
            for (Cursor.Integer c : Fields) {
                FieldDescriptor FieldDesc = tDesc.getFieldDescriptor(c.value);
                if (FieldDesc == null) continue;
                SelectStr.append(", ").append(FieldDesc.getRawName());
                if (!WhereStr.toString().equals("")) {
                    WhereStr.append(" OR ");
                }
                WhereStr.append(FieldDesc.getRawName()).append("=").append(NumberConverter.doubleToString(recordId));
            }
            String sql = String.format("SELECT %s FROM %s WHERE %s", SelectStr.toString(), databaseDescriptor.getTableRawName(tName), WhereStr.toString());
            PreparedStatement stmt = conn.prepareStatement(sql);
            try (ResultSet result = stmt.executeQuery(this.ssContext);){
                while (result.next()) {
                    Recs.add(result.getDouble(1));
                }
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
            }
        }
    }
}

