/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.db.schema.Restructure;
import inform.agent.mtd.nodes.TableNode;

public class RestructureIndices
extends Request {
    private static final int TAG_RESTRUCTURE_MODE = 1;
    private static final int ALL_IDX_RESTR_MODE = 1;
    private static final int ONLY_PROBLEM_IDX_RESTR_MODE = 2;

    public RestructureIndices(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        int restructMode = -1;
        TaggedReader in = this.createRequestContentReader();
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    restructMode = in.getInt();
                }
            }
        }
        TableNode table = this.getNode(this.getNodeID(), TableNode.class);
        TableDescriptor descriptor = table.getDescriptor();
        try (DatabaseConnection connection = descriptor.getDatabaseDescriptor().connect(this, "rq:RestructureIndices");){
            DbScheme scheme = connection.openScheme();
            if (restructMode == -1) {
                DbTable dbTable;
                if (!descriptor.getDatabaseDescriptor().getDatabaseType().isOracle()) {
                    throw new InformException("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u0432 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f Oracle");
                }
                DbTable dbTable2 = dbTable = descriptor.urawnamed() ? null : scheme.getTable(null, descriptor.getRawName());
                if (dbTable == null) {
                    this.sendResult();
                    return;
                }
                StringBuilder erStr = new StringBuilder();
                for (IndexDescriptor idx : descriptor.getIndexes()) {
                    DbIndex dbIdx = dbTable.getIndex(null, idx.getRawName());
                    if (dbIdx == null || dbIdx.isValid()) continue;
                    erStr.append("\n\t\t\t").append(idx.getName());
                }
                if (erStr.length() > 0) {
                    this.sendError(erStr.toString(), "");
                } else {
                    this.sendResult();
                }
                return;
            }
            try (Statement statement = connection.createStatement();){
                Restructure.restructureIndices(null, scheme, statement, descriptor, descriptor, Restructure.DDL_LOGGER, restructMode == 1 ? Restructure.Strategy.RECREATE : Restructure.Strategy.UPDATE, null, new Restructure.Progress.FromSSHost(this));
                connection.commit();
            }
        }
        this.sendResult();
    }
}

