/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.schema;

import inform.adt.Strings;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbObject;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class DbColumnable
extends DbObject {
    public final DbScheme scheme;
    protected Map<String, DbColumn> columns;

    public DbColumnable(String name, DbScheme scheme) {
        super(name);
        this.scheme = scheme;
    }

    public Map<String, DbColumn> getColumns(SSContext ssContext) throws SQLException {
        if (this.columns == null) {
            this.columns = new LinkedHashMap<String, DbColumn>();
            if (this.scheme.connection != null) {
                String sch = Strings.isVoid(this.scheme.name) ? null : Strings.unquote(this.scheme.name);
                try (ResultSet rsColumns = this.scheme.metadata.getColumns(null, sch, Strings.unquote(this.name), null);){
                    if (rsColumns != null) {
                        while (rsColumns.next()) {
                            Number n;
                            DbColumn c = this.newColumnObject(this.scheme.nameFromDb(rsColumns.getString("COLUMN_NAME")));
                            int sqlType = rsColumns.getInt("DATA_TYPE");
                            String typeName = rsColumns.getString("TYPE_NAME");
                            c.setSqlTypeName(typeName);
                            if (sqlType == 1111) {
                                if (typeName != null) {
                                    if (typeName.startsWith("VARCHAR")) {
                                        sqlType = 12;
                                    } else if (typeName.startsWith("NVARCHAR")) {
                                        sqlType = -9;
                                    } else if (typeName.equals("tsvector")) {
                                        sqlType = -2;
                                    }
                                }
                            } else if (sqlType == 3 && (n = (Number)rsColumns.getObject("DECIMAL_DIGITS")) != null && n.intValue() == 0) {
                                sqlType = 4;
                            }
                            c.type = DataType.getDataTypeBySqlTypeId(sqlType);
                            c.keyable = this.scheme.getKeyableByType(sqlType);
                            c.blobRawType = DataType.getBlobRawType(sqlType);
                            int _null = rsColumns.getInt("NULLABLE");
                            if (_null == 1) {
                                c.nullable = true;
                            } else if (_null == 0) {
                                c.nullable = false;
                            }
                            Object n2 = rsColumns.getObject("CHAR_OCTET_LENGTH");
                            c.size = n2 == null ? 0 : (n2 instanceof Number ? ((Number)n2).intValue() : Integer.parseInt(String.valueOf(n2)));
                            String defValue = rsColumns.getString("COLUMN_DEF");
                            c.setDefValue(defValue);
                            this.columns.put(c.name, c);
                        }
                    }
                }
                try (ResultSet rsKeys = this.scheme.metadata.getImportedKeys(null, sch, Strings.unquote(this.name));){
                    if (rsKeys != null) {
                        while (rsKeys.next()) {
                            String colName = rsKeys.getString("FKCOLUMN_NAME");
                            String consName = rsKeys.getString("FK_NAME");
                            String refName = rsKeys.getString("PKTABLE_NAME");
                            DbColumn c = this.columns.get(colName);
                            if (c == null) continue;
                            c.setForeignKey(consName, refName);
                        }
                    }
                }
            }
        }
        return this.columns;
    }

    public void invalidateColumns(SSContext ssContext) throws SQLException {
        this.columns = null;
        this.getColumns(ssContext);
    }

    public void updateFieldsInfo(SSContext ssContext, Statement statement, TableDescriptor tableDescriptor) throws SQLException {
    }

    protected DbColumn newColumnObject(String name) {
        return new DbColumn(name, this);
    }

    @Override
    public DbScheme getParent() {
        return this.scheme;
    }
}

