/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.schema;

import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.Request;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbScheme;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public abstract class DbObject {
    protected String name;

    public DbObject(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String toFullName(String name) {
        StringBuilder result = new StringBuilder(name);
        for (DbObject o = this.getParent(); o != null && !Strings.isVoid(o.name); o = o.getParent()) {
            if (result.length() > 0) {
                result.insert(0, '.');
            }
            result.insert(0, o.name);
        }
        return result.toString();
    }

    public String fullName() {
        return this.toFullName(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drop(SSContext ssContext, Statement statement) throws SQLException {
        Request rq;
        LogContext lc = LogContext.CURRENT.get();
        Request request = rq = lc instanceof Request ? (Request)lc : null;
        if (rq != null) {
            rq.vlongOp_begin();
        }
        try {
            this.internal_drop(ssContext, statement);
        }
        finally {
            if (rq != null) {
                rq.vlongOp_end();
            }
        }
        DbObject parent = this.getParent();
        if (parent != null) {
            parent.deleteInternalDbObject(this);
        }
        this.log("DROPPED");
    }

    protected void internal_drop(SSContext ssContext, Statement statement) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public final void rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        String old = this.name;
        to = this.scheme().toCaseIfNeed(to);
        this.internal_rename(ssContext, statement, to);
        this.name = to;
        this.log("RENAMED", "[%s] -> [%s]", this.toFullName(old), this.fullName());
        DbObject parent = this.getParent();
        if (parent != null) {
            parent.renameInternalDbObject(this, old);
        }
    }

    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.name + "@" + this.hashCode();
    }

    void deleteInternalDbObject(DbObject obj) {
    }

    void renameInternalDbObject(DbObject obj, String oldName) {
    }

    public abstract DbObject getParent();

    public DbScheme scheme() {
        DbObject parent = this.getParent();
        return parent != null ? parent.scheme() : null;
    }

    public void log(String action) {
        String cn = this.getClass().getSimpleName().replace("Db", "");
        Core.logger.info("{} {} [{}]", cn.toUpperCase(), action.toUpperCase(), this.fullName());
    }

    public void log(String action, String fmt, Object ... args) {
        String cn = this.getClass().getSimpleName().replace("Db", "");
        Core.logger.info("{} {} {}", cn.toUpperCase(), action.toUpperCase(), String.format(fmt, args));
    }
}

