/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.DataEntry;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.scripts.sql.JoinType;
import java.io.IOException;

public class DirectoryEntry
extends DataEntry {
    int directoryReferenceFieldId;

    public DirectoryEntry(int entryId, double tableId) {
        super(entryId, SearchEntry.Kind.Directory, tableId);
        this.joinType = JoinType.LEFT_OUTER;
        this.linkId = 5;
    }

    public DirectoryEntry(int entryId, double tableId, int directoryReferenceFieldId) {
        super(entryId, SearchEntry.Kind.Directory, tableId);
        this.joinType = JoinType.LEFT_OUTER;
        this.linkId = 5;
        this.directoryReferenceFieldId = directoryReferenceFieldId;
    }

    @Override
    public double entryNodeId() {
        return this.tableId;
    }

    @Override
    public void fillSignificantFields() {
        TableDescriptor table;
        if (!this.ignored() && this.parentEntry != null && (table = this.parentEntry.getTableDescriptor()).getFieldDescriptor(this.directoryReferenceFieldId) != null) {
            this.parentEntry.addUsedField(this.directoryReferenceFieldId);
        }
        super.fillSignificantFields();
    }

    @Override
    public boolean hasDistinctRelations() {
        return this.hasChildrenDistinctRelations();
    }

    @Override
    public void adjustRelations(DatabaseCaps caps) {
        this.checkUsageCount(true);
        super.adjustRelations(caps);
    }

    @Override
    void fillUsedFieldsAdvanced(Search topSearch) {
        if (!this.ignored() && this.parentEntry != null && !this.parentEntry.ignored() && this.parentEntry.excludeUnusedFields() && this.parentEntry.inplaceSearch != null && this.parentEntry.inplaceSearch.kind == Search.Kind.Advanced && this.parentEntry.inplaceSearch.fields != null && this.parentEntry.inplaceSearch.fields.find(this.directoryReferenceFieldId) != null) {
            this.parentEntry.addUsedField(this.directoryReferenceFieldId);
        }
        super.fillUsedFieldsAdvanced(topSearch);
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 3: {
                in.skip();
                break;
            }
            case 7: {
                byte[] raw = in.getRaw();
                this.directoryReferenceFieldId = LittleEndian.getInt(raw, 4);
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }
}

