/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.AggregateFunction;
import inform.agent.db.sql.engine.Condition;
import inform.agent.db.sql.engine.Engine;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.sql.engine.Function;
import inform.agent.db.sql.engine.Generate;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.sql.engine.SearchField;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.Parameter;
import java.io.IOException;
import java.util.ArrayList;

public class GenerateFieldExpression {
    private static final FieldExpression.Term concatTerm = new FieldExpression.Term(FieldExpression.Token.Concat, null);
    private static final FieldExpression.Term osb = new FieldExpression.Term(FieldExpression.Token.SoftBrace, null);
    private static final FieldExpression.Term csb = new FieldExpression.Term(FieldExpression.Token.CloseSoftBrace, null);

    static void determineGroupable(SearchField field) {
        field.groupable(false);
        if (field.function == AggregateFunction.CountEx || !field.hasExpression()) {
            return;
        }
        for (FieldExpression.Item item : field.expression.items) {
            switch (item.kind) {
                case Field: 
                case SystemField: {
                    field.groupable(true);
                    return;
                }
                case Function: {
                    if (item.function != Function.BlobSize) break;
                    field.groupable(true);
                    return;
                }
            }
        }
    }

    static boolean generable(Search search, Engine engine, SearchField field) {
        if (field.function == AggregateFunction.CountEx) {
            return true;
        }
        FieldExpression.Terms terms = field.expression.adjust(search, engine.caps, field);
        return terms != null && !terms.isEmpty();
    }

    static void generate(Search search, Engine engine, boolean havingContext, Generate.Section section, SearchField field) {
        DataType dataType;
        String line;
        Object source;
        if (field.function == AggregateFunction.CountEx) {
            section.sql.append(field.function.sql);
            field.generated(true);
            field.ignored(false);
            return;
        }
        FieldExpression.Terms terms = field.expression.adjust(search, engine.caps, field);
        if (terms == null || terms.isEmpty()) {
            section.sql.append("null");
            engine.caps.typifySuffix(field.dataType, section.sql);
            return;
        }
        if (field.function != AggregateFunction.NONE) {
            section.sql.append(engine.caps.aggregativePrefix(field.dataType, field.function));
        } else if (havingContext) {
            section.sql.append('(');
        }
        Object suffix = null;
        if (field.hierarchicSort()) {
            SearchEntry entry;
            if (engine.caps.isPostgreSqlHierarchicSyntax()) {
                if (search.isHierarchicRootSection()) {
                    section.sql.append(" ARRAY[(");
                    suffix = ")]";
                } else if (search.isHierarchicConditionSection()) {
                    entry = search.rootEntry.isEmpty() ? search.rootEntry : search.rootEntry.children.get(search.rootEntry.children.size() - 1);
                    entry.generateFieldAlias(field.proxyField, section.sql);
                    section.sql.append("||(");
                    suffix = ")";
                }
            } else if (engine.caps.isAnsiHierarchicSyntax()) {
                if (search.isHierarchicRootSection()) {
                    section.sql.append(engine.caps.toMaxStringPrefix()).append("1000000").append("+row_number() over(order by ");
                    suffix = ")" + engine.caps.toMaxStringSuffix();
                } else if (search.isHierarchicConditionSection()) {
                    section.sql.append(engine.caps.toMaxStringPrefix());
                    entry = search.rootEntry.isEmpty() ? search.rootEntry : search.rootEntry.children.get(search.rootEntry.children.size() - 1);
                    entry.generateFieldAlias(field.proxyField, section.sql);
                    section.sql.append(engine.caps.concatOperator).append(engine.caps.numberToStringFunction()).append("1000000").append("+row_number() over(order by ");
                    suffix = ")" + engine.caps.numberToStringSuffix() + engine.caps.toMaxStringSuffix();
                }
            }
        }
        if ((source = field.source) == null) {
            source = field.proxyField != null ? "\u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u044f " + field.proxyField.getCaption() + " [" + field.proxyField.getId() + "]" : "\u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u044f";
        }
        if ((line = field.line) == null) {
            line = "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ";
        }
        if ((dataType = field.dataType) == DataType.STRING) {
            for (FieldExpression.Term term : terms) {
                if (term.token != FieldExpression.Token.Operator) continue;
                switch (term.item.function) {
                    case Div: 
                    case Mul: 
                    case Sub: 
                    case Mod: {
                        field.dataType = DataType.FLOAT;
                    }
                }
                if (field.dataType == dataType) continue;
                break;
            }
        }
        terms.reset();
        try {
            GenerateFieldExpression.generateTerm(search, engine, section, field, terms, (String)source, line, field.lineNo);
            field.generated(true);
            field.ignored(false);
        }
        catch (Search.Exception exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new Search.Exception(search, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 " + (String)source + " (" + line + ": " + field.lineNo + ")", exception);
        }
        finally {
            field.dataType = dataType;
        }
        if (suffix != null) {
            section.sql.append((String)suffix);
        }
        if (field.function != AggregateFunction.NONE || havingContext) {
            if (field.function == AggregateFunction.StringAGG) {
                String delemiter = ", ";
                for (FieldExpression.Item item : field.expression.items) {
                    if (item.kind != FieldExpression.Kind.Function || item.function != Function.Delimiter) continue;
                    delemiter = item.str_val;
                    break;
                }
                section.sql.append(", ").append(engine.caps.c_string2sql(delemiter));
            }
            section.sql.append(')');
        }
    }

    private static void generateTerm(Search search, Engine engine, Generate.Section section, SearchField field, FieldExpression.Terms terms, String source, String line, int lineNo) {
        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
        block4: while (terms.valid()) {
            switch (terms.current().token) {
                case Operator: {
                    GenerateFieldExpression.generateItem(search, engine, field, terms, section, source, line, lineNo);
                    terms.next();
                    GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                    continue block4;
                }
                case Inline: {
                    GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                    continue block4;
                }
            }
            return;
        }
    }

    private static void generateOperator(Search search, Engine engine, SearchField field, FieldExpression.Terms terms, Generate.Section section, String source, String line, int lineNo) {
        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, false, source, line, lineNo);
    }

    private static void generateOperator(Search search, Engine engine, SearchField field, FieldExpression.Terms terms, Generate.Section section, boolean splitInlines, String source, String line, int lineNo) {
        if (!terms.valid()) {
            return;
        }
        switch (terms.current().token) {
            case OpenBrace: {
                section.sql.append('(');
                terms.next();
                GenerateFieldExpression.generateTerm(search, engine, section, field, terms, source, line, lineNo);
                section.sql.append(')');
                if (terms.valid() && terms.current().token == FieldExpression.Token.CloseBrace) {
                    terms.next();
                }
                return;
            }
            case SoftBrace: {
                terms.next();
                GenerateFieldExpression.generateTerm(search, engine, section, field, terms, source, line, lineNo);
                if (terms.valid()) {
                    terms.next();
                }
                return;
            }
            case Function: {
                if (terms.current().item == null) break;
                GenerateFieldExpression.generateItem(search, engine, field, terms, section, source, line, lineNo);
                return;
            }
            case Argument: {
                GenerateFieldExpression.generateItem(search, engine, field, terms, section, source, line, lineNo);
                break;
            }
            case Inline: {
                GenerateFieldExpression.generateItem(search, engine, field, terms, section, source, line, lineNo);
                if (splitInlines) break;
                if (terms.valid()) {
                    terms.next();
                }
                while (terms.valid() && terms.current().token != FieldExpression.Token.Operator && terms.current().token != FieldExpression.Token.CloseBrace) {
                    GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                }
                return;
            }
        }
        if (terms.valid()) {
            terms.next();
        }
    }

    private static void generateFieldItem(int entryId, int fieldId, FieldExpression.Term term, Search search, Engine engine, Generate.Section section, String source, String line, int lineNo) {
        SearchEntry entry = search.getValidEntry(entryId, source, line, lineNo < 0 ? term.item.lineNo : lineNo);
        if (entry.isSubject()) {
            assert (entry.inplaceSearch != null);
            entry.inplaceSearch.setSubjectField(fieldId, 0);
            try {
                Generate.Section subject = engine.generateEntrySql(entry.inplaceSearch, entry);
                section.addParameters(subject.sqlParameters);
                if (entry.inplaceSearch.isUnions()) {
                    FieldDescriptor subjectField = entry.inplaceSearch.rootEntry.getValidFieldDescriptor(fieldId, source, line, lineNo < 0 ? term.item.lineNo : lineNo);
                    section.sql.append('(').append("select ").append("T.").append(subjectField.getRawName()).append(" from ").append('(').append((CharSequence)subject.sql).append(") T)");
                }
                if (entry.inplaceSearch.isHierarchic() && engine.caps.isPostgreSqlHierarchicSyntax()) {
                    FieldDescriptor subjectField = entry.inplaceSearch.rootEntry.getValidFieldDescriptor(fieldId, source, line, lineNo < 0 ? term.item.lineNo : lineNo);
                    section.sql.append('(').append("select ").append(subjectField.getRawName()).append(" from ").append('(').append((CharSequence)subject.sql).append(") Txxx)");
                }
                section.sql.append('(').append((CharSequence)subject.sql).append(')');
            }
            catch (IOException ex) {
                int no = lineNo < 0 ? term.item.lineNo : lineNo;
                throw new Search.Exception(entry.inplaceSearch, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u0434\u0447\u0435\u043d\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0438\u0441\u043a\u0430 \u0432 " + source + " (" + line + " :" + no + ")", ex);
            }
        } else {
            entry.addUsage();
            FieldDescriptor fieldDescriptor = entry.getValidFieldDescriptor(fieldId, source, line, lineNo < 0 ? term.item.lineNo : lineNo);
            if (entry.inplaceSearch != null && entry.inplaceSearch.rootEntry != null) {
                entry.inplaceSearch.rootEntry.addUsedField(fieldDescriptor.getId());
            }
            switch (term.item.typeCast) {
                case Bool: {
                    switch (fieldDescriptor.getType()) {
                        case INTEGER: 
                        case FLOAT: 
                        case DIRECTORY: 
                        case PRIMARY_KEY: {
                            section.sql.append('(').append("case when ");
                            entry.generateFieldAlias(fieldDescriptor, section.sql);
                            section.sql.append(" is null").append(" then ").append("null").append(" when ");
                            entry.generateFieldAlias(fieldDescriptor, section.sql);
                            section.sql.append(" = 0").append(" then ").append(engine.caps.c_bool2sql(false)).append(" else ").append(engine.caps.c_bool2sql(true)).append(" end").append(')');
                            return;
                        }
                    }
                    break;
                }
                case Number: {
                    switch (fieldDescriptor.getType()) {
                        case BOOLEAN: {
                            section.sql.append('(').append("case when ");
                            entry.generateFieldAlias(fieldDescriptor, section.sql);
                            section.sql.append(" is null").append(" then ").append("null").append(" when ");
                            entry.generateFieldAlias(fieldDescriptor, section.sql);
                            section.sql.append(" = ").append(engine.caps.c_bool2sql(false)).append(" then ").append(" 0 ").append(" else ").append(" 1 ").append(" end").append(')');
                            return;
                        }
                    }
                }
            }
            if (term.item.function == Function.BlobSize) {
                section.sql.append(" length(");
                entry.generateFieldAlias(fieldDescriptor, section.sql);
                section.sql.append(')');
            } else if (term.item.autoNotNull) {
                section.sql.append('(').append("case when ");
                entry.generateFieldAliasCasted(fieldDescriptor, section.sql);
                section.sql.append(" is null").append(" then ").append("''");
                section.sql.append(" else ").append("''").append(engine.caps.concatOperator);
                entry.generateFieldAliasCasted(fieldDescriptor, section.sql);
                section.sql.append(" end").append(')');
            } else {
                entry.generateFieldAliasCasted(fieldDescriptor, section.sql);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateItem(Search search, Engine engine, SearchField field, FieldExpression.Terms terms, Generate.Section section, String source, String line, int lineNo) {
        if (!terms.valid()) {
            return;
        }
        FieldExpression.Term term = terms.current();
        if (term == null) {
            return;
        }
        block4 : switch (term.item.kind) {
            case SystemField: {
                Generate.systemField(search, engine, term.item.fieldId, section);
                break;
            }
            case Field: {
                GenerateFieldExpression.generateFieldItem(term.item.entryId, term.item.fieldId, term, search, engine, section, source, line, lineNo);
                break;
            }
            case Function: {
                switch (term.item.function) {
                    case Add: {
                        if (field.dataType == DataType.STRING) {
                            section.sql.append(engine.caps.concatOperator);
                            break;
                        }
                        section.sql.append('+');
                        break;
                    }
                    case Div: {
                        section.sql.append('/');
                        break;
                    }
                    case Mul: {
                        section.sql.append('*');
                        break;
                    }
                    case Sub: {
                        section.sql.append('-');
                        break;
                    }
                    case Mod: {
                        terms.next();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                        section.sql.append(" % ");
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                        break;
                    }
                    case Day: 
                    case Month: 
                    case Year: 
                    case Hour: 
                    case Minute: 
                    case Second: 
                    case ExtractDate: {
                        section.sql.append(engine.caps.function(term.item.function.toCapsDatePart()));
                        terms.next();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                        section.sql.append(engine.caps.functionSuffix(term.item.function.toCapsDatePart()));
                        break;
                    }
                    case Quarter: {
                        section.sql.append("(").append("case ");
                        section.sql.append(engine.caps.function(1));
                        terms.next();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                        section.sql.append(engine.caps.functionSuffix(1));
                        section.sql.append(" when ").append('1').append(" then ").append('1').append(" when ").append('2').append(" then ").append('1').append(" when ").append('3').append(" then ").append('1');
                        section.sql.append(" when ").append('4').append(" then ").append('2').append(" when ").append('5').append(" then ").append('2').append(" when ").append('6').append(" then ").append('2');
                        section.sql.append(" when ").append('7').append(" then ").append('3').append(" when ").append('8').append(" then ").append('3').append(" when ").append('9').append(" then ").append('3');
                        section.sql.append(" when ").append("10").append(" then ").append('4').append(" when ").append("11").append(" then ").append('4').append(" when ").append("12").append(" then ").append('4');
                        section.sql.append(" else ").append("null").append(" end").append(")");
                        break;
                    }
                    case TruncDateYear: 
                    case TruncDateMonth: 
                    case TruncDateQuarter: 
                    case TruncDateHour: 
                    case TruncDateWeek: {
                        DatabaseCaps.TruncDateType tdt;
                        switch (term.item.function) {
                            case TruncDateYear: {
                                tdt = DatabaseCaps.TruncDateType.year;
                                break;
                            }
                            case TruncDateMonth: {
                                tdt = DatabaseCaps.TruncDateType.month;
                                break;
                            }
                            case TruncDateQuarter: {
                                tdt = DatabaseCaps.TruncDateType.quarter;
                                break;
                            }
                            case TruncDateHour: {
                                tdt = DatabaseCaps.TruncDateType.hour;
                                break;
                            }
                            case TruncDateWeek: {
                                tdt = DatabaseCaps.TruncDateType.week;
                                break;
                            }
                            default: {
                                tdt = DatabaseCaps.TruncDateType.none;
                            }
                        }
                        terms.next();
                        int index = terms.save();
                        engine.caps.truncDate(section.sql, () -> {
                            terms.reset(index);
                            GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                        }, tdt);
                        break;
                    }
                    case MonthEndDate: {
                        FieldExpression.Terms args = new FieldExpression.Terms();
                        args.add(new FieldExpression.Term(FieldExpression.Token.Argument, new FieldExpression.Item(1)));
                        args.add(new FieldExpression.Term(FieldExpression.Token.Argument, new FieldExpression.Item(-1)));
                        args.reset();
                        Generate.Section oneMonthSection = new Generate.Section();
                        Generate.Section oneDaySection = new Generate.Section();
                        Generate.Section beginMonthSection = new Generate.Section();
                        Generate.Section nextMonthSection = new Generate.Section();
                        terms.next();
                        int index = terms.save();
                        engine.caps.truncDate(beginMonthSection.sql, () -> {
                            terms.reset(index);
                            GenerateFieldExpression.generateOperator(search, engine, field, terms, beginMonthSection, true, source, line, lineNo);
                        }, DatabaseCaps.TruncDateType.month);
                        GenerateFieldExpression.generateOperator(search, engine, field, args, oneMonthSection, true, source, line, lineNo);
                        GenerateFieldExpression.generateOperator(search, engine, field, args, oneDaySection, true, source, line, lineNo);
                        nextMonthSection.sql.append(engine.caps.addMonthsBegin());
                        nextMonthSection.append(engine.caps.addMonthsDateFirstArg() ? beginMonthSection : oneMonthSection);
                        nextMonthSection.sql.append(engine.caps.addMonthsMiddle());
                        nextMonthSection.append(engine.caps.addMonthsDateFirstArg() ? oneMonthSection : beginMonthSection);
                        nextMonthSection.sql.append(engine.caps.addMonthsEnd());
                        section.sql.append(engine.caps.addDaysBegin());
                        section.append(nextMonthSection);
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.append(oneDaySection);
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.addDaysEnd());
                        break;
                    }
                    case RoundTo: 
                    case Trunc: {
                        Parameter p;
                        boolean roundTo = term.item.function == Function.RoundTo;
                        section.sql.append(roundTo ? "round(" : "trunc(");
                        int scale = term.item.scale;
                        if (term.item.fieldId != 0 && (p = search.findParameter(term.item.fieldId)) != null) {
                            scale = p.getIsIgnored() || p.getIsNull() ? 0 : p.getAsIntNumberByIndex(0);
                        }
                        terms.next();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                        if (roundTo || scale != 0) {
                            section.sql.append(',').append(scale);
                        }
                        section.sql.append(')');
                        break;
                    }
                    case NumberToString: {
                        section.sql.append(engine.caps.numberToStringFunction());
                        terms.next();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                        section.sql.append(engine.caps.numberToStringSuffix());
                        break;
                    }
                    case ToNumber: {
                        section.sql.append(engine.caps.toNumberFunction());
                        terms.next();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                        section.sql.append(engine.caps.toNumberSuffix());
                        break;
                    }
                    case NotNullValue: {
                        Parameter p;
                        FieldExpression.Item second = term.item;
                        if (second.fieldId != 0 && search.parameters != null && (p = search.parameters.get(second.fieldId)) != null && !p.getIsNull() && !p.getIsIgnored()) {
                            switch (p.getDataType().toSqlDataType()) {
                                case BOOLEAN: {
                                    second = new FieldExpression.Item(FieldExpression.Kind.Value, false);
                                    second.int_val = p.getAsIntNumberByIndex(0);
                                    second.dataType = DataType.BOOLEAN;
                                    break;
                                }
                                case INTEGER: {
                                    second = new FieldExpression.Item(FieldExpression.Kind.Value, false);
                                    second.int_val = p.getAsIntNumberByIndex(0);
                                    second.dataType = DataType.INTEGER;
                                    break;
                                }
                                case DOUBLE: {
                                    second = new FieldExpression.Item(FieldExpression.Kind.Value, false);
                                    second.dbl_val = p.getAsNumber();
                                    second.dataType = DataType.FLOAT;
                                    break;
                                }
                                case STRING: {
                                    second = new FieldExpression.Item(FieldExpression.Kind.Value, false);
                                    second.str_val = p.getAsString();
                                    second.dataType = DataType.STRING;
                                    break;
                                }
                                case UNICODE: {
                                    second = new FieldExpression.Item(FieldExpression.Kind.Value, false);
                                    second.str_val = p.getAsString();
                                    second.dataType = DataType.UNICODE;
                                    break;
                                }
                                case DATE_TIME: {
                                    second = new FieldExpression.Item(FieldExpression.Kind.Value, false);
                                    second.dbl_val = p.getAsNumber();
                                    second.dataType = DataType.DATE_TIME;
                                }
                            }
                        }
                        switch (field.dataType) {
                            case BOOLEAN: {
                                switch (second.dataType) {
                                    case STRING: 
                                    case UNICODE: {
                                        int int_val;
                                        try {
                                            int_val = Strings.isVoid(second.str_val) ? 0 : ValueCaster.toInt(second.str_val);
                                        }
                                        catch (NumberFormatException e) {
                                            int_val = 0;
                                        }
                                        second = new FieldExpression.Item(FieldExpression.Kind.Value, false);
                                        second.int_val = int_val;
                                        second.dataType = DataType.BOOLEAN;
                                        break;
                                    }
                                    case INTEGER: {
                                        second.dataType = DataType.BOOLEAN;
                                    }
                                }
                                break;
                            }
                            case INTEGER: {
                                int int_val;
                                if (second.dataType != DataType.STRING && second.dataType != DataType.UNICODE) break;
                                try {
                                    int_val = Strings.isVoid(second.str_val) ? 0 : ValueCaster.toInt(second.str_val);
                                }
                                catch (NumberFormatException e) {
                                    int_val = 0;
                                }
                                second = new FieldExpression.Item(FieldExpression.Kind.Value, false);
                                second.int_val = int_val;
                                second.dataType = DataType.INTEGER;
                                break;
                            }
                            case FLOAT: 
                            case DIRECTORY: 
                            case PRIMARY_KEY: 
                            case METATREE_NODE: {
                                double dbl_val;
                                if (second.dataType != DataType.STRING && second.dataType != DataType.UNICODE) break;
                                try {
                                    dbl_val = Strings.isVoid(second.str_val) ? 0.0 : ValueCaster.toDouble(second.str_val);
                                }
                                catch (NumberFormatException e) {
                                    dbl_val = 0.0;
                                }
                                second = new FieldExpression.Item(FieldExpression.Kind.Value, false);
                                second.dbl_val = dbl_val;
                                second.dataType = DataType.FLOAT;
                            }
                        }
                        int index = terms.save() + 1;
                        if (index < terms.size()) {
                            FieldDescriptor fieldDescriptor;
                            SearchEntry entry;
                            FieldExpression.Term next = (FieldExpression.Term)terms.get(index);
                            if (next.item != null && next.item.kind == FieldExpression.Kind.Field && (entry = search.entries.get(next.item.entryId)) != null && (fieldDescriptor = entry.getTableDescriptor().getFieldDescriptor(next.item.fieldId)) != null && fieldDescriptor.getType() == DataType.BOOLEAN) {
                                second.typeCast = FieldExpression.TypeCast.Bool;
                            }
                        }
                        section.sql.append(' ').append("coalesce(");
                        terms.next();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(',');
                        GenerateFieldExpression.generateValue(search, engine, field.dataType, second, section);
                        section.sql.append(')');
                        break;
                    }
                    case Abs: {
                        section.sql.append("abs(");
                        terms.next();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, source, line, lineNo);
                        section.sql.append(')');
                        break;
                    }
                    case RegexpSubstr: {
                        boolean brace;
                        terms.next();
                        if (terms.valid() && terms.current().token == FieldExpression.Token.OpenBrace) {
                            brace = true;
                            terms.next();
                        } else {
                            brace = false;
                        }
                        section.sql.append(engine.caps.regexpSubstrBegin());
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.regexpSubstrMiddle());
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.regexpSubstrEnd());
                        if (!terms.valid() || !brace || terms.current().token != FieldExpression.Token.CloseBrace) break block4;
                        terms.next();
                        break;
                    }
                    case AddMonths: {
                        boolean brace;
                        terms.next();
                        if (terms.valid() && terms.current().token == FieldExpression.Token.OpenBrace) {
                            brace = true;
                            terms.next();
                        } else {
                            brace = false;
                        }
                        Generate.Section dateSection = new Generate.Section();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, dateSection, true, source, line, lineNo);
                        Generate.Section monthsSection = new Generate.Section();
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, monthsSection, true, source, line, lineNo);
                        section.sql.append(engine.caps.addMonthsBegin());
                        section.append(engine.caps.addMonthsDateFirstArg() ? dateSection : monthsSection);
                        section.sql.append(engine.caps.addMonthsMiddle());
                        section.append(engine.caps.addMonthsDateFirstArg() ? monthsSection : dateSection);
                        section.sql.append(engine.caps.addMonthsEnd());
                        if (!terms.valid() || !brace || terms.current().token != FieldExpression.Token.CloseBrace) break block4;
                        terms.next();
                        break;
                    }
                    case AddDays: {
                        boolean brace;
                        terms.next();
                        if (terms.valid() && terms.current().token == FieldExpression.Token.OpenBrace) {
                            brace = true;
                            terms.next();
                        } else {
                            brace = false;
                        }
                        section.sql.append(engine.caps.addDaysBegin());
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.addDaysMiddle());
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.addDaysEnd());
                        if (!terms.valid() || !brace || terms.current().token != FieldExpression.Token.CloseBrace) break block4;
                        terms.next();
                        break;
                    }
                    case DateValue: {
                        boolean brace;
                        terms.next();
                        if (terms.valid() && terms.current().token == FieldExpression.Token.OpenBrace) {
                            brace = true;
                            terms.next();
                        } else {
                            brace = false;
                        }
                        section.sql.append(engine.caps.dateValueBegin());
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.dateValueEnd());
                        if (!terms.valid() || !brace || terms.current().token != FieldExpression.Token.CloseBrace) break block4;
                        terms.next();
                        break;
                    }
                    case DaysBetween: {
                        boolean brace;
                        terms.next();
                        if (terms.valid() && terms.current().token == FieldExpression.Token.OpenBrace) {
                            brace = true;
                            terms.next();
                        } else {
                            brace = false;
                        }
                        section.sql.append(engine.caps.daysBetweenBegin());
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.daysBetweenMiddle());
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.daysBetweenEnd());
                        if (!terms.valid() || !brace || terms.current().token != FieldExpression.Token.CloseBrace) break block4;
                        terms.next();
                        break;
                    }
                    case MonthsBetween: {
                        boolean brace;
                        terms.next();
                        if (terms.valid() && terms.current().token == FieldExpression.Token.OpenBrace) {
                            brace = true;
                            terms.next();
                        } else {
                            brace = false;
                        }
                        section.sql.append(engine.caps.monthsBetweenBegin());
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.monthsBetweenMiddle());
                        GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        section.sql.append(engine.caps.monthsBetweenEnd());
                        if (!terms.valid() || !brace || terms.current().token != FieldExpression.Token.CloseBrace) break block4;
                        terms.next();
                        break;
                    }
                    case ToDate: {
                        terms.next();
                        section.sql.append(engine.caps.stringToDateBegin());
                        DataType dataType = field.dataType;
                        try {
                            field.dataType = DataType.STRING;
                            GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                        }
                        finally {
                            field.dataType = dataType;
                        }
                        section.sql.append(engine.caps.stringToDateEnd());
                        break;
                    }
                    case FirstValue: {
                        boolean brace;
                        terms.next();
                        if (terms.valid() && terms.current().token == FieldExpression.Token.OpenBrace) {
                            brace = true;
                            terms.next();
                        } else {
                            brace = false;
                        }
                        section.sql.append("coalesce(");
                        int comma = 32;
                        while (terms.valid() && terms.current().token != FieldExpression.Token.Operator) {
                            section.sql.append((char)comma);
                            GenerateFieldExpression.generateOperator(search, engine, field, terms, section, true, source, line, lineNo);
                            if (terms.valid() && brace && terms.current().token == FieldExpression.Token.CloseBrace) {
                                terms.next();
                                break;
                            }
                            comma = 44;
                        }
                        section.sql.append(')');
                        break;
                    }
                    case AddSeparators: {
                        int count;
                        boolean brace;
                        ArrayList<StringBuilder> args = new ArrayList<StringBuilder>();
                        terms.next();
                        if (terms.valid() && terms.current().token == FieldExpression.Token.OpenBrace) {
                            brace = true;
                            terms.next();
                        } else {
                            brace = false;
                        }
                        while (terms.valid() && terms.current().token != FieldExpression.Token.Operator) {
                            Generate.Section arg = new Generate.Section();
                            GenerateFieldExpression.generateOperator(search, engine, field, terms, arg, true, source, line, lineNo);
                            assert (arg.sqlParameters.isEmpty());
                            args.add(arg.sql);
                            if (!terms.valid() || !brace || terms.current().token != FieldExpression.Token.CloseBrace) continue;
                            terms.next();
                            break;
                        }
                        if ((count = args.size()) == 0) break;
                        int i = 0;
                        while (i < count) {
                            if (i != 0) {
                                section.sql.append(' ').append(engine.caps.concatOperator).append(' ');
                            }
                            StringBuilder arg = (StringBuilder)args.get(i++);
                            section.sql.append("case when ").append((CharSequence)arg).append(" is not null").append(" then ");
                            if (i < count) {
                                StringBuilder sep = (StringBuilder)args.get(i++);
                                section.sql.append("case when ");
                                for (int j = i; j < count; j += 2) {
                                    if (j != i) {
                                        section.sql.append(Condition.LogicalOperator.OR.sql);
                                    }
                                    section.sql.append((CharSequence)args.get(j)).append(" is not null");
                                }
                                section.sql.append(" then ").append("''").append(engine.caps.concatOperator).append((CharSequence)arg).append(' ').append(engine.caps.concatOperator).append(' ').append((CharSequence)sep);
                                section.sql.append(" else ").append("''").append(engine.caps.concatOperator).append((CharSequence)arg).append(" end");
                            } else {
                                section.sql.append(' ').append("''").append(engine.caps.concatOperator).append((CharSequence)arg);
                            }
                            section.sql.append(" else ").append("''").append(" end");
                        }
                        break block4;
                    }
                    case PramValues: {
                        terms.next();
                        break;
                    }
                    case Inline: {
                        section.sql.append(' ').append(term.item.str_val).append(' ');
                        break;
                    }
                }
                break;
            }
            case Value: {
                GenerateFieldExpression.generateValue(search, engine, field.dataType, term.item, section);
                break;
            }
            case TypedValue: {
                if (!term.item.null_val && field.dataType == DataType.BOOLEAN && term.item.dataType == DataType.INTEGER) {
                    term.item.typeCast = FieldExpression.TypeCast.Bool;
                }
                GenerateFieldExpression.generateValue(search, engine, term.item.dataType, term.item, section);
                break;
            }
            case Parameter: {
                if (term.item.fieldId == 0) break;
                Parameter p = search.getValidParameter(term.item.fieldId, source, line, lineNo < 0 ? term.item.lineNo : lineNo);
                if (p.getDatasourceBinding() != 0 && p.getFieldBinding() != 0) {
                    Search deepSearch = search.getDeepSearch();
                    deepSearch = deepSearch.throughSearch(p.getParamBinding());
                    GenerateFieldExpression.generateFieldItem(p.getDatasourceBinding(), p.getFieldBinding(), term, deepSearch, engine, section, source, line, lineNo);
                    break;
                }
                if (p.getIsIgnored() || p.getValueCount() == 0) {
                    section.sql.append("null");
                    break;
                }
                Generate.parameterValues(search, engine.caps, section, p.getDataType(), p);
            }
        }
    }

    private static void generateValue(Search search, Engine engine, DataType dataType, FieldExpression.Item item, Generate.Section section) {
        if (item.null_val) {
            switch (dataType) {
                case INTEGER: 
                case FLOAT: 
                case INTERVAL: {
                    section.sql.append('0');
                    break;
                }
                case STRING: {
                    section.sql.append("''");
                    break;
                }
                default: {
                    section.sql.append("null");
                    engine.caps.typifySuffix(dataType, section.sql);
                    break;
                }
            }
        } else {
            block4 : switch (item.dataType.toSqlDataType()) {
                case BOOLEAN: {
                    if (item.int_val != 0) {
                        section.sql.append(engine.caps.c_bool2sql(true));
                        break;
                    }
                    section.sql.append(engine.caps.c_bool2sql(false));
                    break;
                }
                case INTEGER: {
                    if (item.typeCast == FieldExpression.TypeCast.Bool || search.convertFieldExprArgs() && dataType == DataType.BOOLEAN) {
                        if (item.int_val != 0) {
                            section.sql.append(engine.caps.c_bool2sql(true));
                            break;
                        }
                        section.sql.append(engine.caps.c_bool2sql(false));
                        break;
                    }
                    if (search.convertFieldExprArgs() && (dataType == DataType.STRING || dataType == DataType.UNICODE)) {
                        section.sql.append('\'').append(item.int_val).append('\'');
                        break;
                    }
                    section.sql.append(item.int_val);
                    break;
                }
                case DOUBLE: {
                    if (item.dataType == DataType.INTERVAL) {
                        section.sql.append(engine.caps.c_interval2sql(item.dbl_val));
                        break;
                    }
                    if (search.convertFieldExprArgs() && (dataType == DataType.STRING || dataType == DataType.UNICODE)) {
                        section.sql.append('\'').append(engine.caps.c_float2sql(item.dbl_val)).append('\'');
                        break;
                    }
                    section.sql.append(engine.caps.c_float2sql(item.dbl_val));
                    break;
                }
                case DATE_TIME: {
                    section.sql.append(engine.caps.c_dateTime2sql(item.dbl_val));
                    break;
                }
                case STRING: {
                    section.sql.append(engine.caps.c_string2sql(item.str_val));
                    engine.caps.typifySuffixCompat(DataType.STRING, section.sql);
                    break;
                }
                default: {
                    switch (dataType) {
                        case INTEGER: 
                        case FLOAT: 
                        case INTERVAL: {
                            section.sql.append('0');
                            break block4;
                        }
                        case STRING: {
                            section.sql.append("''");
                            break block4;
                        }
                    }
                    section.sql.append("null");
                    engine.caps.typifySuffix(dataType, section.sql);
                }
            }
        }
    }

    static FieldExpression.Terms parse(Search search, DatabaseCaps caps, SearchField field, ArrayList<FieldExpression.Item> items) {
        FieldExpression.Terms terms = new FieldExpression.Terms();
        if (items == null || items.isEmpty()) {
            return terms;
        }
        boolean expandParams = false;
        boolean add_open_brace = false;
        boolean add_close_brace = false;
        field.groupable(false);
        Object source = field.source;
        String line = field.line != null ? field.line : "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ";
        int lineNo = field.lineNo;
        if (source == null && field.proxyField != null) {
            source = "\u043f\u043e\u043b\u0435 " + field.proxyField.getCaption() + " [" + field.proxyField.getId() + "]";
        }
        int index = 0;
        block23: for (FieldExpression.Item item : items) {
            int i;
            item.lineNo = ++index;
            item.ignored = false;
            item.autoNotNull = false;
            if (item.braceCount > 0) {
                for (i = 0; i < item.braceCount; ++i) {
                    terms.add(new FieldExpression.Term(FieldExpression.Token.OpenBrace, null));
                }
            }
            if (add_open_brace) {
                if (item.kind != FieldExpression.Kind.Function) {
                    terms.add(new FieldExpression.Term(FieldExpression.Token.SoftBrace, null));
                    add_close_brace = true;
                }
                add_open_brace = false;
            }
            block0 : switch (item.kind) {
                case Field: {
                    expandParams = false;
                    field.groupable(true);
                    terms.add(new FieldExpression.Term(FieldExpression.Token.Argument, item));
                    break;
                }
                case SystemField: {
                    expandParams = false;
                    terms.add(new FieldExpression.Term(FieldExpression.Token.Argument, item));
                    break;
                }
                case Value: 
                case TypedValue: {
                    expandParams = false;
                    terms.add(new FieldExpression.Term(FieldExpression.Token.Argument, item));
                    if (!item.null_val) break;
                    item.ignored = true;
                    break;
                }
                case Function: {
                    expandParams = false;
                    switch (item.function) {
                        case Div: 
                        case Mul: 
                        case Sub: 
                        case Mod: 
                        case Add: {
                            terms.add(new FieldExpression.Term(FieldExpression.Token.Operator, item));
                            break block0;
                        }
                        case NONE: 
                        case Delimiter: 
                        case Unknown: {
                            break block0;
                        }
                        case NumberToString: 
                        case RegexpSubstr: 
                        case AddDays: 
                        case DaysBetween: 
                        case MonthsBetween: 
                        case FirstValue: 
                        case AddSeparators: {
                            terms.add(new FieldExpression.Term(FieldExpression.Token.Function, item));
                            break block0;
                        }
                        case BlobSize: {
                            terms.add(new FieldExpression.Term(FieldExpression.Token.Argument, item));
                            item.kind = FieldExpression.Kind.Field;
                            field.groupable(true);
                            break block0;
                        }
                        case Inline: {
                            terms.add(new FieldExpression.Term(FieldExpression.Token.Inline, item));
                            break block0;
                        }
                        case PramValues: {
                            terms.add(new FieldExpression.Term(FieldExpression.Token.Function, item));
                            expandParams = true;
                            break block0;
                        }
                    }
                    terms.add(new FieldExpression.Term(FieldExpression.Token.Function, item));
                    add_open_brace = true;
                    break;
                }
                case Parameter: {
                    terms.add(new FieldExpression.Term(FieldExpression.Token.Argument, item));
                    if (expandParams) {
                        expandParams = false;
                        break;
                    }
                    if (item.fieldId != 0) {
                        Parameter p;
                        if (field.lineNo < 0) {
                            lineNo = item.lineNo;
                        }
                        if ((p = search.parameters.get(item.fieldId)) == null || p.getIsIgnored() || p.getValueCount() == 0) {
                            item.ignored = true;
                            break;
                        }
                        if (p.getDatasourceBinding() != 0 && p.getFieldBinding() != 0) {
                            Search deepSearch = search.getDeepSearch();
                            deepSearch = deepSearch.throughSearch(p.getParamBinding());
                            SearchEntry entry = deepSearch.getValidEntry(p.getDatasourceBinding(), (String)source, line, lineNo);
                            entry.getValidFieldDescriptor(p.getFieldBinding(), (String)source, line, lineNo);
                            break;
                        }
                        if (p.getIsNull()) {
                            item.ignored = false;
                            item.kind = FieldExpression.Kind.Value;
                            item.null_val = true;
                            break;
                        }
                        switch (p.getDataType().toSqlDataType()) {
                            case BOOLEAN: {
                                item.kind = FieldExpression.Kind.Value;
                                item.int_val = p.getAsIntNumberByIndex(0);
                                item.dataType = DataType.BOOLEAN;
                                item.typeCast = FieldExpression.TypeCast.Bool;
                                break block0;
                            }
                            case INTEGER: {
                                item.kind = FieldExpression.Kind.Value;
                                item.int_val = p.getAsIntNumberByIndex(0);
                                item.dataType = DataType.INTEGER;
                                item.typeCast = FieldExpression.TypeCast.NONE;
                                break block0;
                            }
                            case DOUBLE: {
                                item.kind = FieldExpression.Kind.Value;
                                item.dbl_val = p.getAsNumber();
                                if (p.getDataType() == DataType.INTERVAL) {
                                    item.dataType = DataType.INTERVAL;
                                    break block0;
                                }
                                item.dataType = DataType.FLOAT;
                                break block0;
                            }
                            case STRING: {
                                item.kind = FieldExpression.Kind.Value;
                                item.str_val = p.getAsString();
                                item.dataType = DataType.STRING;
                                break block0;
                            }
                            case DATE_TIME: {
                                item.kind = FieldExpression.Kind.Value;
                                item.dbl_val = p.getAsNumber();
                                item.dataType = DataType.DATE_TIME;
                                break block0;
                            }
                            case UNICODE: {
                                item.kind = FieldExpression.Kind.Value;
                                item.str_val = p.getAsString();
                                item.dataType = DataType.UNICODE;
                                break block0;
                            }
                        }
                        item.ignored = true;
                        break;
                    }
                    item.ignored = true;
                    break;
                }
                default: {
                    continue block23;
                }
            }
            if (add_close_brace) {
                terms.add(new FieldExpression.Term(FieldExpression.Token.CloseSoftBrace, null));
                add_close_brace = false;
            }
            if (item.braceCount >= 0) continue;
            for (i = item.braceCount; i < 0; ++i) {
                terms.add(new FieldExpression.Term(FieldExpression.Token.CloseBrace, null));
            }
        }
        Token token = GenerateFieldExpression.build(terms, search, (String)source, line, lineNo);
        terms.clear();
        if (token != null) {
            token.adjustIgnore();
            if (!token.ignored) {
                token.adjustAutoNVL(search, caps, field.dataType, (String)source, line, field.lineNo);
                GenerateFieldExpression.buildExpression(token, terms);
            }
        }
        return terms;
    }

    private static Token build(FieldExpression.Terms terms, Search search, String source, String line, int lineNo) {
        terms.reset();
        return GenerateFieldExpression.buildAddSub(terms, search, source, line, lineNo);
    }

    private static Token buildAddSub(FieldExpression.Terms terms, Search search, String source, String line, int lineNo) {
        Token left = GenerateFieldExpression.buildMulDiv(terms, search, source, line, lineNo);
        if (left != null) {
            while (terms.valid()) {
                FieldExpression.Term term = terms.current();
                if (term.token != FieldExpression.Token.Operator) {
                    return left;
                }
                switch (term.item.function) {
                    case Sub: 
                    case Add: {
                        break;
                    }
                    default: {
                        return left;
                    }
                }
                terms.next();
                Token right = GenerateFieldExpression.buildMulDiv(terms, search, source, line, lineNo);
                if (right == null) {
                    return left;
                }
                left = new Token(term, left, right);
            }
        }
        return left;
    }

    private static Token buildMulDiv(FieldExpression.Terms terms, Search search, String source, String line, int lineNo) {
        Token left = GenerateFieldExpression.buildValue(terms, search, source, line, lineNo);
        if (left != null) {
            while (terms.valid()) {
                FieldExpression.Term term = terms.current();
                switch (term.token) {
                    case Operator: {
                        break;
                    }
                    case Inline: {
                        Token arg = left;
                        while (terms.valid() && terms.current().token == FieldExpression.Token.Inline) {
                            if (arg.left == null) {
                                arg.left = GenerateFieldExpression.buildValue(terms, search, source, line, lineNo);
                            } else {
                                arg = left = new Token(concatTerm, left, GenerateFieldExpression.buildValue(terms, search, source, line, lineNo));
                            }
                            arg = arg.left;
                        }
                        if (terms.valid() && terms.current().token == FieldExpression.Token.Operator) break;
                    }
                    default: {
                        return left;
                    }
                }
                term = terms.current();
                switch (term.item.function) {
                    case Div: 
                    case Mul: 
                    case Mod: {
                        break;
                    }
                    default: {
                        return left;
                    }
                }
                terms.next();
                Token right = GenerateFieldExpression.buildValue(terms, search, source, line, lineNo);
                if (right == null) {
                    return left;
                }
                left = new Token(term, left, right);
            }
        }
        return left;
    }

    private static Token buildValue(FieldExpression.Terms terms, Search search, String source, String line, int lineNo) {
        Token value = null;
        if (terms.valid()) {
            FieldExpression.Term term = terms.current();
            switch (term.token) {
                case Argument: {
                    value = new Token(term);
                    terms.next();
                    return value;
                }
                case Function: {
                    value = new Token(term);
                    terms.next();
                    block7 : switch (term.item.function) {
                        case RegexpSubstr: 
                        case AddMonths: 
                        case AddDays: 
                        case DaysBetween: 
                        case MonthsBetween: 
                        case FirstValue: 
                        case AddSeparators: {
                            boolean brace;
                            if (terms.valid() && terms.current().token == FieldExpression.Token.OpenBrace) {
                                value.left = new Token(terms);
                                brace = true;
                                terms.next();
                            } else {
                                brace = false;
                            }
                            while (terms.valid() && terms.current().token != FieldExpression.Token.Operator) {
                                Token token = GenerateFieldExpression.buildAddSub(terms, search, source, line, lineNo);
                                if (token == null) {
                                    if (line == null) {
                                        line = "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ";
                                    }
                                    int no = lineNo < 0 ? terms.size() : lineNo;
                                    throw new Search.Exception(search, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0432 " + source + " (" + line + ": " + no + ")");
                                }
                                value.addArg(token);
                                if (!terms.valid() || !brace || terms.current().token != FieldExpression.Token.CloseBrace) continue;
                                value.right = new Token(terms);
                                terms.next();
                                break block7;
                            }
                            break;
                        }
                        default: {
                            value.left = GenerateFieldExpression.buildAddSub(terms, search, source, line, lineNo);
                        }
                    }
                    if (terms.valid() && terms.current().token == FieldExpression.Token.CloseSoftBrace) {
                        if (value.left != null) {
                            value.left.right = new Token(terms);
                        }
                        terms.next();
                    }
                    return value;
                }
                case OpenBrace: {
                    value = new Token(terms);
                    terms.next();
                    value.left = GenerateFieldExpression.buildAddSub(terms, search, source, line, lineNo);
                    if (terms.valid() && terms.current().token == FieldExpression.Token.CloseBrace) {
                        value.right = new Token(terms);
                        terms.next();
                    }
                    return value;
                }
                case SoftBrace: {
                    value = new Token(terms);
                    terms.next();
                    value.left = GenerateFieldExpression.buildValue(terms, search, source, line, lineNo);
                    if (terms.valid() && terms.current().token == FieldExpression.Token.CloseSoftBrace) {
                        value.right = new Token(terms);
                        terms.next();
                    }
                    return value;
                }
                case Inline: {
                    value = new Token(terms);
                    terms.next();
                    if (terms.valid() && terms.current().token != FieldExpression.Token.Operator) {
                        value.left = GenerateFieldExpression.buildAddSub(terms, search, source, line, lineNo);
                    }
                    if (!terms.valid() || terms.current().token != FieldExpression.Token.Inline) break;
                    value.right = GenerateFieldExpression.buildAddSub(terms, search, source, line, lineNo);
                }
            }
        }
        return value;
    }

    private static void buildExpression(Token token, FieldExpression.Terms terms) {
        if (token == null) {
            return;
        }
        switch (token.term.token) {
            case Operator: {
                if (token.term.item.function == Function.Mod) {
                    terms.add(new FieldExpression.Term(FieldExpression.Token.Function, token.term.item));
                    if (token.left != null) {
                        terms.add(osb);
                        GenerateFieldExpression.buildExpression(token.left, terms);
                        terms.add(csb);
                    }
                    if (token.right == null) break;
                    terms.add(osb);
                    GenerateFieldExpression.buildExpression(token.right, terms);
                    terms.add(csb);
                    break;
                }
                GenerateFieldExpression.buildExpression(token.left, terms);
                terms.add(token.term);
                GenerateFieldExpression.buildExpression(token.right, terms);
                break;
            }
            case Argument: {
                terms.add(token.term);
                if (token.left == null) break;
                GenerateFieldExpression.buildExpression(token.left, terms);
                break;
            }
            case Function: {
                switch (token.term.item.function) {
                    case RegexpSubstr: 
                    case AddMonths: 
                    case AddDays: 
                    case DaysBetween: 
                    case MonthsBetween: 
                    case FirstValue: 
                    case AddSeparators: {
                        terms.add(token.term);
                        if (token.left != null) {
                            terms.add(token.left.term);
                        }
                        for (Token arg : token.args) {
                            if (arg.ignored) continue;
                            GenerateFieldExpression.buildExpression(arg, terms);
                        }
                        if (token.right != null) {
                            terms.add(token.right.term);
                        }
                        return;
                    }
                }
            }
            case OpenBrace: 
            case SoftBrace: {
                terms.add(token.term);
                GenerateFieldExpression.buildExpression(token.left, terms);
                if (token.right == null) break;
                terms.add(token.right.term);
                break;
            }
            case Inline: {
                terms.add(token.term);
                if (token.left != null) {
                    GenerateFieldExpression.buildExpression(token.left, terms);
                }
                if (token.right == null) break;
                GenerateFieldExpression.buildExpression(token.right, terms);
                break;
            }
            case Concat: {
                if (token.left != null) {
                    GenerateFieldExpression.buildExpression(token.left, terms);
                }
                if (token.right == null) break;
                GenerateFieldExpression.buildExpression(token.right, terms);
            }
        }
    }

    private static class Token {
        FieldExpression.Term term;
        Token left;
        Token right;
        ArrayList<Token> args = null;
        boolean ignored = false;
        private int canNotAutoNVLCount;

        Token(FieldExpression.Term term) {
            this(term, null, null);
        }

        Token(FieldExpression.Terms terms) {
            this(terms.current(), null, null);
        }

        Token(FieldExpression.Term term, Token left, Token right) {
            this.term = term;
            this.left = left;
            this.right = right;
        }

        boolean argsEmpty() {
            return this.args == null || this.args.isEmpty();
        }

        void addArg(Token arg) {
            if (this.args == null) {
                this.args = new ArrayList();
            }
            this.args.add(arg);
        }

        void adjustIgnore() {
            boolean bl = this.ignored = this.term.item != null && this.term.item.ignored;
            if (this.ignored) {
                return;
            }
            if (this.left != null) {
                this.left.adjustIgnore();
            }
            if (this.right != null) {
                this.right.adjustIgnore();
            }
            if (!this.argsEmpty()) {
                for (Token arg : this.args) {
                    arg.adjustIgnore();
                    if (arg.ignored) continue;
                    this.ignored = false;
                }
            } else {
                switch (this.term.token) {
                    case Operator: {
                        this.ignored = !(this.left != null && !this.left.ignored || this.right != null && !this.right.ignored);
                        break;
                    }
                    case Inline: {
                        this.ignored = !(this.left == null && this.right == null || this.left != null && !this.left.ignored || this.right != null && !this.right.ignored);
                        break;
                    }
                    case OpenBrace: 
                    case SoftBrace: 
                    case Function: {
                        this.ignored = this.left == null || this.left.ignored;
                    }
                }
            }
        }

        void adjustAutoNVL(Search search, DatabaseCaps caps, DataType dataType, String source, String line, int lineNo) {
            if (caps != DatabaseCaps.POSTGRESQL) {
                return;
            }
            switch (dataType) {
                case STRING: 
                case UNICODE: {
                    this.canNotAutoNVLCount = 0;
                    if (this.canNotAutoNVLString(this) || this.canNotAutoNVLCount <= 1) {
                        return;
                    }
                    this.adjustAutoNvlString(search, source, line, lineNo);
                    break;
                }
            }
        }

        private void adjustAutoNvlString(Search search, String source, String line, int lineNo) {
            if (this.ignored) {
                return;
            }
            if (this.term.item != null && this.term.item.kind == FieldExpression.Kind.Field && this.term.item.entryId != -1 && this.term.item.entryId != -10) {
                this.term.item.autoNotNull = true;
            }
            if (this.left != null) {
                this.left.adjustAutoNvlString(search, source, line, lineNo);
            }
            if (this.right != null) {
                this.right.adjustAutoNvlString(search, source, line, lineNo);
            }
        }

        private boolean canNotAutoNVLString(Token calc) {
            if (this.ignored) {
                return false;
            }
            if (this.term.item != null) {
                block0 : switch (this.term.item.kind) {
                    case Function: {
                        switch (this.term.item.function) {
                            case Add: 
                            case NONE: {
                                break block0;
                            }
                        }
                        return true;
                    }
                    case Field: 
                    case SystemField: 
                    case Value: 
                    case TypedValue: 
                    case Parameter: {
                        break;
                    }
                    default: {
                        return true;
                    }
                }
            }
            ++calc.canNotAutoNVLCount;
            if (this.left != null && this.left.canNotAutoNVLString(calc)) {
                return true;
            }
            return this.right != null && this.right.canNotAutoNVLString(calc);
        }
    }
}

