/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.sql.engine.DataEntry;
import inform.agent.db.sql.engine.Engine;
import inform.agent.db.sql.engine.Generate;
import inform.agent.db.sql.engine.GenerateFieldExpression;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.sql.engine.SearchField;
import java.util.ArrayList;

public class HierarchicEntry
extends DataEntry {
    ArrayList<SearchField> additionalFields = null;
    private final String recursionName;

    public HierarchicEntry(int entryId, Search search, boolean root, String recursionName) {
        super(entryId, SearchEntry.Kind.Hierarchic, search.rootTableId());
        this.recursionName = recursionName;
        this.owner = search;
        this.owner.entries.add(this);
        if (root && !search.rootEntry.isEmpty()) {
            for (SearchEntry entry : search.rootEntry.children) {
                this.addEntry(entry);
            }
        }
    }

    public void setAdditionalFields(ArrayList<SearchField> additionalFields) {
        this.additionalFields = new ArrayList<SearchField>(additionalFields);
    }

    @Override
    public double entryNodeId() {
        return 0.0;
    }

    private SearchField findField(int fieldId) {
        if (this.additionalFields != null) {
            for (SearchField field : this.additionalFields) {
                if (field.id != fieldId) continue;
                return field;
            }
        }
        return this.owner.fields.find(fieldId);
    }

    @Override
    public FieldDescriptor getValidFieldDescriptor(int fieldId) {
        SearchField field = this.findField(fieldId);
        if (field == null || field.proxyField == null) {
            return super.getValidFieldDescriptor(fieldId);
        }
        return field.proxyField;
    }

    @Override
    public FieldDescriptor getValidFieldDescriptor(int fieldId, String source, String line, int lineNo) {
        SearchField field = this.findField(fieldId);
        if (field == null || field.proxyField == null) {
            return super.getValidFieldDescriptor(fieldId, source, line, lineNo);
        }
        return field.proxyField;
    }

    @Override
    public void generateTableRawName(StringBuilder sql) {
        if (this.recursionName == null) {
            super.generateTableRawName(sql);
        } else {
            TableDescriptor table = this.getTableDescriptor();
            sql.append(this.recursionName);
        }
    }

    @Override
    public void checkEntry(boolean check) {
        super.checkEntry(false);
    }

    @Override
    public boolean generateSystemFieldAlias(Search search, Engine engine, int fieldId, Generate.Section section) {
        switch (fieldId) {
            case 1: {
                SearchField field = this.owner.fields.findMapField(-10, 1);
                if (field == null) {
                    return super.generateSystemFieldAlias(search, engine, fieldId, section);
                }
                GenerateFieldExpression.generate(search, engine, false, section, field);
                return true;
            }
        }
        return super.generateSystemFieldAlias(search, engine, fieldId, section);
    }
}

