/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.agent.db.TableDescriptor;
import java.util.ArrayList;

public class PeriodicTables {
    ArrayList<Table> tables = null;
    int refCount = 0;

    public PeriodicTables(TableDescriptor periodicTable) {
        ArrayList<TableDescriptor.PeriodicTableStorage> storageList = periodicTable.getPeriodicTableStorageList();
        if (storageList != null && !storageList.isEmpty()) {
            for (TableDescriptor.PeriodicTableStorage storage : storageList) {
                if (this.tables == null) {
                    this.tables = new ArrayList();
                }
                this.tables.add(new Table(storage));
            }
        }
    }

    public boolean isEmpty() {
        return this.refCount == 0;
    }

    public Table find(double tableId) {
        if (this.tables != null) {
            for (Table table : this.tables) {
                if (table.storage.tableId != tableId) continue;
                return table;
            }
        }
        return null;
    }

    public void add(double tableId) {
        Table t = this.find(tableId);
        if (t != null) {
            if (t.table == null) {
                t.table = TableDescriptor.getIfExists(t.storage.tableId);
            }
            if (t.table != null) {
                ++this.refCount;
            }
        }
    }

    public static class Table {
        public final TableDescriptor.PeriodicTableStorage storage;
        public TableDescriptor table;
        public int entryId;

        public Table(TableDescriptor.PeriodicTableStorage storage) {
            this.storage = storage;
            this.table = null;
        }
    }
}

