/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.sql.engine.AggregateFunction;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.types.DataType;

public class SearchField {
    public final int id;
    public AggregateFunction function = AggregateFunction.NONE;
    public FieldExpression expression = null;
    public int position = -1;
    public DataType dataType = DataType.NONE;
    public FieldDescriptor proxyField;
    public int mapEntryId = 0;
    public int mapFieldId = 0;
    public String source = null;
    public String line = null;
    public int lineNo;
    private static final byte PROP_groupable = 1;
    private static final byte PROP_ignored = 2;
    private static final byte PROP_markIgnored = 4;
    private static final byte PROP_generated = 8;
    private static final byte PROP_hierarchicSort = 16;
    private byte props = 0;

    public SearchField(int id) {
        this.id = id;
    }

    public SearchField(SearchField field, boolean aggregativeFunction) {
        this.id = field.id;
        if (aggregativeFunction) {
            this.function = field.function;
        }
        this.expression = field.expression == null ? null : new FieldExpression(field.expression);
        this.dataType = field.dataType;
        this.proxyField = field.proxyField;
        this.mapEntryId = field.mapEntryId;
        this.mapFieldId = field.mapFieldId;
        this.source = field.source;
        this.line = field.line;
        this.lineNo = field.lineNo;
        this.props = field.props;
    }

    public SearchField(SearchField field, DataType dataType) {
        this.id = field.id;
        this.expression = field.expression == null ? null : new FieldExpression(field.expression);
        this.dataType = dataType;
        this.proxyField = field.proxyField;
        this.mapEntryId = field.mapEntryId;
        this.mapFieldId = field.mapFieldId;
        this.source = field.source;
        this.line = field.line;
        this.lineNo = field.lineNo;
        this.props = field.props;
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public boolean groupable() {
        return (this.props & 1) != 0;
    }

    public void groupable(boolean value) {
        this.props = value ? (byte)(this.props | 1) : (byte)(this.props & 0xFFFFFFFE);
    }

    public boolean ignored() {
        return (this.props & 2) != 0;
    }

    public void ignored(boolean value) {
        this.props = value ? (byte)(this.props | 2) : (byte)(this.props & 0xFFFFFFFD);
    }

    public boolean markIgnored() {
        return (this.props & 4) != 0;
    }

    public void markIgnored(boolean value) {
        this.props = value ? (byte)(this.props | 4) : (byte)(this.props & 0xFFFFFFFB);
    }

    public boolean generated() {
        return (this.props & 8) != 0;
    }

    public void generated(boolean value) {
        this.props = value ? (byte)(this.props | 8) : (byte)(this.props & 0xFFFFFFF7);
    }

    public boolean hierarchicSort() {
        return (this.props & 0x10) != 0;
    }

    public void hierarchicSort(boolean value) {
        this.props = value ? (byte)(this.props | 0x10) : (byte)(this.props & 0xFFFFFFEF);
    }

    class Extra
    extends FieldDescriptor {
        public int mapEntryId;
        public int mapFieldId;
        public boolean mapSort;

        public Extra(int id, String rawName, DataType type, int size, boolean nullable) {
            super(id, rawName, type, size, nullable);
        }

        public Extra(int id, int index, String rawName, String caption, double refTableId) {
            super(id, index, rawName, caption, refTableId);
        }

        public boolean hasMapping() {
            return this.mapEntryId != 0 || this.mapFieldId != 0;
        }
    }
}

