/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.scripts.ParametersList;
import java.io.IOException;

public class SubjectEntry
extends SearchEntry {
    public SubjectEntry(int entryId, Search search) {
        super(entryId, SearchEntry.Kind.Subject, search.rootTableId());
        this.inplaceSearch = search;
    }

    public SubjectEntry(Search owner, SubjectEntry entry) {
        super(entry.entryId, SearchEntry.Kind.Subject, entry.tableId);
        this.owner = owner;
        this.props = entry.props;
        this.alias = entry.alias;
        this.description = entry.description;
        this.inplaceSearch = entry.inplaceSearch;
    }

    @Override
    public void loaded() {
        if (this.inplaceSearch != null) {
            this.tableId = this.inplaceSearch.rootTableId();
        }
        super.loaded();
    }

    @Override
    public double entryNodeId() {
        return this.inplaceSearch.searchNodeId;
    }

    @Override
    boolean isSubject() {
        return true;
    }

    @Override
    public int initNestedAlias(int alias) {
        if (this.inplaceSearch != null) {
            alias = this.inplaceSearch.initEntryAlias(alias);
        }
        return alias;
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 9: {
                if (this.inplaceSearch == null || this.inplaceSearch.parameters == null) break;
                this.inplaceSearch.parameters.load(this.inplaceSearch.constants, in.getSubStreamReader(), Core.serverTimeZoneHost, true);
                this.inplaceSearch.parameters.makeWrapUp();
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    public ParametersList parameters() {
        return this.inplaceSearch != null ? this.inplaceSearch.parameters : null;
    }
}

