/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.types;

import inform.adt.InformException;
import inform.adt.taggedio.LittleEndianDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class BlobValueId {
    private int kind;
    private double tableId;
    private double rowId;
    private int fieldId;
    public static final int size = 24;

    public BlobValueId(byte[] raw) throws InformException, IOException {
        if (raw == null || raw.length != 24) {
            throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0434\u0435\u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 BLOB");
        }
        LittleEndianDataInputStream stream = new LittleEndianDataInputStream(new ByteArrayInputStream(raw));
        this.kind = stream.readInt();
        this.tableId = stream.readDouble();
        this.rowId = stream.readDouble();
        this.fieldId = stream.readInt();
    }

    public BlobValueId(double tableId, int fieldId, double rowId) {
        this.kind = 0;
        this.tableId = tableId;
        this.fieldId = fieldId;
        this.rowId = rowId;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public int getKind() {
        return this.kind;
    }

    public double getRowId() {
        return this.rowId;
    }

    public double getTableId() {
        return this.tableId;
    }
}

