/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.types;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.SqlDataType;

public enum DataType {
    PRIMARY_KEY(-1, 8, SqlDataType.DOUBLE, true, 8),
    NONE(0, 0, SqlDataType.UNSUPPORTED, true, 0),
    INTEGER(1, 4, SqlDataType.INTEGER, true, 4),
    FLOAT(2, 8, SqlDataType.DOUBLE, true, 8),
    STRING(3, 12, SqlDataType.STRING, false, -1),
    DATE_TIME(4, 91, SqlDataType.DATE_TIME, true, 8),
    INTERVAL(5, 8, SqlDataType.DOUBLE, true, 8),
    DIRECTORY(6, 8, SqlDataType.DOUBLE, true, 8),
    BOOLEAN(7, 16, SqlDataType.BOOLEAN, true, 4),
    BLOB(8, 2004, SqlDataType.BLOB, false, -1),
    FILE(9, 12, SqlDataType.FILE, false, -1),
    METATREE_NODE(10, 8, SqlDataType.DOUBLE, true, 4),
    VARIANT(11, 0, SqlDataType.UNSUPPORTED, false, 0),
    BIG_NUMBER(12, 8, SqlDataType.STRING, true, -1),
    UNICODE(13, -9, SqlDataType.UNICODE, false, -1),
    GEOMETRY(14, 2002, SqlDataType.GEOMETRY, false, -1);

    public static final int JST_UNDEFINED = 0;
    public static final int JST_INT = 1;
    public static final int JST_DOUBLE = 2;
    public static final int JST_HOST_STRING = 3;
    public static final int JST_HOST_OBJECT = 4;
    public static final int JST_BOOL = 5;
    public static final int JST_DATETIME = 7;
    public static final int JST_WIDE_STRING = 8;
    public static final int JST_ARRAY = 9;
    public static final int JST_TAGGED_JSO = 10;
    public static final int JST_DECIMAL = 11;
    private final int typeId;
    private final boolean isNumeric;
    private final int sqlType;
    private final SqlDataType sqlDataType;
    private final boolean isDoublePresentation;
    private final boolean isNumberPresentation;
    private final int binarySize;

    private DataType(int typeId, int sqlType, SqlDataType sqlDataType, boolean isNumeric, int binarySize) {
        this.typeId = typeId;
        this.isNumeric = isNumeric;
        this.sqlType = sqlType;
        this.sqlDataType = sqlDataType;
        this.isNumberPresentation = isNumeric && typeId != 4 && typeId != 12;
        this.isDoublePresentation = this.isNumberPresentation && typeId != 1;
        this.binarySize = binarySize;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int toInt() {
        return this.typeId;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public boolean isDoublePresentation() {
        return this.isDoublePresentation;
    }

    public boolean isNumberPresentation() {
        return this.isNumberPresentation;
    }

    public static DataType getDataTypeById(int typeId) {
        for (DataType t : DataType.values()) {
            if (t.getTypeId() != typeId) continue;
            return t;
        }
        return NONE;
    }

    public static DataType getDataTypeByJST(int jst) {
        switch (jst) {
            case 1: {
                return INTEGER;
            }
            case 2: 
            case 11: {
                return FLOAT;
            }
            case 3: {
                return STRING;
            }
            case 8: {
                return UNICODE;
            }
            case 5: {
                return BOOLEAN;
            }
            case 7: {
                return DATE_TIME;
            }
        }
        return NONE;
    }

    public static FieldDescriptor.BlobRawType getBlobRawType(int typeId) {
        switch (typeId) {
            case 2005: 
            case 2011: {
                return FieldDescriptor.BlobRawType.TEXT;
            }
        }
        return FieldDescriptor.BlobRawType.BINARY;
    }

    public static DataType getDataTypeBySqlTypeId(int typeId) {
        switch (typeId) {
            case -6: 
            case 4: 
            case 5: {
                return INTEGER;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return FLOAT;
            }
            case -1: 
            case 1: 
            case 12: {
                return STRING;
            }
            case 91: 
            case 92: 
            case 93: {
                return DATE_TIME;
            }
            case -7: 
            case 16: {
                return BOOLEAN;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: 
            case 2011: {
                return BLOB;
            }
            case -16: 
            case -15: 
            case -9: {
                return UNICODE;
            }
            case 1111: 
            case 2002: {
                return GEOMETRY;
            }
        }
        return NONE;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getSqlType(FieldDescriptor.BlobRawType blobRawType) {
        if (this == BLOB && blobRawType == FieldDescriptor.BlobRawType.TEXT) {
            return 2005;
        }
        return this.sqlType;
    }

    public int getBinarySize() {
        return this.binarySize;
    }

    public SqlDataType toSqlDataType() {
        return this.sqlDataType;
    }

    public boolean canHoldsIn(DataType in) {
        switch (this.sqlType) {
            case 4: {
                if (in.sqlType != 8) break;
                return true;
            }
        }
        return this.sqlType == in.sqlType;
    }
}

