/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.DateTime;
import inform.adt.NumberConverter;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlParameterValue;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public class SqlBatchParameter {
    private SqlDataType type;
    private ArrayList<SqlParameterValue> values = new ArrayList();
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public SqlBatchParameter() {
        this.type = SqlDataType.UNSUPPORTED;
    }

    public SqlDataType getType() {
        return this.type;
    }

    public void setType(SqlDataType type) {
        this.type = type;
    }

    public void setBatchCount(int count) {
        while (this.values.size() < count) {
            this.values.add(new SqlParameterValue());
        }
        while (count < this.values.size()) {
            this.values.remove(count);
        }
    }

    public SqlParameterValue get(int batchIndex) {
        return this.values.get(batchIndex);
    }

    private static void appendBytes(StringBuilder out, byte[] data) {
        out.append('[').append(data.length).append('x');
        for (int i = 0; i < Math.min(32, data.length); ++i) {
            byte b = data[i];
            out.append(HEX[b >> 4 & 0xF]);
            out.append(HEX[b & 0xF]);
        }
        if (data.length > 32) {
            out.append("...");
        }
        out.append(']');
    }

    public void logParamValue(int batchIndex, StringBuilder msg) {
        SqlParameterValue value = this.values.get(batchIndex);
        if (value.isNull()) {
            msg.append("null");
        } else {
            switch (this.type) {
                case BOOLEAN: 
                case INTEGER: 
                case DOUBLE: {
                    msg.append(NumberConverter.doubleToString(value.getNumber()));
                    break;
                }
                case DATE_TIME: {
                    msg.append(DateTime.toLogString(value.getNumber()));
                    break;
                }
                case TIMESTAMP: {
                    msg.append(DateTime.toLogString(DateTime.fromUnixTime(value.getTimestamp())));
                    break;
                }
                case STRING: 
                case UNICODE: {
                    msg.append(value.getString());
                    break;
                }
                case BLOB: 
                case GEOMETRY: {
                    SqlBatchParameter.appendBytes(msg, value.getBlob());
                    break;
                }
                default: {
                    msg.append("???");
                }
            }
        }
    }

    public void transferTo(int paramIndex, int batchIndex, PreparedStatement statement) throws SQLException {
        SqlParameterValue value = this.values.get(batchIndex);
        if (value.isNull()) {
            statement.setNull(paramIndex, this.type);
        } else {
            switch (this.type) {
                case INTEGER: {
                    statement.setInt(paramIndex, (int)value.getNumber());
                    break;
                }
                case BOOLEAN: {
                    statement.setBoolean(paramIndex, value.bool);
                    break;
                }
                case DOUBLE: {
                    statement.setDouble(paramIndex, value.getNumber());
                    break;
                }
                case DATE_TIME: {
                    statement.setDateTime(paramIndex, value.getNumber());
                    break;
                }
                case STRING: {
                    statement.setString(paramIndex, value.getString());
                    break;
                }
                case UNICODE: {
                    statement.setNString(paramIndex, value.getString());
                    break;
                }
                case BLOB: {
                    statement.setBlob(paramIndex, value.getBlob());
                    break;
                }
                case TIMESTAMP: {
                    statement.setTimestamp(paramIndex, new Timestamp(value.getTimestamp()));
                    break;
                }
                case GEOMETRY: {
                    statement.setGeometry(paramIndex, value.getGeom());
                    break;
                }
                case FILE: {
                    statement.setString(paramIndex, value.getString());
                    break;
                }
                default: {
                    statement.setNull(paramIndex, this.type);
                }
            }
        }
    }
}

