/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlCommand;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;

public class SqlExecutor
extends SqlCommand {
    private PreparedStatement statement = null;
    private String lastSqlText = null;
    private final DatabaseConnection database;
    private final SSContext ssContext;

    public SqlExecutor(SSContext ssContext, DatabaseConnection database) {
        this.ssContext = ssContext;
        this.database = database;
    }

    public int executeUpdateCached() throws SQLException {
        if (this.params.isEmpty()) {
            return 0;
        }
        String sql = this.sqlText.toString();
        if (this.statement == null) {
            this.statement = this.database.prepareStatement("SqlExecutor", sql);
            this.statement.setQueryTimeout();
        } else if (!sql.equals(this.lastSqlText)) {
            this.close();
            this.statement = this.database.prepareStatement("SqlExecutor", sql);
            this.statement.setQueryTimeout();
        }
        this.params.applyTo(this.statement);
        return this.statement.executeUpdate(this.ssContext);
    }

    public ResultSet executeQueryCached() throws SQLException {
        String sql = this.sqlText.toString();
        if (this.statement == null) {
            this.statement = this.database.prepareStatement("SqlExecutor", sql);
            this.statement.setQueryTimeout();
        } else if (!sql.equals(this.lastSqlText)) {
            this.close();
            this.statement = this.database.prepareStatement("SqlExecutor", sql);
            this.statement.setQueryTimeout();
        }
        this.params.applyTo(this.statement);
        return this.statement.executeQuery(this.ssContext);
    }

    public void close() {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        if (this.modifiedFields != null) {
            this.modifiedFields.clear();
        }
    }
}

