/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.types.Geometry;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.PackedRowContent;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.replication.ReplicationApplyEngine;
import inform.agent.replication.TableDataIO;
import inform.agent.scripts.format.FormatManager;
import inform.common.Empty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;

public class UnpackedRowContent {
    public double rowId;
    public final double parentTableId;
    public final double parentRowId;
    public boolean fullRow = true;
    public boolean recordExist = false;
    public final double userId;
    public long contentSize;
    public double dataLogOwnerId = 0.0;
    public double dataLogEventId = 0.0;
    public final ArrayList<FieldDescriptor> fields = new ArrayList();
    public final SqlParameterList values = new SqlParameterList();
    public final ArrayList<String> altKeyFields = new ArrayList();
    public final SqlParameterList altKeyValues = new SqlParameterList();
    public final TimeZoneHost timeZoneHost;

    public UnpackedRowContent(double rowId, double parentTableId, double parentRowId, double userId, TimeZoneHost timeZoneHost) {
        this.timeZoneHost = timeZoneHost;
        this.rowId = rowId;
        this.parentTableId = parentTableId;
        this.parentRowId = parentRowId;
        this.userId = userId;
        this.contentSize = 0L;
    }

    private void throwInvalidAltKey(TableDescriptor tableInfo) {
        throw new InformException("\u041d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u043d\u044b\u0439 \u043a\u043b\u044e\u0447").detail(tableInfo.getLogNodeId()).detail("\u0417\u0430\u043f\u0438\u0441\u044c: " + NumberConverter.doubleToString(this.rowId));
    }

    private double toServerTime(double value, FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor == null) {
            return value;
        }
        return FormatManager.toServerTime(value, fieldDescriptor.getFormat(), this.timeZoneHost);
    }

    public void unpack(byte[] rowContent, ArrayList<TableDataIO.FieldMetadata> metadata, TableDescriptor tableInfo) throws IOException, TaggedReaderException {
        if (rowContent == null) {
            this.contentSize = 0L;
            rowContent = Empty.byteArray;
        } else {
            this.contentSize = rowContent.length;
        }
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new ByteArrayInputStream(rowContent));
        int fieldCount = metadata.size();
        int headerSize = PackedRowContent.getHeaderSize(fieldCount);
        byte[] header = Arrays.copyOf(rowContent, headerSize);
        in.skipBytes(headerSize);
        int alternativeKeyCount = 0;
        for (int index = 0; index < metadata.size(); ++index) {
            int bit_index;
            int test_bit;
            int byte_index;
            boolean is_null;
            FieldDescriptor destField;
            TableDataIO.FieldMetadata sourceField = metadata.get(index);
            FieldDescriptor.BlobRawType blobRawType = FieldDescriptor.BlobRawType.BINARY;
            SqlParameter param = null;
            SqlParameter altParam = null;
            if (sourceField.used && (destField = tableInfo.getFieldDescriptor(sourceField.id)) != null && !destField.isVirtual()) {
                this.fields.add(destField);
                param = new SqlParameter(sourceField.type);
                param.prepare(destField);
                this.values.add(param);
                if (destField.getType() == DataType.BLOB) {
                    blobRawType = destField.getBlobRawType();
                }
            }
            if (sourceField.alternativeKey && tableInfo.getAlternativeKeyCount() != 0 && (destField = tableInfo.getFieldDescriptor(sourceField.id)) != null) {
                if (!destField.isAlternativeKey()) {
                    this.throwInvalidAltKey(tableInfo);
                }
                String rawName = destField.getRawName();
                this.altKeyFields.add(rawName);
                altParam = new SqlParameter(sourceField.type);
                this.altKeyValues.add(altParam);
                ++alternativeKeyCount;
            }
            boolean bl = is_null = (header[byte_index = index / 8] & (test_bit = 1 << (bit_index = index % 8))) == 0;
            if (param != null) {
                param.setNull();
            }
            if (altParam != null) {
                altParam.setNull();
                if (param == null) {
                    param = altParam;
                }
            }
            if (is_null) continue;
            switch (sourceField.type) {
                case BOOLEAN: {
                    int intVal = in.readInt();
                    if (param == null) break;
                    param.setBoolean(intVal != 0);
                    break;
                }
                case INTEGER: {
                    int intVal = in.readInt();
                    if (param == null) break;
                    param.setInteger(intVal);
                    break;
                }
                case DATE_TIME: {
                    double dblVal = in.readDouble();
                    if (param == null) break;
                    param.setDateTime(this.toServerTime(dblVal, tableInfo.getFieldDescriptor(sourceField.id)));
                    break;
                }
                case DOUBLE: {
                    double dblVal = in.readDouble();
                    if (param == null) break;
                    if (Double.isInfinite(dblVal) || Double.isNaN(dblVal)) {
                        param.setNull(SqlDataType.DOUBLE);
                        break;
                    }
                    param.setDouble(dblVal);
                    break;
                }
                case STRING: {
                    String strVal = in.readAnsi();
                    if (param == null) break;
                    param.setString(strVal);
                    break;
                }
                case UNICODE: {
                    String strVal = in.readUnicode();
                    if (param == null) break;
                    param.setUnicode(strVal);
                    break;
                }
                case BLOB: 
                case FILE: {
                    byte[] binVal = new byte[24];
                    in.readFully(binVal);
                    LittleEndianDataInputStream blobId = new LittleEndianDataInputStream(new ByteArrayInputStream(binVal));
                    int packKind = blobId.readInt();
                    if (packKind == 2) {
                        int blobSize = blobId.readInt();
                        if (param != null) {
                            byte[] blob = new byte[blobSize];
                            if (blobSize != 0) {
                                in.readFully(blob);
                            }
                            param.setBlob(blob);
                            break;
                        }
                        in.skip(blobSize);
                        break;
                    }
                    if (param == null) break;
                    param.setNull();
                    break;
                }
                case GEOMETRY: {
                    int size = in.readInt();
                    byte[] data = new byte[size];
                    in.readFully(data);
                    if (param == null) break;
                    Geometry g = Geometry.deserialize(data);
                    if (g == null) {
                        param.setNull(SqlDataType.GEOMETRY);
                        break;
                    }
                    param.setGeom(g);
                    break;
                }
                default: {
                    if (param == null) break;
                    param.setNull();
                }
            }
            if (altParam == null || altParam == param) continue;
            altParam.assign(param);
        }
        if (tableInfo.getAlternativeKeyCount() != 0 && tableInfo.getAlternativeKeyCount() != alternativeKeyCount) {
            this.throwInvalidAltKey(tableInfo);
        }
    }

    private SqlParameter unpackReplicaValue(FieldDescriptor field, TaggedReader in, String detailing) throws InformException, IOException, TaggedReaderException {
        SqlParameter param = new SqlParameter();
        param.prepare(field);
        switch (in.getNextTag()) {
            case 2: {
                return param.setNull(field.getType().toSqlDataType());
            }
            case 3: {
                if (field.getType() == DataType.BOOLEAN) {
                    return param.setBoolean(in.getInt() != 0);
                }
                return param.setInteger(in.getInt());
            }
            case 4: {
                return param.setDouble(in.getDouble());
            }
            case 5: {
                return param.setString(in.getAnsi());
            }
            case 6: {
                return param.setDateTime(this.toServerTime(in.getDouble(), field));
            }
            case 7: {
                return param.setBlob(in.getRaw());
            }
            case 8: {
                return param.setUnicode(in.getString());
            }
            case 9: {
                Geometry g = Geometry.deserialize(in.getRaw());
                if (g == null) {
                    return param.setNull(SqlDataType.GEOMETRY);
                }
                return param.setGeom(g);
            }
            case 12: {
                return param.setFile(in.getAnsi());
            }
        }
        ReplicationApplyEngine.throwInvalidReplicationStream(detailing);
        return null;
    }

    public void unpackReplica(byte[] rowContent, TableDescriptor tableInfo, String detailing) throws IOException, InformException, TaggedReaderException {
        assert (rowContent != null);
        this.contentSize = rowContent.length;
        TaggedReader in = new TaggedReader(rowContent);
        int alternativeKeyCount = 0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    FieldDescriptor field = tableInfo.getExistingFieldDescriptor(in.getInt());
                    if (field.isVirtual()) break;
                    this.fields.add(field);
                    this.values.add(this.unpackReplicaValue(field, in, detailing));
                    break;
                }
                case 10: {
                    if (tableInfo.getAlternativeKeyCount() == 0) break;
                    FieldDescriptor field = tableInfo.getExistingFieldDescriptor(in.getInt());
                    if (!field.isAlternativeKey()) {
                        this.throwInvalidAltKey(tableInfo);
                    }
                    this.altKeyFields.add(field.getRawName());
                    this.altKeyValues.add(this.unpackReplicaValue(field, in, detailing));
                    ++alternativeKeyCount;
                    break;
                }
                case 11: {
                    this.fullRow = false;
                }
            }
        }
        if (tableInfo.getAlternativeKeyCount() != 0 && tableInfo.getAlternativeKeyCount() != alternativeKeyCount) {
            this.throwInvalidAltKey(tableInfo);
        }
    }

    public boolean isFieldEquals(SqlParameter value, int columnIndex, ResultSet resultSet) throws SQLException {
        switch (value.getType()) {
            case INTEGER: {
                double number = resultSet.getAsInteger(columnIndex);
                if (resultSet.wasNull()) {
                    return value.isNull();
                }
                return number == value.getDouble();
            }
            case DOUBLE: {
                double number = resultSet.getAsDouble(columnIndex);
                if (resultSet.wasNull()) {
                    return value.isNull();
                }
                return number == value.getDouble();
            }
            case STRING: 
            case UNICODE: {
                String string = resultSet.getString(columnIndex);
                if (resultSet.wasNull()) {
                    return value.isNull();
                }
                return Strings.equals(string, value.getString());
            }
            case BLOB: {
                byte[] blob = resultSet.getBlobBytes(columnIndex);
                if (resultSet.wasNull() || blob == null || blob.length == 0) {
                    return value.isNull();
                }
                return Arrays.equals(blob, value.getBlob());
            }
            case DATE_TIME: {
                double number = resultSet.getDateTime(columnIndex);
                if (resultSet.wasNull()) {
                    return value.isNull();
                }
                return number == value.getDateTime();
            }
            case BOOLEAN: {
                boolean bool;
                boolean bl = bool = resultSet.getAsInteger(columnIndex) != 0;
                if (resultSet.wasNull()) {
                    return value.isNull();
                }
                return bool == value.getBoolean();
            }
            case TIMESTAMP: {
                Timestamp timestamp = resultSet.getTimestamp(columnIndex);
                if (resultSet.wasNull() || timestamp == null) {
                    return value.isNull();
                }
                return timestamp.getTime() == value.getMSecs();
            }
            case FILE: {
                break;
            }
        }
        return false;
    }
}

