/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.exchange;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.DataType;
import inform.agent.exchange.ConstEntry;
import java.io.IOException;

public class Constant {
    private ConstEntry _entry = new ConstEntry();

    public int id() {
        return this._entry.id;
    }

    public void id(int v) {
        this._entry.id = v;
    }

    public ConstEntry constEntry() {
        return this._entry;
    }

    public void assign(ConstEntry c) {
        this._entry.id = c.id;
        this._entry.data_type = c.data_type;
        this._entry.name = c.name;
        this._entry.caption = c.caption;
        this._entry.comment = c.comment;
        this._entry.value = c.value;
        this._entry.ref_node = c.ref_node;
        this._entry.ref_field = c.ref_field;
        this._entry.ref_rec = c.ref_rec;
        this._entry.ignore = c.ignore;
        this._entry.parented = c.parented;
        this._entry.func = c.func;
        this._entry.prnt_value = c.prnt_value;
        this._entry.prnt_rec = c.prnt_rec;
        this._entry.prnt_ignore = c.prnt_ignore;
        this._entry.prnt_func = c.prnt_func;
        this._entry.value_sel_ref = c.value_sel_ref;
        this._entry.value_sel_fld = c.value_sel_fld;
        this._entry.associateForm = c.associateForm;
        this._entry.access = c.access;
        this._entry.isNull = c.isNull;
        this._entry.prntIsNull = c.prntIsNull;
        this._entry.formatId = c.formatId;
    }

    public int getFormatId() {
        return this._entry.formatId;
    }

    public void save(TaggedWriter out) throws IOException {
        int[] iHeader = new int[]{this._entry.id, this._entry.data_type.getTypeId()};
        out.putIntArray(10, iHeader);
        out.putAnsi(11, this._entry.name);
        out.putAnsi(12, this._entry.caption);
        out.putAnsiIf(30, this._entry.comment);
        if (this._entry.access != 1) {
            out.putInt32(35, this._entry.access);
        }
        if (this._entry.ignore) {
            out.putEmpty(26);
            if (this._entry.data_type == DataType.DIRECTORY) {
                out.putDouble(22, this._entry.ref_rec);
                out.putInt32(23, this._entry.ref_field);
                out.putDouble(151, this._entry.ref_node);
            } else if (this._entry.data_type == DataType.PRIMARY_KEY) {
                out.putDouble(28, this._entry.ref_rec);
                out.putDouble(29, this._entry.ref_node);
                out.putDouble(151, this._entry.ref_node);
            }
        } else if (this._entry.func != 0) {
            out.putInt32(27, this._entry.func);
        } else if (this._entry.data_type != DataType.DIRECTORY && this._entry.data_type != DataType.PRIMARY_KEY && this._entry.value == null) {
            out.putEmpty(17);
        } else if (this._entry.data_type == DataType.INTEGER) {
            if (this._entry.value != null && this._entry.value instanceof Integer) {
                Integer v = (Integer)this._entry.value;
                out.putInt32(13, v);
            }
        } else if (this._entry.data_type == DataType.FLOAT || this._entry.data_type == DataType.INTERVAL || this._entry.data_type == DataType.METATREE_NODE) {
            if (this._entry.value != null && this._entry.value instanceof Double) {
                Double v = (Double)this._entry.value;
                out.putDouble(14, v);
            }
        } else if (this._entry.data_type == DataType.STRING || this._entry.data_type == DataType.BIG_NUMBER) {
            if (this._entry.value != null && this._entry.value instanceof String) {
                String v = (String)this._entry.value;
                out.putAnsi(15, v);
            }
        } else if (this._entry.data_type == DataType.UNICODE) {
            if (this._entry.value != null && this._entry.value instanceof String) {
                String v = (String)this._entry.value;
                out.putUnicode(34, v);
            }
        } else if (this._entry.data_type == DataType.DATE_TIME) {
            if (this._entry.value != null && this._entry.value instanceof Double) {
                Double v = (Double)this._entry.value;
                out.putDouble(16, v);
            }
        } else if (this._entry.data_type == DataType.BOOLEAN) {
            if (this._entry.value != null && this._entry.value instanceof Integer) {
                Integer v = (Integer)this._entry.value;
                out.putInt32(13, v != 0 ? 1 : 0);
            }
        } else if (this._entry.data_type == DataType.DIRECTORY) {
            if (this._entry.ref_node != 0.0 && this._entry.ref_field != 0) {
                out.putDouble(22, this._entry.ref_rec);
                out.putInt32(23, this._entry.ref_field);
                out.putDouble(151, this._entry.ref_node);
                if (this._entry.value == null) {
                    out.putEmpty(17);
                }
            }
        } else if (this._entry.data_type == DataType.PRIMARY_KEY) {
            out.putDouble(28, this._entry.ref_rec);
            out.putDouble(29, this._entry.ref_node);
            out.putDouble(151, this._entry.ref_node);
            if (this._entry.value == null) {
                out.putEmpty(17);
            }
        }
        if (this._entry.value_sel_ref != 0.0 && this._entry.value_sel_fld != 0) {
            out.putEmpty(24);
            out.putDouble(151, this._entry.value_sel_ref);
            out.putInt32(25, this._entry.value_sel_fld);
        }
        if (this._entry.associateForm != null && this._entry.associateForm.length > 0) {
            out.putEmpty(32);
            out.putRaw(202, this._entry.associateForm);
        }
        if (this._entry.data_type == DataType.DATE_TIME && this._entry.formatId != 0) {
            out.putInt32(36, this._entry.formatId);
        }
    }
}

