/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.exchange;

import inform.agent.exchange.ExportNodesList;
import inform.agent.mtd.NodeRecord;

public class ExchangeNode {
    private NodeRecord _nodeRecord;
    private String _entryPath;
    private int _entryDataCount;
    private ExportNodesList _children;
    private ExchangeNode _parentNode;
    public boolean moveToHierarchyRoot = false;

    public ExchangeNode(NodeRecord record) {
        this._nodeRecord = record;
        this._children = new ExportNodesList();
    }

    public NodeRecord nodeRecord() {
        return this._nodeRecord;
    }

    public void entryPath(String v) {
        this._entryPath = v;
    }

    public String contentEntryPath() {
        return this._entryPath;
    }

    public void dataEntryCount(int v) {
        this._entryDataCount = v;
    }

    public int dataEntryCount() {
        return this._entryDataCount;
    }

    public boolean haveChildren() {
        return !this._children.isEmpty();
    }

    public void setParentNode(ExchangeNode v) {
        this._parentNode = v;
    }

    public ExchangeNode parentNode() {
        return this._parentNode;
    }

    public ExportNodesList children() {
        return this._children;
    }

    public String getDataEntryPath(int index) {
        Object path = this._entryPath;
        if (this._entryPath.length() <= ".cnt".length()) {
            throw new IllegalStateException();
        }
        path = ((String)path).substring(0, this._entryPath.length() - ".cnt".length());
        path = (String)path + ".dat";
        if (index == 0 && this._entryDataCount == 0) {
            return path;
        }
        String pathBuf = (String)path + "." + (index + 1);
        return pathBuf;
    }

    public void addChildNode(ExchangeNode node) {
        this._children.addNode(node);
    }

    public void hierarchyClear() {
        this._parentNode = null;
        this._children.clear();
    }
}

