/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.InformException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.expr.Term;

public abstract class AbstractEvaluator {
    protected final Term term;

    public AbstractEvaluator(Term term) {
        this.term = term;
    }

    public abstract boolean isStringType() throws Exception;

    public abstract boolean isIgnored();

    public void addArgument(AbstractEvaluator evaluator) {
        throw new IllegalStateException();
    }

    protected static boolean isStringable(DataType type) {
        switch (type) {
            case STRING: 
            case UNICODE: 
            case BLOB: {
                return true;
            }
        }
        return false;
    }

    protected static double toNumberSilent(Object value) {
        try {
            return ValueCaster.toDouble(value);
        }
        catch (InformException ex) {
            return 0.0;
        }
    }
}

