/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.js;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.collections.ObjectIntegerMap;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeDateHelper;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class ABON {
    public static final byte VERSION = 1;
    private static final int TAG_VERSION = 6;
    private static final int TAG_VALUE_BAD = 7;
    private static final int TAG_VALUE_REF = 8;
    private static final int TAG_VALUE_NULL = 9;
    private static final int TAG_VALUE_UNDEFINED = 10;
    private static final int TAG_VALUE_STRING = 11;
    private static final int TAG_VALUE_NUMBER = 12;
    private static final int TAG_VALUE_BOOLEAN = 13;
    private static final int TAG_VALUE_DATE_DEPRECATED = 14;
    private static final int TAG_VALUE_COMPLEX = 15;
    private static final int COMPLEX_VALUE_OBJECT = 1;
    private static final int COMPLEX_VALUE_ARRAY = 2;
    private static final int TAG_VALUE_COMPLEX_END = 16;
    private static final int TAG_KEY = 17;
    private static final int TAG_VALUE_DATE_LOCAL = 18;

    public static void serialize(Object o, TaggedWriter w) throws IOException {
        w.putInt08(6, (byte)1);
        ObjectIntegerMap values = new ObjectIntegerMap(){

            @Override
            protected int hash(Object o) {
                return System.identityHashCode(o);
            }

            @Override
            protected boolean equals(Object a, Object b) {
                return a == b;
            }
        };
        ABON.writeObject(o, w, values);
    }

    private static boolean writeObject(Object obj, TaggedWriter w, ObjectIntegerMap values) throws IOException {
        if (obj == null) {
            w.putEmpty(9);
        } else if (obj == Undefined.instance) {
            w.putEmpty(10);
        } else if (obj instanceof String || obj instanceof ConsString) {
            w.putString(11, obj.toString());
        } else if (obj instanceof Number) {
            w.putDouble(12, ((Number)obj).doubleValue());
        } else if (obj instanceof Boolean) {
            w.putBool(13, (Boolean)obj);
        } else {
            if (!(obj instanceof Scriptable)) {
                return false;
            }
            Scriptable scr = (Scriptable)obj;
            if ("Function".equals(scr.getClassName())) {
                return false;
            }
            if (NativeDateHelper.NATIVE_DATE_CLASS.isInstance(scr)) {
                w.putDouble(18, DateTime.fromUnixTime(NativeDateHelper.toUnixTime((ScriptableObject)scr)));
                return true;
            }
            if (values.contains(obj)) {
                ABON.writeUInt(w, 8, values.lget());
                return true;
            }
            values.put(scr, values.size());
            if (scr instanceof NativeArray) {
                w.putInt08(15, (byte)2);
                NativeArray arr = (NativeArray)scr;
                int i = 0;
                while ((long)i < arr.getLength()) {
                    if (!ABON.writeObject(arr.get(i), w, values)) {
                        w.putEmpty(7);
                    }
                    ++i;
                }
                w.putEmpty(16);
            } else {
                w.putInt08(15, (byte)1);
                for (Object id : scr.getIds()) {
                    String sid = String.valueOf(id);
                    if (!ABON.writeObject(scr.get(sid, scr), w, values)) continue;
                    w.putString(17, sid);
                }
                w.putEmpty(16);
            }
        }
        return true;
    }

    public static Object deserialize(TaggedReader r, Context ctx, Scriptable scope) throws IOException {
        r.checkCurrentTag(6);
        int ver = ABON.readUInt(r);
        if (ver != 1 && ver != 0) {
            throw new InformException("Unsupported ABON version: " + ver);
        }
        if (r.next()) {
            ArrayList<Object> values = new ArrayList<Object>();
            return ABON.readObjectCurrentTag(r, values, ctx, scope);
        }
        return Scriptable.NOT_FOUND;
    }

    private static Object readObjectCurrentTag(TaggedReader r, List<Object> values, Context ctx, Scriptable scope) throws IOException {
        switch (r.getCurrentTag()) {
            case 7: {
                return Scriptable.NOT_FOUND;
            }
            case 8: {
                return values.get(ABON.readUInt(r));
            }
            case 9: {
                return null;
            }
            case 10: {
                return Undefined.instance;
            }
            case 11: {
                return r.getString();
            }
            case 12: {
                switch (r.getCurrentTagSize()) {
                    case 1: {
                        return r.getByte();
                    }
                    case 2: {
                        return r.getShort();
                    }
                    case 4: {
                        return r.getInt();
                    }
                    case 8: {
                        return r.getDouble();
                    }
                }
                throw new InformException("Unsupported NUMBER size: " + r.getCurrentTagSize());
            }
            case 14: {
                return ctx.newObject(scope, "Date", new Object[]{r.getLong()});
            }
            case 18: {
                return ctx.newObject(scope, "Date", new Object[]{DateTime.toUnixTime(r.getDouble())});
            }
            case 13: {
                return r.getBoolean();
            }
            case 15: {
                int ct = ABON.readUInt(r);
                switch (ct) {
                    case 2: {
                        NativeArray arr = (NativeArray)ctx.newArray(scope, 0);
                        values.add(arr);
                        while (r.next()) {
                            if (r.getCurrentTag() == 16) {
                                return arr;
                            }
                            Object pv = ABON.readObjectCurrentTag(r, values, ctx, scope);
                            arr.put((int)arr.getLength(), (Scriptable)arr, pv);
                        }
                        throw new InformException("Unexpected EOS");
                    }
                    case 1: {
                        NativeObject obj = (NativeObject)ctx.newObject(scope);
                        values.add(obj);
                        Object pv = Undefined.instance;
                        block27: while (r.next()) {
                            switch (r.getCurrentTag()) {
                                case 16: {
                                    return obj;
                                }
                                case 17: {
                                    String pn = r.getString();
                                    obj.defineProperty(pn, pv, 0);
                                    pv = Undefined.instance;
                                    continue block27;
                                }
                            }
                            pv = ABON.readObjectCurrentTag(r, values, ctx, scope);
                        }
                        throw new InformException("Unexpected EOS");
                    }
                }
            }
        }
        throw new InformException("Unsupported ABON value type: " + r.getCurrentTag());
    }

    private static int readUInt(TaggedReader r) throws IOException {
        switch (r.getCurrentTagSize()) {
            case 1: {
                return r.getByte() & 0xFF;
            }
            case 2: {
                return r.getShort() & 0xFFFF;
            }
            case 4: {
                return r.getInt();
            }
        }
        throw new InformException("Unsupported UINT tag size: " + r.getCurrentTagSize());
    }

    private static void writeUInt(TaggedWriter w, int tag, int v) throws IOException {
        if (v <= 255) {
            w.putInt08(tag, (byte)v);
        } else if (v <= 65535) {
            w.putInt16(tag, (short)v);
        } else {
            w.putInt32(tag, v);
        }
    }
}

