/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.InformException;
import inform.adt.collections.DoubleHash;
import inform.agent.Core;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.TableDirectoryDependencis;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.ConstantsNode;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.ExtFilesNode;
import inform.agent.mtd.nodes.FindNode;
import inform.agent.mtd.nodes.GroupNode;
import inform.agent.mtd.nodes.JobNode;
import inform.agent.mtd.nodes.LostFoundNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.NodeHashTable;
import inform.agent.mtd.nodes.RoleNode;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.mtd.nodes.SqlScriptNode;
import inform.agent.mtd.nodes.SymLinkNode;
import inform.agent.mtd.nodes.SymLinkNodeCache;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.mtd.nodes.TrashNode;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.WebFormNode;
import inform.agent.mtd.request.NodeStatus;
import java.sql.SQLException;
import java.util.ArrayList;

public class MtdCache {
    private final NodeHashTable nodes;
    private ArrayList<Node> modifiedNodes = new ArrayList();
    private final SymLinkNodeCache symlinkCache;
    private boolean loaded = false;
    private ArrayList<Node> syncNewNodes = null;

    public MtdCache() {
        this.nodes = new NodeHashTable(this);
        this.symlinkCache = new SymLinkNodeCache();
    }

    public Node getNode(double id) {
        return this.nodes.get(id);
    }

    public Node getValidNode(double id) throws InformException {
        Node node = this.getNode(id);
        if (node == null) {
            MtdEngine.throwError(id, "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        return node;
    }

    public BasicNode getValidTranslatedNode(double id) throws InformException {
        BasicNode node = this.getValidNode(id).getRefNode();
        if (node == null) {
            MtdEngine.throwError(id, "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        return node;
    }

    public void syncNode(Node node) throws InformException, InterruptedException {
        this.putNode(node);
        node.initNode(this);
        node.createContentAttr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncNewNode(Node node) throws InformException {
        MtdCache mtdCache = this;
        synchronized (mtdCache) {
            if (!this.loaded) {
                if (this.syncNewNodes == null) {
                    this.syncNewNodes = new ArrayList();
                }
                this.syncNewNodes.add(node);
                return;
            }
        }
        if (this.getNode(node.getId()) == null) {
            this.putNode(node);
            Node parentNode = this.getNode(node.getParentId());
            if (parentNode != null) {
                parentNode.dropChildrenCache();
            }
        }
    }

    public boolean putNode(Node node) {
        boolean replaced = this.nodes.put(node);
        if (node.getType() == 2) {
            SymLinkNode symlinkNode = (SymLinkNode)node;
            this.putSymlink(symlinkNode.getId(), symlinkNode.getRefNodeId());
        }
        if (node instanceof TableNode) {
            TableDirectoryDependencis.invalidate(node.getId());
        }
        return replaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putModifiedNode(Node node) {
        MtdCache mtdCache = this;
        synchronized (mtdCache) {
            if (!this.loaded) {
                if (this.modifiedNodes == null) {
                    this.modifiedNodes = new ArrayList();
                }
                this.modifiedNodes.add(node);
            }
        }
    }

    public DoubleHash<AccountNode> getAccountsWithName(String name) {
        return this.nodes.getAccountsWithName(name);
    }

    public UserNode getUserNodeByName(String name, boolean external) throws InformException {
        return this.nodes.getUserNodeByName(name, external);
    }

    UserNode getAcitiveDirectoryUserNodes(String name) throws InformException {
        UserNode[] accounts = this.nodes.findUsersIgnoreCase(name);
        if (accounts == null) {
            return null;
        }
        if (accounts.length == 1) {
            return accounts[0];
        }
        UserNode userNode = null;
        for (UserNode node : accounts) {
            if (MtdEngine.isNodeInTrash(node.getId()) || node.isBlocked() || !node.isActiveDirectoryAuthorization()) continue;
            if (userNode == null) {
                userNode = node;
                continue;
            }
            throw new InformException("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439: \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c:\n" + node.toLogString() + "\n" + userNode.toLogString());
        }
        return userNode;
    }

    public double getUserIdByName(String name) throws InformException {
        UserNode node = this.nodes.getUserNodeByName(name, false);
        if (node == null) {
            return 0.0;
        }
        return node.getId();
    }

    public void putSymlink(double symId, double refId) {
        this.symlinkCache.put(symId, refId);
    }

    public Node getNodeByIdent(String ident) {
        return this.nodes.getByIdent(ident);
    }

    public AccountNode[] getAccounts() throws InformException {
        return this.nodes.getAccounts();
    }

    public NodeHashTable getNodes() {
        return this.nodes;
    }

    public SymLinkNodeCache getSymlinkCache() {
        return this.symlinkCache;
    }

    public void checkNodeRecord(NodeRecord record) {
        String ident = record.getIdentName();
        if (ident != null && !ident.isEmpty() && this.getNodeByIdent(ident) != null) {
            record.setIdentName("");
        }
    }

    public static Node createNodeInstance(NodeRecord record) {
        if (record.getId() == 9.0) {
            return new LostFoundNode(record);
        }
        switch (record.getType()) {
            case 1: {
                return new TrashNode(record);
            }
            case 6: {
                return new ServerNode(record);
            }
            case 2: {
                return new SymLinkNode(record);
            }
            case 3: {
                return new UserNode(record);
            }
            case 4: {
                return new GroupNode(record);
            }
            case 57: {
                return new RoleNode(record);
            }
            case 7: {
                return new ConstantsNode(record);
            }
            case 12: {
                return new TableNode(record);
            }
            case 10: {
                return new DatabaseNode(record);
            }
            case 43: {
                return new SqlScriptNode(record);
            }
            case 19: {
                return new FindNode(record);
            }
            case 51: {
                return new JobNode(record);
            }
            case 25: {
                return new ExtFilesNode(record);
            }
            case 45: {
                return new WebFormNode(record);
            }
        }
        return new BasicNode(record);
    }

    public Node createTypedNode(NodeRecord record) throws InformException {
        switch (record.getType()) {
            case 3: {
                UserNode accountNode = new UserNode(record);
                return accountNode;
            }
            case 4: {
                GroupNode accountNode = new GroupNode(record);
                return accountNode;
            }
            case 57: {
                RoleNode accountNode = new RoleNode(record);
                return accountNode;
            }
        }
        return MtdCache.createNodeInstance(record);
    }

    private boolean checkNodeCreated(Connector connector, double id, double parentId, int type, String name) throws InformException, SQLException {
        Node node = this.getNode(id);
        if (node != null) {
            return false;
        }
        NodeRecord record = new NodeRecord(NodeStatus.MODIFIED);
        record.setId(id);
        record.setType(type);
        record.setParentId(parentId);
        record.setName(name);
        long time = System.currentTimeMillis();
        record.setCreationTime(time);
        record.setModificationContentTime(time);
        record.setModificationAttributeTime(time);
        node = MtdCache.createNodeInstance(record);
        node.checkLoaded();
        node.afterCreateSystem();
        this.putNode(node);
        MetadataNodeReader.createNode(null, connector, node, null);
        node.applyChanges();
        return true;
    }

    public DoubleHash<Node> getUnsettedContentAttrNodes() {
        return this.nodes.getUnsettedContentAttrNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterLoad(Connector connector, boolean checkTree) throws InformException, InterruptedException, SQLException {
        this.nodes.init(this);
        this.checkNodeCreated(connector, 0.0, 0.0, 0, "/");
        if (this.checkNodeCreated(connector, 2.0, 0.0, 6, "\u0421\u0435\u0440\u0432\u0435\u0440")) {
            this.checkNodeCreated(connector, 10.0, 2.0, 10, "\u0411\u0414 \u041c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445");
        }
        this.checkNodeCreated(connector, 1.0, 0.0, 1, "\u041a\u043e\u0440\u0437\u0438\u043d\u0430");
        this.checkNodeCreated(connector, 3.0, 2.0, 7, "\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b");
        this.checkNodeCreated(connector, 4.0, 2.0, 8, "\u0410\u0443\u0434\u0438\u0442");
        this.checkNodeCreated(connector, 12.0, 2.0, 14, "theme.ini");
        if (checkTree && !this.nodes.containsAdminAccount()) {
            double id = 6.0;
            if (this.getNode(id) != null) {
                id = Core.generateId();
            }
            UserNode node = UserNode.createAdminNode(id);
            this.putNode(node);
            MetadataNodeReader.createNode(null, connector, node, null);
            node.applyChanges();
        }
        this.nodes.buildChildrenCache();
        MtdCache mtdCache = this;
        synchronized (mtdCache) {
            this.loaded = true;
            ArrayList<Node> sync = this.syncNewNodes;
            this.syncNewNodes = null;
            if (sync != null) {
                for (Node node : sync) {
                    this.syncNewNode(node);
                }
            }
            sync = this.modifiedNodes;
            this.modifiedNodes = null;
            if (sync != null) {
                for (Node node : sync) {
                    this.putNode(node);
                }
            }
        }
    }
}

