/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.Hashing;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Client;

public class NodeLock {
    public double nodeId;
    public double lockId;
    public Client client;

    public NodeLock() {
    }

    public NodeLock(double nodeId, double lockId) {
        this.nodeId = nodeId;
        this.lockId = lockId;
        this.client = null;
    }

    public NodeLock(double nodeId, double lockId, Client client) {
        this.nodeId = nodeId;
        this.lockId = lockId;
        this.client = client;
    }

    public int hashCode() {
        return Hashing.hash(this.nodeId) ^ Hashing.hash(this.lockId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeLock other = (NodeLock)obj;
        if (Double.doubleToLongBits(this.nodeId) != Double.doubleToLongBits(other.nodeId)) {
            return false;
        }
        return Double.doubleToLongBits(this.lockId) == Double.doubleToLongBits(other.lockId);
    }

    public void throwError() {
        NodeLock.throwError(this.client, MtdEngine.getValidNode(this.nodeId));
    }

    public String getErrorText() {
        Node node = MtdEngine.getValidNode(this.nodeId);
        StringBuilder msg = new StringBuilder();
        msg.append("\u0423\u0437\u0435\u043b '").append(node.getName()).append("' \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d");
        if (this.client != null) {
            msg.append(" \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c ").append(this.client.getUserName());
        }
        return msg.toString();
    }

    public static void throwError(Client client, Node node) throws InformException {
        assert (client != null);
        StringBuilder msg = new StringBuilder();
        msg.append("\u0423\u0437\u0435\u043b '").append(node.getName()).append("' \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d");
        if (client != null) {
            msg.append(" \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c ").append(client.getUserName());
        }
        InformException ex = new InformException(msg.toString());
        if (client != null) {
            ex.detail("SessionID: " + NumberConverter.doubleToString(client.getSessionId()));
        }
        throw ex;
    }
}

