/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.InformException;
import inform.adt.collections.AbstractHashedCollection;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleSet;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.ClosableResult;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;

public class TableDirectoryDependencis {
    public static final int MAX_ERROR_COUNT = 8;
    public static final int MAX_CHANGED_TABLES = 16;
    private static final int[] TABLE_TYPES = new int[]{12};
    private static final DoubleHash<TableReferences> dependencies = new DoubleHash();
    private static final DoubleSet changedTables = new DoubleSet();
    private static int errorCount = 0;
    private static boolean cacheIsValid = false;

    private static void updateTableReferences(TableDescriptor td) {
        if (!td.isCheckReferringIntegrity() || !td.isOperableTable()) {
            return;
        }
        for (FieldDescriptor fd : td.getFields()) {
            if (fd.getType() != DataType.DIRECTORY || fd.isVirtual() || fd.isDontCheckRefs()) continue;
            Double refId = fd.getReferenceId();
            TableReferences d = dependencies.get(refId);
            if (d == null) {
                d = new TableReferences(refId);
                dependencies.add(d);
            }
            d.add(td.getNodeId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] getReferencesToTable(Double tableNodeId, ServerSideHost ssHost) throws SQLException, IOException, InformException {
        Object changedTables;
        long startNanoTime = System.nanoTime();
        boolean fullRebuild = false;
        if (tableNodeId == 0.0) {
            return Empty.doubleArray;
        }
        TableReferences deps = null;
        boolean needRebuild = false;
        DoubleSet doubleSet = TableDirectoryDependencis.changedTables;
        synchronized (doubleSet) {
            needRebuild = !cacheIsValid || TableDirectoryDependencis.changedTables.size() >= 16 || errorCount >= 8;
        }
        if (!needRebuild) {
            AbstractHashedCollection abstractHashedCollection = TableDirectoryDependencis.changedTables;
            synchronized (abstractHashedCollection) {
                changedTables = TableDirectoryDependencis.changedTables.toArray();
                TableDirectoryDependencis.changedTables.clear();
            }
            abstractHashedCollection = dependencies;
            synchronized (abstractHashedCollection) {
                deps = dependencies.get(tableNodeId);
                if (deps != null && ((Object)changedTables).length != 0) {
                    for (Object t : changedTables) {
                        Node node;
                        TableReferences _deps = dependencies.get((double)t);
                        if (_deps == null) {
                            dependencies.add(new TableReferences((double)t));
                        }
                        if ((node = MtdEngine.getNode((double)t)) == null || !(node instanceof TableNode)) continue;
                        if (!TableDirectoryDependencis.isValidParent(node.getParentId())) {
                            deps = null;
                            break;
                        }
                        TableDescriptor tableDescriptor = ((TableNode)node).getDescriptor();
                        if (tableDescriptor == null) continue;
                        TableDirectoryDependencis.updateTableReferences(tableDescriptor);
                    }
                }
            }
        }
        if (deps == null) {
            changedTables = dependencies;
            synchronized (changedTables) {
                TableReferences _deps;
                TableReferences tableReferences = _deps = needRebuild ? null : dependencies.get(tableNodeId);
                if (_deps == null) {
                    fullRebuild = true;
                    TableDirectoryDependencis.internalClearCache();
                    deps = new TableReferences(tableNodeId);
                    dependencies.add(deps);
                    try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("TableDirectoryDependencis::getReferencesToTable");
                         ClosableResult closableResult = MetadataNodeReader.getResultSetForTypedNode(null, TABLE_TYPES, connection, false);){
                        ResultSet resultSet = closableResult.getResultSet();
                        while (resultSet.next()) {
                            MetadataNodeReader nodeReader = MetadataNodeReader.createNode(resultSet);
                            _deps = dependencies.get(nodeReader.id);
                            if (_deps == null) {
                                dependencies.add(new TableReferences(nodeReader.id));
                            }
                            if (!TableDirectoryDependencis.isValidParent(nodeReader.parentId)) continue;
                            TableDescriptor td = new TableDescriptor(nodeReader.id, nodeReader.content);
                            TableDirectoryDependencis.updateTableReferences(td);
                        }
                    }
                    assert (deps != null);
                } else {
                    deps = _deps;
                }
            }
        }
        long nanoTime = System.nanoTime() - startNanoTime;
        if (fullRebuild) {
            Core.logger.info("rebuild TableDirectoryDependencis time: {} ms", (Object)(nanoTime / 1000000L));
        }
        if (ssHost != null) {
            ssHost.standing(nanoTime);
        }
        return deps.toArray();
    }

    private static boolean isValidParent(double parentId) throws InformException {
        MtdCache cache = MtdEngine.getMtdCache();
        Node node = cache.getNode(parentId);
        if (node == null) {
            return false;
        }
        return !node.isInTrashRecursive(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incErrorCount() {
        DoubleSet doubleSet = changedTables;
        synchronized (doubleSet) {
            ++errorCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate(double modifiedTableId) {
        DoubleSet doubleSet = changedTables;
        synchronized (doubleSet) {
            changedTables.add(modifiedTableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        DoubleSet doubleSet = changedTables;
        synchronized (doubleSet) {
            cacheIsValid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalClearCache() {
        AbstractHashedCollection abstractHashedCollection = changedTables;
        synchronized (abstractHashedCollection) {
            changedTables.clear();
            errorCount = 0;
            cacheIsValid = true;
        }
        abstractHashedCollection = dependencies;
        synchronized (abstractHashedCollection) {
            dependencies.clear();
        }
    }

    private static class TableReferences
    extends DoubleSet
    implements DoubleHash.Entry {
        final double id;
        double[] cacheArray;

        public TableReferences(double id) {
            this.id = id;
        }

        @Override
        public double key() {
            return this.id;
        }

        @Override
        public boolean add(double v) {
            this.cacheArray = null;
            return super.add(v);
        }

        @Override
        public double[] toArray() {
            if (this.cacheArray == null) {
                this.cacheArray = super.toArray();
            }
            return this.cacheArray;
        }
    }
}

