/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.LogContext;
import inform.agent.db.connect.Connector;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.RolesTable;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.scripts.SSContext;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;

public class VirtualUser
extends UserNode {
    private final SqlParameter[] attributes;
    private long time;
    private final UserNode.Props props = new UserNode.Props();
    private static final DoubleHash<VirtualUser> userCache = new DoubleHash();
    private static final HashMap<String, VirtualUser> nameCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualUser(SqlParameter[] attributes) throws IOException, SQLException {
        super(VirtualUser.createRecord(attributes));
        RolesTable rolesTable;
        double[] roles;
        this.attributes = attributes;
        byte[] content = null;
        if (attributes[3] != null) {
            content = attributes[3].getBlob();
        }
        if (attributes[5] != null) {
            this.props.setFio(attributes[5].getString());
        }
        if (attributes[8] != null) {
            this.props.setPhone(attributes[8].getString());
        }
        if (attributes[9] != null) {
            this.props.setEmail(attributes[9].getString());
        }
        if (attributes[7] != null) {
            this.uiImageId = attributes[7].getInteger();
        }
        if (attributes[10] != null) {
            this.props.setCardId(attributes[10].getDouble());
        }
        if (attributes[11] != null) {
            this.props.setDeleted(attributes[11].getAsBoolean());
        }
        if (attributes[20] != null) {
            this.props.setServerManaged(attributes[20].getAsBoolean());
        }
        if (attributes[21] != null) {
            this.props.setServerManagedEndDate(attributes[21].getDateTime());
        }
        boolean useRolesTable = false;
        if (content != null) {
            TaggedReader in = new TaggedReader(content);
            try (Connector.Metabase connector = new Connector.Metabase();){
                this.status = NodeStatus.CREATING;
                try {
                    Node.ModifyNodeArg arg = new Node.ModifyNodeArg(null, connector, this.status, null);
                    arg.in = in;
                    block14: while (in.next()) {
                        int tag = in.getCurrentTag();
                        switch (tag) {
                            case 3: 
                            case 4: 
                            case 21: 
                            case 24: 
                            case 25: 
                            case 33: 
                            case 52: {
                                continue block14;
                            }
                            case 38: {
                                int roleId = in.getInt();
                                this.role = UserRole.get(roleId);
                                continue block14;
                            }
                            case 42: {
                                this.props.loadScale(in.getRaw());
                                continue block14;
                            }
                            case 113: {
                                useRolesTable = true;
                                continue block14;
                            }
                        }
                        this.loadModifyTag(tag, arg);
                    }
                }
                finally {
                    this.status = null;
                }
            }
        }
        if (useRolesTable && (roles = (rolesTable = new RolesTable()).select(null, this.getId())) != null) {
            this.loadExplicitGroups(roles);
        }
        this.props.loadScale(this.userProps);
        if (attributes[13] != null) {
            this.activeDirectory = attributes[13].getAsBoolean();
        }
        if (attributes[14] != null) {
            this.inheritedStartup = attributes[14].getAsBoolean();
        }
        if (attributes[15] != null) {
            this.startupRootNodeId = attributes[15].getDouble();
        }
        if (attributes[16] != null) {
            this.startupStartNodeId = attributes[16].getDouble();
        }
        if (attributes[17] != null) {
            this.startupStartNodeAction = attributes[17].getInteger();
        }
        if (attributes[18] != null) {
            this.startupScriptId = attributes[18].getDouble();
        }
        if (attributes[19] != null) {
            this.webStartNodeId = attributes[19].getDouble();
        }
        boolean newBlocked = attributes[4].isNull() || attributes[4].getAsBoolean();
        try {
            this.trySetLock(MtdEngine.getMtdCache(), newBlocked);
        }
        catch (InterruptedException ex) {
            throw InformException.wrap(ex);
        }
        this.time = System.currentTimeMillis();
    }

    @Override
    public UserNode.Props props() {
        this.propsCache = this.props;
        return super.props();
    }

    @Override
    public void applyUpdates(SSContext context, Node.ModifyNodeArg arg) throws SQLException, IOException {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(content);
        ServerNode.Descriptor serverNodeDescriptor = ((ServerNode)MtdEngine.getValidNode(2.0)).descriptor();
        UsersTable usersTable = new UsersTable(serverNodeDescriptor);
        RolesTable rolesTable = new RolesTable(serverNodeDescriptor);
        this.getClientTagsContent(usersTable, rolesTable, out, true);
        out.flush();
        UsersTable.UpdateParams updateParams = new UsersTable.UpdateParams();
        updateParams.adLogin = this.activeDirectory;
        updateParams.inheritedStartup = this.inheritedStartup;
        if (this.inheritedStartup) {
            updateParams.rootNode = 0.0;
            updateParams.startNode = 0.0;
            updateParams.startAction = -1;
            updateParams.startScript = 0.0;
            updateParams.startWebNode = 0.0;
        } else {
            updateParams.rootNode = this.startupRootNodeId;
            updateParams.startNode = this.startupStartNodeId;
            updateParams.startAction = this.startupStartNodeAction;
            updateParams.startScript = this.startupScriptId;
            updateParams.startWebNode = this.webStartNodeId;
        }
        if (rolesTable.enabled()) {
            updateParams.roles = this.explicitGroups();
            if (updateParams.roles != null && updateParams.roles.length != 0) {
                updateParams.rolesPrimaryKeys = new double[updateParams.roles.length];
                for (int i = 0; i < updateParams.rolesPrimaryKeys.length; ++i) {
                    updateParams.rolesPrimaryKeys[i] = Core.generateId();
                }
            }
        }
        updateParams.props = this.props;
        updateParams.content = content.internalBuffer();
        updateParams.contentLength = content.size();
        usersTable.update(context, arg.ssHost, this.getId(), this.getName(), this.getParentId(), this.blocked, updateParams, rolesTable);
        VirtualUser.invalidateUser(this.getId());
    }

    @Override
    public void loadModifyTag(int tag, Node.ModifyNodeArg arg) throws IOException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 4: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 3: {
                double loadedId = arg.in.getDouble();
                Node loadedNode = null;
                if (loadedId != 0.0 && (loadedNode = MtdEngine.getNode(loadedId)) != null && loadedNode.getType() != 4 && loadedNode.getType() != 57) {
                    loadedNode = null;
                }
                this.internalSetParent(loadedNode);
                break;
            }
            case 33: {
                String loadedName = arg.in.getAnsi();
                if (Strings.isVoid(loadedName)) break;
                this.internalSetName(loadedName);
                break;
            }
            case 42: 
            case 87: {
                if (this.status == NodeStatus.CREATING) break;
                this.props.modifyVirtualUserProps(arg.in.getRaw());
                break;
            }
            case 101: {
                this.props.setCardId(arg.in.getDouble());
                break;
            }
            case 82: {
                this.activeDirectory = in.getBooleanDef(false);
                break;
            }
            default: {
                super.loadModifyTag(tag, arg);
            }
        }
    }

    @Override
    public void changeParent(double newParentId, Node.ModifyNodeArg arg) throws InformException, SQLException {
        Node newParent = null;
        if (newParentId != 0.0 && (newParent = MtdEngine.getNode(newParentId)) != null && newParent.getType() != 4 && newParent.getType() != 57) {
            newParent = null;
        }
        this.internalSetParent(newParent);
    }

    @Override
    protected void getClientTagsContent(UsersTable usersTable, RolesTable rolesTable, TaggedWriter out, boolean skipSomeTags) throws IOException {
        this.userProps = this.props.getScaleProps();
        super.getClientTagsContent(usersTable, rolesTable, out, skipSomeTags);
    }

    @Override
    public void getAccountInfo(TaggedWriter out, boolean needHash) throws IOException, InformException {
        this.userProps = this.props.getVirtualUserProps();
        super.getAccountInfo(out, needHash);
        out.putDouble(101, this.props.getCardId());
    }

    @Override
    public void getNodeInfo(Node.NodeInfoArg arg) throws InformException, IOException, SQLException, InterruptedException {
        this.userProps = this.props.getVirtualUserProps();
        super.getNodeInfo(arg);
    }

    @Override
    public boolean serverManaged() {
        return this.props.getServerManaged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualUser findUser(double id) {
        Class<VirtualUser> clazz = VirtualUser.class;
        synchronized (VirtualUser.class) {
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return userCache.get(id);
        }
    }

    public static VirtualUser getUser(double id) throws IOException, SQLException {
        long dif;
        VirtualUser user = VirtualUser.findUser(id);
        if (user != null && (dif = System.currentTimeMillis() - user.time) >= 0L && dif < 1000L) {
            return user;
        }
        UsersTable table = new UsersTable();
        SqlParameter[] attributes = table.select(null, id);
        if (attributes == null) {
            return null;
        }
        if (user != null && VirtualUser.isAttributesEqual(attributes, user.attributes)) {
            user.time = System.currentTimeMillis();
            return user;
        }
        return VirtualUser.createUser(attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualUser getUser(String name) throws IOException, SQLException {
        if (Ini.SafeMode) {
            return null;
        }
        UsersTable table = new UsersTable();
        SqlParameter[] attributes = table.select(null, name);
        if (attributes == null) {
            return null;
        }
        Class<VirtualUser> clazz = VirtualUser.class;
        synchronized (VirtualUser.class) {
            VirtualUser user = nameCache.get(name);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (user != null && VirtualUser.isAttributesEqual(attributes, user.attributes)) {
                user.time = System.currentTimeMillis();
                return user;
            }
            return VirtualUser.createUser(attributes);
        }
    }

    public static VirtualUser loadTempUser(SqlParameter[] attributes) throws IOException, SQLException {
        return new VirtualUser(attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateUser(double userId) {
        Class<VirtualUser> clazz = VirtualUser.class;
        synchronized (VirtualUser.class) {
            VirtualUser user = userCache.get(userId);
            if (user != null) {
                nameCache.remove(user.getName());
                userCache.remove(userId);
                AccountNode.invalidateSecurity();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outdateUser(double userId) {
        Class<VirtualUser> clazz = VirtualUser.class;
        synchronized (VirtualUser.class) {
            VirtualUser user = userCache.get(userId);
            if (user != null) {
                user.time = 0L;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    private static boolean isAttributesEqual(SqlParameter[] n, SqlParameter[] o) {
        if (n == null || o == null) {
            return false;
        }
        if (n.length != o.length) {
            return false;
        }
        block7: for (int utf = 0; utf < n.length; ++utf) {
            SqlParameter np = n[utf];
            SqlParameter op = o[utf];
            if (np == null || op == null) {
                if (np == null && op == null) continue;
                return false;
            }
            if (np.getType() != op.getType()) {
                return false;
            }
            switch (np.getType()) {
                case BLOB: 
                case GEOMETRY: {
                    if (Arrays.equals(np.getBlob(), op.getBlob())) continue block7;
                    return false;
                }
                case STRING: 
                case UNICODE: {
                    if (Strings.equals(np.getString(), op.getString())) continue block7;
                    return false;
                }
                case DATE_TIME: 
                case TIMESTAMP: {
                    if (np.getDateTime() == op.getDateTime()) continue block7;
                    return false;
                }
                case BOOLEAN: {
                    if (np.getBoolean() == op.getBoolean()) continue block7;
                    return false;
                }
                case INTEGER: 
                case DOUBLE: {
                    if (np.getDouble() == op.getDouble()) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VirtualUser createUser(SqlParameter[] attributes) throws IOException, SQLException {
        VirtualUser user = new VirtualUser(attributes);
        Class<VirtualUser> clazz = VirtualUser.class;
        synchronized (VirtualUser.class) {
            userCache.add(user);
            nameCache.put(user.getName(), user);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return user;
        }
    }

    private static final NodeRecord createRecord(SqlParameter[] attributes) {
        assert (attributes != null);
        assert (attributes.length == 22);
        NodeRecord r = new NodeRecord();
        r.setId(attributes[0].getDouble());
        r.setName(attributes[1].getString());
        r.setParentId(attributes[2].getDouble());
        r.setType(3);
        return r;
    }

    @Override
    public VirtualUser clone(double appId, NodeStatus status) throws InformException {
        VirtualUser.invalidateUser(this.getId());
        this.status = status;
        return this;
    }

    @Override
    protected boolean isDeletedImpl(LogContext.Builder cause) {
        if (this.props.getDeleted()) {
            if (cause != null) {
                cause.append("props.deleted", true);
            }
            return true;
        }
        return false;
    }

    @Override
    public double[] getChildren(Connector connector) throws InformException {
        return Empty.doubleArray;
    }
}

