/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;

public class DArray
extends DObject {
    public DArray(DProperty object, String name) {
        this(object, name, 0);
    }

    public DArray(DProperty object, String name, int propOptions) {
        super(object, name, propOptions | 0x10);
    }

    public void add(DProperty property) {
        this.properties.add(property);
    }

    public boolean remove(DProperty property) {
        return this.properties.remove(property);
    }

    public void clear() {
        this.properties.clear();
    }

    @Override
    public boolean isEmpty() {
        for (DProperty p : this.properties) {
            if (p.isDefault() || !p.isStorable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDefault() {
        return this.checkPropOptions(2) && this.unhandledItems.isEmpty() && this.isEmpty();
    }

    public DProperty getDefaultArrayItem() {
        return null;
    }

    @Override
    public int storeSpec(int textOptions, StringBuilder out, int level, boolean needComma) {
        if ((textOptions & 0x10) == 0) {
            DArray.addTextShiftLn(textOptions, out, level).append(this.name).append(": ");
        }
        DArray.addTextShiftLn(textOptions, out, level).append("{");
        DProperty item = this.getDefaultArrayItem();
        if (item != null) {
            item.storeSpec(16, out, level + 1, false);
        } else {
            DArray.addTextShiftLn(textOptions, out, level + 1).append("arrayItem: {}");
        }
        out.append(", ").append("... ");
        DArray.addTextShiftLn(textOptions, out, level).append("}");
        return 1;
    }
}

