/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DFieldArray;
import inform.agent.mtd.obj.DFieldRef;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyDatasource;
import inform.agent.mtd.obj.DPropertyField;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.NonVisualComponent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DDatalocator
extends NonVisualComponent {
    private final ByteArrayOutputStream leftOver = new ByteArrayOutputStream();
    protected DPropertyDatasource datasourceNamespace = new DPropertyDatasource(this, "datasourceNamespace");
    protected final DPropertyString dlDescription = new DPropertyString(this, "dlDescription", 524290, "");
    protected DPropertyDatasource datasourceID = new DPropertyDatasource(this, "datasourceID");
    protected DPropertyField datasourceFieldID = new DPropertyField((DProperty)this, "datasourceFieldID", 0, this.datasourceID);
    protected final DFieldArray fieldsArr = new DFieldArray(this, "fields");
    protected final DFieldArray dlFieldsArr = new DFieldArray(this, "dlFields");

    public DDatalocator(int id, int options) {
        super(502, id, options);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        int tag;
        block7: while ((tag = in.getNextTag()) != 0) {
            switch (tag) {
                case 40: {
                    this.dlDescription.loadTaggedContent(in);
                    continue block7;
                }
                case 159: {
                    byte[] data = in.getRaw();
                    if (data.length != 8) {
                        throw new InformException("Invalid TAG_DATASOURCE_FIELD_REF");
                    }
                    this.datasourceID.value = LittleEndian.getInt(data, 0);
                    this.datasourceFieldID.value = LittleEndian.getInt(data, 4);
                    continue block7;
                }
                case 162: {
                    this.datasourceNamespace.loadTaggedContent(in);
                    continue block7;
                }
                case 163: {
                    this.fieldsArr.loadTaggedContent(in);
                    continue block7;
                }
                case 41: {
                    in.skip();
                    byte[] data = in.getSubStreamData();
                    for (int i = 0; i < data.length; i += 4) {
                        int rest = data.length - i;
                        if (rest < 4) {
                            this.leftOver.write(data, i, rest);
                            continue block7;
                        }
                        ByteBuffer buffer = ByteBuffer.wrap(data, i, 4);
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        DFieldRef item = new DFieldRef((DProperty)this, DFieldRef.Kind.Dl);
                        item.dlField.fieldId.value = buffer.getInt();
                        item.kind = DFieldRef.Kind.Dl;
                        this.dlFieldsArr.properties.add(item);
                    }
                    continue block7;
                }
            }
            super.loadTag(in);
        }
    }

    @Override
    public void storeTaggedContent(int[] header, TaggedWriter out) throws IOException {
        byte[] data;
        this.getHeader(header);
        if (!this.dlDescription.isDefault()) {
            this.dlDescription.storeTaggedContentAs(40, out);
        }
        if (!this.datasourceID.isDefault() || !this.datasourceFieldID.isDefault()) {
            data = new byte[8];
            LittleEndian.setInteger(this.datasourceID.value, data, 0);
            LittleEndian.setInteger(this.datasourceFieldID.value, data, 4);
            out.putRaw(159, data);
        }
        this.datasourceNamespace.storeTaggedContentAs(162, out);
        this.fieldsArr.storeTaggedContent(out);
        data = new byte[this.dlFieldsArr.properties.size() * 4];
        int offset = 0;
        for (DProperty p : this.dlFieldsArr.properties) {
            DFieldRef field = (DFieldRef)p;
            if (field.kind != DFieldRef.Kind.Dl) {
                offset += 4;
                continue;
            }
            LittleEndian.setInteger(field.dlField.fieldId.value, data, offset);
            offset += 4;
        }
        if (this.leftOver.size() > 0) {
            byte[] buf = this.leftOver.internalBuffer();
            for (int i = 0; i < this.leftOver.size(); ++i) {
                LittleEndian.setByte(buf[i], buf, offset++);
            }
        }
        out.putEmpty(41);
        out.putRaw(202, data);
    }
}

