/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.mtd.obj.DBuildupDatasource;
import inform.agent.mtd.obj.DComponent;
import inform.agent.mtd.obj.DComponentContainer;
import inform.agent.mtd.obj.DComponents;
import inform.agent.mtd.obj.DControl;
import inform.agent.mtd.obj.DDatamodel;
import inform.agent.mtd.obj.DDatasource;
import inform.agent.mtd.obj.DDirectoryDatasource;
import inform.agent.mtd.obj.DFormControl;
import inform.agent.mtd.obj.DFormDocument;
import inform.agent.mtd.obj.DFormEdit;
import inform.agent.mtd.obj.DFormExtButton;
import inform.agent.mtd.obj.DFormExtButtons;
import inform.agent.mtd.obj.DFormGrid;
import inform.agent.mtd.obj.DFormImage;
import inform.agent.mtd.obj.DFormPageControl;
import inform.agent.mtd.obj.DFormScheme;
import inform.agent.mtd.obj.DFormShortcut;
import inform.agent.mtd.obj.DFormShortcuts;
import inform.agent.mtd.obj.DFormSplitter;
import inform.agent.mtd.obj.DFormTabshit;
import inform.agent.mtd.obj.DGridColumn;
import inform.agent.mtd.obj.DLayout;
import inform.agent.mtd.obj.DLayoutControl;
import inform.agent.mtd.obj.DParameter;
import inform.agent.mtd.obj.DParameterBind;
import inform.agent.mtd.obj.DParameters;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyControl;
import inform.agent.mtd.obj.DPropertyDatasource;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyEnumSet;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyNodeRef;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.NonVisualComponent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mozilla.javascript.NativeArray;

public class DForm
extends DControl
implements DComponentContainer,
DLayoutControl {
    private final HashSet<String> uniqueNames = new HashSet();
    private int legacyX = 0;
    private int legacyY = 0;
    private final DDatamodel datamodel = new DDatamodel(this);
    private final DComponents components = new DComponents((DProperty)this, 4);
    private final DPropertyEnum windowKind = new DPropertyEnum(this, "windowKind", 131584, FORM_WINDOW_KIND_NAMES);
    private final DPropertyEnum formPosition = new DPropertyEnum((DProperty)this, "position", 131584, 3, FORM_POSITION_NAMES);
    private final DPropertyInt pixelPerInch = new DPropertyInt(this, "dpi", 33280, 96);
    private final DPropertyInt deltaLeft = new DPropertyInt(this, "deltaLeft", 32770, 0);
    private final DPropertyInt deltaTop = new DPropertyInt(this, "deltaTop", 32898, 0);
    private final DPropertyString caption = new DPropertyString(this, "caption", 0x200002);
    private final DPropertyString configuration = new DPropertyString(this, "configuration", 0x200002);
    private final DLayout layout = new DLayout(this, "layout");
    private final DPropertyEnum mdiTabOrientation = new DPropertyEnum((DProperty)this, "mdiTabOrientation", 32770, 0, MDI_TAB_ORIENTATION_NAMES);
    private final DPropertyBool autoSave = new DPropertyBool(this, "autoSave", 8194, true);
    private final DPropertyBool initialEditMode = new DPropertyBool(this, "initialEditMode", 4098, false);
    private final DPropertyNodeRef backgroundNodeId = new DPropertyNodeRef(this, "backgroundNode", 2, 0.0);
    private final DPropertyControl activeControl = new DPropertyControl(this, "activeControl");
    private final DPropertyEnumSet standardButtons = new DPropertyEnumSet((DProperty)this, "standardButtons", 33280, 7, FORM_STANDARD_BUTTON_NAMES);
    private final DPropertyControl formFilterControl = new DPropertyControl(this, "formFilterControl");
    private final DPropertyNodeRef helpNodeId = new DPropertyNodeRef(this, "helpNode", 2, 0.0);
    private final DPropertyBool statusbarVisible = new DPropertyBool(this, "statusbarVisible", 8194, true);
    private final DPropertyBool mainMenuVisible = new DPropertyBool(this, "mainMenuVisible", 8194, true);
    private final DPropertyBool mainToolbarVisible = new DPropertyBool(this, "mainToolbarVisible", 8194, true);
    private final DPropertyBool minimizeToTray = new DPropertyBool(this, "minimizeToTray", 4098, false);
    private final DPropertyBool jitEnabled = new DPropertyBool(this, "jitEnabled", 8194, true);
    private final DPropertyNodeRef formStyleNodeId = new DPropertyNodeRef(this, "formStyleNodeId", 2, 0.0);
    private final DPropertyInt imageId = new DPropertyInt(this, "formIconId", 32770, 0);
    private final DPropertyBool stayOnTop = new DPropertyBool(this, "stayOnTop", 4098, false);
    private final DFormExtButtons extButtons = new DFormExtButtons(this, "extButtons");
    private final DPropertyDatasource toolbarDatasource = new DPropertyDatasource(this, "toolbarDatasource");
    private final DFormShortcuts shortcuts = new DFormShortcuts(this, "shortcuts");
    private final DPropertyString onHelp = new DPropertyString(this, "onHelp", 0x200002);
    private final DPropertyString onInitialize = new DPropertyString(this, "onInitialize", 0x200002);
    private final DPropertyString onFinalize = new DPropertyString(this, "onFinalize", 0x200002);
    private final DPropertyString onActivate = new DPropertyString(this, "onActivate", 0x200002);
    private final DPropertyString onBeforeInputParams = new DPropertyString(this, "onBeforeInputParams", 0x200002);
    private final DPropertyString onAfterInputParams = new DPropertyString(this, "onAfterInputParams", 0x200002);
    private final DPropertyString onBeforeEditModeChanged = new DPropertyString(this, "onBeforeEditModeChanged", 0x200002);
    private final DPropertyString onAfterEditModeChanged = new DPropertyString(this, "onAfterEditModeChanged", 0x200002);
    private final DPropertyString onCloseQuery = new DPropertyString(this, "onCloseQuery", 0x200002);
    private final DPropertyString onUpdate = new DPropertyString(this, "onUpdate", 0x200002);
    private final DPropertyString onBeforeCommit = new DPropertyString(this, "onBeforeCommit", 0x200002);
    private final DPropertyString onAfterCommit = new DPropertyString(this, "onAfterCommit", 0x200002);
    private final DPropertyString onBeforeRollback = new DPropertyString(this, "onBeforeRollback", 0x200002);
    private final DPropertyString onRollback = new DPropertyString(this, "onRollback", 0x200002);
    private final DPropertyString script = new DPropertyString(this, "script", 0x200002);

    public DForm() {
        this.id.setStorable(false);
        this.color.setDefaultValue(-16777211);
        this.width.setDefaultValue(320);
        this.height.setDefaultValue(240);
        this.parentFont.setStorable(false);
        this.parentColor.setStorable(false);
        this.x.setScriptable(false);
        this.y.setScriptable(false);
        this.datamodel.setStorable(false);
        this.components.setStorable(false);
        this.script.setScriptable(false);
        this.children.setStorable(false);
    }

    @Override
    public int getLayoutType() {
        return this.layout.layoutType.value;
    }

    @Override
    public ArrayList<DComponent> getChildren() {
        ArrayList<DComponent> components = new ArrayList<DComponent>();
        for (DProperty p : this.components.properties) {
            if (!p.isStorable() || p.checkPropOptions(2) && p.isDefault() || !(p instanceof DComponent) || ((DComponent)p).isControl()) continue;
            components.add((DComponent)p);
        }
        components.addAll(this.children.getComponents());
        return components;
    }

    protected void loadProps(TaggedReader in) throws IOException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 41: {
                    in.checkCurrentTag(41, 8);
                    int[] ints = LittleEndian.toIntArray(in.getRaw());
                    this.width.setValue(ints[0]);
                    this.height.setValue(ints[1]);
                    break;
                }
                case 84: {
                    in.checkCurrentTag(84, 8);
                    int[] ints = LittleEndian.toIntArray(in.getRaw());
                    this.deltaLeft.setValue(ints[0]);
                    this.deltaTop.setValue(ints[1]);
                    break;
                }
                case 40: {
                    in.checkCurrentTag(40, 8);
                    int[] ints = LittleEndian.toIntArray(in.getRaw());
                    this.width.setValue(ints[0]);
                    this.height.setValue(ints[1]);
                    break;
                }
                case 11: {
                    this.color.setValue(in.getInt());
                    break;
                }
                case 10: {
                    this.constraints.loadTaggedContent(in);
                    break;
                }
                case 15: {
                    this.caption.setValue(in.getString());
                    break;
                }
                case 49: {
                    this.configuration.setValue(in.getString());
                    break;
                }
                case 6: {
                    this.font.loadTaggedContent(in);
                    this.parentFont.setValue(false);
                    break;
                }
                case 43: {
                    this.formPosition.loadTaggedContent(in);
                    break;
                }
                case 42: {
                    this.windowKind.loadTaggedContent(in);
                    break;
                }
                case 80: {
                    this.mdiTabOrientation.loadTaggedContent(in);
                    break;
                }
                case 44: {
                    this.legacyX = in.getInt();
                    break;
                }
                case 45: {
                    this.legacyY = in.getInt();
                    break;
                }
                case 47: {
                    this.formPosition.setValue(1);
                    break;
                }
                case 48: {
                    this.autoSave.loadTaggedContent(in);
                    break;
                }
                case 56: {
                    this.initialEditMode.loadTaggedContent(in);
                    break;
                }
                case 38: {
                    this.onHelp.loadTaggedContent(in);
                    break;
                }
                case 51: {
                    this.onInitialize.loadTaggedContent(in);
                    break;
                }
                case 68: {
                    this.onFinalize.loadTaggedContent(in);
                    break;
                }
                case 93: {
                    this.onActivate.loadTaggedContent(in);
                    break;
                }
                case 52: {
                    this.backgroundNodeId.loadTaggedContent(in);
                    break;
                }
                case 55: {
                    this.activeControl.loadTaggedContent(in);
                    break;
                }
                case 53: {
                    this.onBeforeInputParams.loadTaggedContent(in);
                    break;
                }
                case 54: {
                    this.onAfterInputParams.loadTaggedContent(in);
                    break;
                }
                case 61: {
                    this.onAfterEditModeChanged.loadTaggedContent(in);
                    break;
                }
                case 82: {
                    this.onBeforeEditModeChanged.loadTaggedContent(in);
                    break;
                }
                case 64: {
                    this.onCloseQuery.loadTaggedContent(in);
                    break;
                }
                case 65: {
                    this.onUpdate.loadTaggedContent(in);
                    break;
                }
                case 76: {
                    this.onBeforeCommit.loadTaggedContent(in);
                    break;
                }
                case 66: {
                    this.onAfterCommit.loadTaggedContent(in);
                    break;
                }
                case 67: {
                    this.onRollback.loadTaggedContent(in);
                    break;
                }
                case 88: {
                    this.onBeforeRollback.loadTaggedContent(in);
                    break;
                }
                case 50: {
                    this.standardButtons.loadTaggedContent(in);
                    break;
                }
                case 81: {
                    this.formFilterControl.loadTaggedContent(in);
                    break;
                }
                case 59: {
                    this.toolbarDatasource.loadTaggedContent(in);
                    break;
                }
                case 60: {
                    this.extButtons.loadTaggedContent(in.getSubStreamReader());
                    break;
                }
                case 75: {
                    this.imageId.loadTaggedContent(in);
                    break;
                }
                case 77: {
                    this.stayOnTop.loadTaggedContent(in);
                    break;
                }
                case 78: {
                    TaggedReader stream = in.getStreamReader();
                    DFormShortcut shortcut = null;
                    while (stream.next()) {
                        if (stream.getCurrentTag() == 24) {
                            shortcut = new DFormShortcut(this.shortcuts);
                            this.shortcuts.properties.add(shortcut);
                        }
                        if (shortcut == null) continue;
                        shortcut.loadTaggedContent(stream);
                    }
                    break;
                }
                case 79: {
                    this.helpNodeId.loadTaggedContent(in);
                    break;
                }
                case 83: {
                    this.statusbarVisible.loadTaggedContent(in);
                    break;
                }
                case 85: {
                    this.mainMenuVisible.loadTaggedContent(in);
                    break;
                }
                case 86: {
                    this.mainToolbarVisible.loadTaggedContent(in);
                    break;
                }
                case 87: {
                    this.minimizeToTray.loadTaggedContent(in);
                    break;
                }
                case 91: {
                    this.formStyleNodeId.loadTaggedContent(in);
                    break;
                }
                case 89: {
                    this.jitEnabled.loadTaggedContent(in);
                    break;
                }
                case 90: {
                    this.layout.loadLayoutType(in);
                    this.layout.loadTaggedContent(in.getStreamReader());
                }
            }
        }
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        block11: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 150: {
                    continue block11;
                }
                case 154: {
                    this.accessRights.loadTaggedContent(in);
                    continue block11;
                }
                case 152: {
                    in.skip();
                    this.datamodel.loadTaggedContent(in.getStreamReader(202));
                    continue block11;
                }
                case 42: {
                    this.windowKind.loadTaggedContent(in);
                    continue block11;
                }
                case 4: {
                    in.skip();
                    this.loadProps(in.getStreamReader(202));
                    continue block11;
                }
                case 3: {
                    in.skip();
                    this.components.loadTaggedContent(in.getStreamReader(202), this, this);
                    continue block11;
                }
                case 23: {
                    this.script.loadTaggedContent(in);
                    continue block11;
                }
                case 17: {
                    if (this.script.isEmpty()) continue block11;
                    this.script.loadTaggedContent(in);
                    continue block11;
                }
                case 29: {
                    if (in.getCurrentTagSize() != 4) continue block11;
                    this.pixelPerInch.loadTaggedContent(in);
                    continue block11;
                }
            }
            this.addUnhandled().loadTaggedContent(in);
        }
        this.afterLoad();
    }

    @Override
    public String addUniqueString(String value) {
        return DForm.isValidScriptNameSimple(value) && !"form".equals(value) && this.uniqueNames.add(value) ? value : "";
    }

    @Override
    public boolean canAddUniqueString(String value) {
        return DForm.isValidScriptNameSimple(value) && !"form".equals(value) && this.uniqueNames.contains(value);
    }

    public void createParametersJavaScriptObject(Object jsParameters, ArrayList<DProperty> publicIds) {
        if (jsParameters instanceof DParameters) {
            this.datamodel.parameters.assign((DParameters)jsParameters);
        } else if (jsParameters instanceof NativeArray) {
            this.datamodel.parameters.loadScriptValue(jsParameters);
        }
    }

    public void createDatamodelJavaScriptObjects(Object jsDatamodel, ArrayList<DProperty> publicIds) {
        if (jsDatamodel instanceof DDatamodel) {
            this.datamodel.assign((DDatamodel)jsDatamodel);
        }
        publicIds.add(this.datamodel);
    }

    public void createComponentsJavaScriptObjects(Object jsComponents, ArrayList<DProperty> publicIds) {
        int[] header = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        if (jsComponents instanceof NativeArray) {
            NativeArray array = (NativeArray)jsComponents;
            long count = array.getLength();
            for (long index = 0L; index < count; ++index) {
                Object item = array.get(index);
                if (!DForm.checkAssignType(item, NonVisualComponent.class)) continue;
                NonVisualComponent sourceComponent = (NonVisualComponent)item;
                sourceComponent.getHeader(header);
                NonVisualComponent component = DComponents.createDesignComponent(header, this);
                component.assign(sourceComponent);
                this.components.registerProperty(component);
                String scriptName = component.getPropName();
                if (scriptName.isEmpty()) continue;
                publicIds.add(component);
            }
        }
    }

    public void createControlsJavaScriptObjects(Object jsControls, ArrayList<DProperty> publicIds) {
        int[] header = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        if (jsControls instanceof NativeArray) {
            NativeArray array = (NativeArray)jsControls;
            long count = array.getLength();
            for (long index = 0L; index < count; ++index) {
                Object item = array.get(index);
                if (!DForm.checkAssignType(item, DFormControl.class)) continue;
                DFormControl sourceControl = (DFormControl)item;
                sourceControl.getHeader(header);
                DFormControl control = DComponents.createDesignControl(header, this, this);
                control.assign(sourceControl);
                this.components.registerProperty(control);
                control.getPublicIds(publicIds);
            }
        }
    }

    public void createFromPropsJavaScriptObjects(Object jsFormProps, String clientScript) {
        if (jsFormProps instanceof DForm) {
            this.assign((DForm)jsFormProps);
        }
        this.script.value = clientScript;
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        out.putEmpty(150);
        this.windowKind.storeTaggedContentAs(42, out);
        this.pixelPerInch.storeTaggedContentAs(29, out);
        this.accessRights.storeTaggedContentAs(154, out);
        this.datamodel.storeTaggedContentAsStream(152, out);
        this.script.storeTaggedContentAs(23, out);
        this.storeTaggedFormPropsAs(4, out);
        this.components.storeTaggedChildren(this, out);
    }

    protected void storeTaggedFormPropsAs(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        this.storeTaggedFormProps(stream);
        stream.flush();
        out.putEmpty(tag);
        out.putRaw(202, data);
    }

    protected void storeTaggedFormProps(TaggedWriter out) throws IOException {
        int offset = 0;
        byte[] raw = new byte[16];
        LittleEndian.setInteger(this.width.value, raw, offset);
        LittleEndian.setInteger(this.height.value, raw, offset += 4);
        out.putRaw(41, raw, 8);
        offset = 0;
        LittleEndian.setInteger(this.deltaLeft.value, raw, offset);
        LittleEndian.setInteger(this.deltaTop.value, raw, offset += 4);
        out.putRaw(84, raw, 8);
        this.constraints.storeTaggedContentAs(10, out);
        this.color.storeTaggedContentAs(11, out);
        this.font.storeTaggedContentAs(6, out);
        this.caption.storeTaggedContentAs(15, out);
        this.stayOnTop.storeTaggedContentAs(77, out);
        this.configuration.storeTaggedContentAs(49, out);
        this.formPosition.storeTaggedContentAs(43, out);
        this.windowKind.storeTaggedContentAs(42, out);
        this.mdiTabOrientation.storeTaggedContentAs(80, out);
        this.autoSave.storeTaggedContentAs(48, out);
        this.initialEditMode.storeTaggedContentAs(56, out);
        this.jitEnabled.storeTaggedContentAs(89, out);
        this.onInitialize.storeTaggedContentAs(51, out);
        this.onFinalize.storeTaggedContentAs(68, out);
        this.onBeforeInputParams.storeTaggedContentAs(53, out);
        this.onAfterInputParams.storeTaggedContentAs(54, out);
        this.onAfterEditModeChanged.storeTaggedContentAs(61, out);
        this.onBeforeEditModeChanged.storeTaggedContentAs(82, out);
        this.onCloseQuery.storeTaggedContentAs(64, out);
        this.onUpdate.storeTaggedContentAs(65, out);
        this.onBeforeCommit.storeTaggedContentAs(76, out);
        this.onAfterCommit.storeTaggedContentAs(66, out);
        this.onRollback.storeTaggedContentAs(67, out);
        this.onBeforeRollback.storeTaggedContentAs(88, out);
        this.onHelp.storeTaggedContentAs(38, out);
        this.onActivate.storeTaggedContentAs(93, out);
        if (!this.shortcuts.isEmpty()) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(data);
            for (DProperty p : this.shortcuts.properties) {
                p.storeTaggedContent(stream);
            }
            stream.flush();
            out.putRaw(78, data);
        }
        this.backgroundNodeId.storeTaggedContentAs(52, out);
        this.activeControl.storeTaggedContentAs(55, out);
        this.imageId.storeTaggedContentAs(75, out);
        this.helpNodeId.storeTaggedContentAs(79, out);
        this.statusbarVisible.storeTaggedContentAs(83, out);
        this.mainMenuVisible.storeTaggedContentAs(85, out);
        this.mainToolbarVisible.storeTaggedContentAs(86, out);
        this.minimizeToTray.storeTaggedContentAs(87, out);
        this.layout.storeTaggedContentAsNonEmptyStream(90, out);
        this.formStyleNodeId.storeTaggedContentAs(91, out);
        this.toolbarDatasource.storeTaggedContentAs(59, out);
        this.standardButtons.storeTaggedContentAs(50, out);
        this.formFilterControl.storeTaggedContentAs(81, out);
        this.extButtons.storeTaggedContentAsNonEmptyStream(60, out);
    }

    public void storeSpec(StringBuilder out) {
        int[] header;
        int id;
        int i;
        int textOptions = 0;
        int level = 0;
        DProperty paramProp = this.datamodel.parameters.getDefaultArrayItem();
        DForm.addPropertyDeclaration(out, "parameter").append(" =");
        paramProp.storeSpec(16, out, level, false);
        out.append(";\n\n");
        out.append("const ").append("parameters").append(" = \n[");
        DForm.addMtdInitProp(textOptions, out, level + 1, "parameter").append(", ").append("... ");
        DForm.addNewLineIfNeed(textOptions, out).append("];\n\n");
        DForm.addPropertyDeclaration(out, "datasource").append(" =");
        DDatasource datasource = new DDatasource((DProperty)this, 2, null);
        datasource.storeSpec(16, out, level, false);
        out.append(";\n\n");
        DForm.addPropertyDeclaration(out, "directoryDatasource").append(" =");
        DDirectoryDatasource directoryDatasource = new DDirectoryDatasource((DProperty)this, null);
        directoryDatasource.storeSpec(16, out, level, false);
        out.append(";\n\n");
        DForm.addPropertyDeclaration(out, "directoryDatasource").append(" =");
        DBuildupDatasource buildupDatasource = new DBuildupDatasource((DProperty)this, null);
        buildupDatasource.storeSpec(16, out, level, false);
        out.append(";\n\n");
        out.append("const ").append("datamodel").append(" = ").append("\n[");
        DForm.addTextShiftLn(textOptions, out, level + 1).append("children:");
        DForm.addTextShiftLn(textOptions, out, level + 1).append("[");
        DForm.addMtdInitProp(textOptions, out, level + 2, "datasource").append(", ");
        DForm.addMtdInitProp(textOptions, out, level + 2, "directoryDatasource").append(", ");
        DForm.addMtdInitProp(textOptions, out, level + 2, "buildupDatasource");
        DForm.addTextShiftLn(textOptions, out, level + 1).append("]");
        DForm.addNewLineIfNeed(textOptions, out).append("];\n\n");
        for (i = 0; i < COMPONENT_VALUES.length; ++i) {
            id = COMPONENT_VALUES[i];
            if (id == 1001 || id == 1201) continue;
            header = new int[]{id, id, id, id, id, id, id};
            NonVisualComponent component = DComponents.createDesignComponent(header, this);
            DForm.addPropertyDeclaration(out, COMPONENT_NAMES[i]).append(" =");
            component.storeSpec(16, out, level, false);
            out.append(";\n\n");
        }
        out.append("const ").append("components").append(" =\n[");
        for (i = 0; i != COMPONENT_NAMES.length - 2; ++i) {
            DForm.addComma(out, i != 0);
            DForm.addMtdInitProp(textOptions, out, level + 1, COMPONENT_NAMES[i]);
        }
        DForm.addNewLineIfNeed(textOptions, out).append("];\n\n");
        for (i = 0; i < FORM_CONTROL_NAMES.length; ++i) {
            id = FORM_CONTROL_VALUES[i];
            header = new int[]{id, id, id, id, id, id, id};
            DFormControl control = DComponents.createDesignControl(header, this, this);
            DForm.addPropertyDeclaration(out, FORM_CONTROL_NAMES[i]).append(" =");
            control.storeSpec(16, out, level, false);
            out.append(";\n\n");
        }
        out.append("const ").append("controls").append(" =\n[");
        for (i = 0; i != FORM_CONTROL_NAMES.length; ++i) {
            DForm.addComma(out, i != 0);
            DForm.addMtdInitProp(textOptions, out, level + 1, FORM_CONTROL_NAMES[i]);
        }
        DForm.addNewLineIfNeed(textOptions, out).append("];\n\n");
        DForm.addMtdInitProp(textOptions, out, level, "form").append("\n[");
        int count = 0;
        for (DProperty prop : this.properties) {
            if (prop instanceof DDatamodel || prop instanceof DComponents || prop.name == "script") continue;
            DForm.addComma(out, count != 0);
            ++count;
            prop.storeSpec(textOptions, out, level + 1, false);
        }
        DForm.addNewLineIfNeed(textOptions, out).append("];\n\n");
        out.append("const ").append("form").append(" =\n[");
        DForm.addMtdInitProp(textOptions, out, level + 1, "form");
        DForm.addNewLineIfNeed(textOptions, out).append("];");
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        textOptions = 0;
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("PARAMETERS").append("\n");
        this.datamodel.parameters.storeTextContent(12, out, 0, false);
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("PARAMETERS").append("\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("DATAMODEL").append("\n");
        this.datamodel.storeNamedNodes(out).append('\n');
        StringBuilder props = new StringBuilder();
        int propCount = this.datamodel.storeTextContentProperties(textOptions, props, level + 1);
        out.append("const ").append("datamodel").append(" = ").append(this.datamodel.dsl);
        if (propCount != 0) {
            out.append("\n({").append((CharSequence)props);
            DForm.addNewLineIfNeed(textOptions, out);
            out.append("});");
        } else {
            out.append("();");
        }
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("DATAMODEL").append("\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("COMPONENTS").append("\n");
        int itemCount = 0;
        ArrayList<DProperty> propList = new ArrayList<DProperty>();
        props = new StringBuilder();
        for (DProperty p : this.components.properties) {
            if (!p.isStorable() || !p.scriptable() || p.checkPropOptions(2) && p.isDefault() || !(p instanceof DComponent) || ((DComponent)p).isControl()) continue;
            if (itemCount != 0) {
                props.append(',');
            }
            ++itemCount;
            p.storeTextContent(textOptions, props, level + 1, false);
            if (!((DComponent)p).isTextNameStorable()) continue;
            propList.add(p);
        }
        if (itemCount != 0) {
            for (DProperty property : propList) {
                property.storeTextContent(12, out, 0, false);
            }
            DForm.addNewLineIfNeed(textOptions, out).append("const ").append("components").append(" = \n[").append((CharSequence)props);
            DForm.addNewLineIfNeed(textOptions, out).append("];\n");
        } else {
            out.append("const ").append("components").append(" = [];\n");
        }
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("COMPONENTS").append("\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("CONTROLS").append("\n");
        this.children.storeNamedControls(out).append('\n');
        props = new StringBuilder();
        itemCount = this.children.storeTextContentProperties(textOptions, props, level + 1);
        if (itemCount != 0) {
            DForm.addNewLineIfNeed(textOptions, out).append("const ").append("controls").append(" = \n[\n").append((CharSequence)props);
            DForm.addNewLineIfNeed(textOptions, out).append("];\n");
        } else {
            out.append("const ").append("controls").append(" = [];\n");
        }
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("CONTROLS").append("\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("FORM").append("\n");
        out.append("const ").append("form").append(" = ").append("MtdForm.form").append("\n({");
        this.storeTextContentProperties(textOptions, out, level + 1);
        DForm.addNewLineIfNeed(textOptions, out).append("});\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("FORM").append("\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("CLIENT SCRIPT").append("\n");
        out.append(this.script.value);
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("CLIENT SCRIPT").append("\n");
        return 100;
    }

    @Override
    public void afterLoad() {
        this.components.afterLoad();
    }

    @Override
    public NonVisualComponent findComponent(int id) {
        return this.components.findComponent(id);
    }

    @Override
    public NonVisualComponent findComponent(int id, Class cls) {
        NonVisualComponent component = this.components.findComponent(id);
        return cls == null || cls.isInstance(component) ? component : null;
    }

    @Override
    public DControl findControl(int id) {
        return this.components.findControl(id);
    }

    @Override
    public DDatasource findDatasource(int uid) {
        return this.datamodel.findDatasource(uid);
    }

    @Override
    public DParameter findParameter(int paramId) {
        for (DProperty property : this.datamodel.parameters.properties) {
            if (!(property instanceof DParameter) || ((DParameter)property).id.value != paramId) continue;
            return (DParameter)property;
        }
        return null;
    }

    public static DForm createFormForViewData(double nodeId) throws IOException {
        Node node = MtdEngine.getValidNode(nodeId);
        TableDescriptor tableDescriptor = null;
        switch (node.getType()) {
            case 12: {
                tableDescriptor = ((TableNode)node).getDescriptor();
                break;
            }
            case 19: 
            case 49: {
                double tableId = 0.0;
                TaggedReader reader = new TaggedReader(new ByteArrayInputStream(MtdEngine.getNodeContent(nodeId)));
                while (reader.getNextTag() != 0) {
                    if (reader.getCurrentTag() != 1) continue;
                    tableId = reader.getNodeID();
                    break;
                }
                if (tableId == 0.0) break;
                tableDescriptor = TableDescriptor.getIfExists(tableId);
                break;
            }
            case 48: {
                double tableId = 0.0;
                TaggedReader reader = new TaggedReader(new ByteArrayInputStream(MtdEngine.getNodeContent(nodeId)));
                while (reader.getNextTag() != 0) {
                    if (reader.getCurrentTag() != 6) continue;
                    tableId = reader.getNodeID();
                    break;
                }
                if (tableId == 0.0) break;
                tableDescriptor = TableDescriptor.getIfExists(tableId);
            }
        }
        if (tableDescriptor == null) {
            throw new InformException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0440\u043d\u0435\u0432\u0430\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u043c\u043e\u0434\u0435\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        byte[] nodeContent = MtdEngine.getNodeContent(nodeId);
        DForm form = new DForm();
        int formWidth = 320;
        int formHeight = 240;
        double tableId = tableDescriptor.getNodeId();
        ArrayList<FieldDescriptor> primaryKeyFields = tableDescriptor.getPrimaryKeyFields();
        List<FieldDescriptor> notPKFields = tableDescriptor.getFields();
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        fields.addAll(primaryKeyFields);
        fields.addAll(notPKFields);
        int ctrlId = 0;
        HashMap<Integer, Integer> filedDS = new HashMap<Integer, Integer>();
        DDatasource tableDS = new DDatasource((DProperty)form, 2, form.datamodel);
        tableDS.tableNode.setValue(tableId);
        tableDS.uid.setValue(1);
        if (node.getType() == 19 || node.getType() == 49 || node.getType() == 48) {
            tableDS.searchNode.setValue(nodeId);
        }
        for (FieldDescriptor field : fields) {
            int datasourceId = tableDS.uid.getValue();
            if (field.getType() == DataType.DIRECTORY) {
                datasourceId = tableDS.datasources.properties.size() + 2;
                DDirectoryDatasource directoryDS = new DDirectoryDatasource((DProperty)form, tableDS);
                directoryDS.tableNode.setValue(field.getReferenceId());
                directoryDS.uid.setValue(datasourceId);
                directoryDS.referenceFieldId.setValue(field.getId());
                tableDS.datasources.properties.add(directoryDS);
            }
            filedDS.put(field.getId(), datasourceId);
        }
        TaggedReader reader = new TaggedReader(nodeContent);
        if (node.getType() == 48) {
            while (reader.next()) {
                if (reader.getCurrentTag() != 152) continue;
                form.datamodel.loadTaggedContent(reader.getSubStreamReader());
            }
        } else if (node.getType() == 19 || node.getType() == 49) {
            while (reader.next()) {
                if (reader.getCurrentTag() != 153) continue;
                form.datamodel.parameters.loadTaggedContent(reader.getSubStreamReader());
            }
        }
        ArrayList<DProperty> hiddenParams = new ArrayList<DProperty>();
        for (DProperty p : form.datamodel.parameters.properties) {
            if (!(p instanceof DParameter) || !((DParameter)p).hidden.value) continue;
            hiddenParams.add(p);
        }
        form.datamodel.parameters.properties.removeAll(hiddenParams);
        for (Object prop : form.datamodel.parameters.properties) {
            if (!(prop instanceof DParameter)) continue;
            DParameter dParameter = (DParameter)prop;
            DParameterBind dParameterBind = new DParameterBind(tableDS);
            dParameterBind.paramId.setValue(dParameter.id.getValue());
            dParameterBind.dataType.setValue(dParameter.dataType.getValue());
            dParameterBind.mapKind.setValue(2);
            dParameterBind.mapField.uid.setValue(-1);
            dParameterBind.mapField.field.setValue(dParameter.id.getValue());
            tableDS.parameters.add(dParameterBind);
        }
        boolean blobExists = false;
        if (!primaryKeyFields.isEmpty()) {
            for (FieldDescriptor fieldDescriptor : fields) {
                DataType dataType = fieldDescriptor.getType();
                if (dataType != DataType.BLOB && dataType != DataType.FILE && dataType != DataType.GEOMETRY) continue;
                blobExists = true;
                break;
            }
        }
        form.datamodel.datasources.properties.add(tableDS);
        form.formPosition.setValue(2);
        form.formPosition.setValue(1);
        form.autoSave.setValue(false);
        if (blobExists) {
            DFormExtButton btn = new DFormExtButton(form);
            btn.imageSize.setValue(1);
            btn.imageId.setValue(1028);
            btn.hint.setValue("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c BLOB \u043f\u043e\u043b\u044f");
            btn.onClick.setValue("ShowBLOB");
            form.extButtons.properties.add(btn);
            form.script.setValue("function ShowBLOB() { SplitterControl.visible = PageControl.visible = !PageControl.visible; }");
        }
        DFormGrid grid = new DFormGrid(ctrlId++, 0, 0, formWidth, formHeight, 0);
        grid.tabStop.setValue(true);
        grid.datasourceId.setValue(tableDS.uid.value);
        grid.readOnly.setValue(true);
        grid.waitLoadMessage.setValue("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 ...");
        grid.dataFilterParamsKind.setValue(1);
        grid.align.setValue(5);
        grid.anchors.setValue(9);
        form.children.add(grid);
        for (FieldDescriptor fieldDescriptor : fields) {
            DataType fieldType = fieldDescriptor.getType();
            if (fieldType == DataType.BLOB || fieldType == DataType.FILE || fieldType == DataType.GEOMETRY) continue;
            DGridColumn column = new DGridColumn(grid);
            column.caption.setValue(fieldDescriptor.getCaption());
            column.datasourceId.setValue((Integer)filedDS.get(fieldDescriptor.getId()));
            column.dataFieldId.setValue(fieldDescriptor.getId());
            column.dataFormatId.setValue(fieldDescriptor.getFormat());
            column.readOnly.setValue(false);
            column.titleAlignment.setValue(2);
            switch (fieldType) {
                case PRIMARY_KEY: {
                    column.width.setValue(100);
                    column.readOnly.setValue(true);
                    break;
                }
                case DIRECTORY: {
                    column.width.setValue(-1);
                    column.dataFieldId.setValue(fieldDescriptor.getRefFieldId());
                    break;
                }
                case DATE_TIME: {
                    column.width.setValue(100);
                    break;
                }
                default: {
                    column.width.setValue(-1);
                }
            }
            grid.columns.add(column);
        }
        if (blobExists) {
            DFormPageControl dFormPageControl = new DFormPageControl(ctrlId++, 0, 0, formWidth, formHeight, 0);
            dFormPageControl.setOwner(form);
            dFormPageControl.setScriptName("PageControl");
            dFormPageControl.tabStop.setValue(true);
            dFormPageControl.setVisible(false);
            dFormPageControl.align.setValue(2);
            dFormPageControl.anchors.setValue(9);
            dFormPageControl.tabVisible.setValue(true);
            for (FieldDescriptor field : fields) {
                DataType fieldType = field.getType();
                if (fieldType != DataType.BLOB && fieldType != DataType.GEOMETRY && fieldType != DataType.FILE || field.getBlobType() == FieldDescriptor.BlobType.REPORT) continue;
                int dsId = (Integer)filedDS.get(field.getId());
                DFormTabshit tab = new DFormTabshit(ctrlId++, 0, 24, 4, 100, 0);
                tab.caption.setValue(field.getCaption());
                tab.tabVisible.setValue(true);
                dFormPageControl.children.add(tab);
                switch (field.getBlobType()) {
                    case TEXT: {
                        DFormEdit edit = new DFormEdit(ctrlId++, 0, 24, 4, 100, 2);
                        edit.datasource.setValue(dsId);
                        edit.datafield.setValue(field.getId());
                        edit.align.setValue(5);
                        edit.anchors.setValue(9);
                        tab.children.add(edit);
                        break;
                    }
                    case IMAGE: 
                    case OBJECT: {
                        DFormImage image = new DFormImage(ctrlId++, 0, 24, 4, 100, 0);
                        image.datasourceID.setValue(dsId);
                        image.datafieldID.setValue(field.getId());
                        image.proportional.setValue(true);
                        image.center.setValue(true);
                        image.align.setValue(5);
                        image.anchors.setValue(9);
                        tab.children.add(image);
                        break;
                    }
                    case SCHEME: {
                        DFormScheme scheme = new DFormScheme(ctrlId++, 0, 24, 4, 100, 0);
                        scheme.datasourceID.setValue(dsId);
                        scheme.datafieldID.setValue(field.getId());
                        scheme.align.setValue(5);
                        scheme.anchors.setValue(9);
                        tab.children.add(scheme);
                        break;
                    }
                    case DOCUMENT: {
                        DFormDocument document = new DFormDocument(ctrlId++, 0, 24, 4, 100, 0);
                        document.datasourceId.setValue(dsId);
                        document.datasourceField.setValue(field.getId());
                        document.align.setValue(5);
                        document.anchors.setValue(9);
                        tab.children.add(document);
                    }
                }
            }
            DFormSplitter dFormSplitter = new DFormSplitter(ctrlId++, 0, 0, formWidth, formHeight, 0);
            dFormSplitter.setOwner(form);
            dFormSplitter.setScriptName("SplitterControl");
            dFormSplitter.associate.setValue(dFormPageControl.id.getValue());
            dFormSplitter.setVisible(false);
            dFormSplitter.align.setValue(2);
            dFormSplitter.anchors.setValue(13);
            form.children.add(dFormSplitter);
            form.children.add(dFormPageControl);
        }
        return form;
    }
}

