/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DAccessRights;
import inform.agent.mtd.obj.DFont;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyAction;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertySecurity;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.PropertyVisibilityReflection;
import java.io.IOException;

public class DFormExtButton
extends DObject
implements PropertyVisibilityReflection {
    protected final DPropertyEnum imageSize = new DPropertyEnum(this, "imageSize", 32768, IMAGE_SIZE_NAMES);
    protected final DPropertyInt imageId = new DPropertyInt(this, "imageId", 32770, 0);
    protected final DPropertyString caption = new DPropertyString(this, "caption", 0x200002);
    protected final DPropertyBool showCaption = new DPropertyBool(this, "showCaption", 0, false);
    protected final DPropertyString hint = new DPropertyString(this, "hint", 0x200002);
    protected final DPropertyString scriptName = new DPropertyString(this, "name", 0x200002);
    protected final DPropertyAction action = new DPropertyAction(this, "action");
    protected final DPropertyBool separator = new DPropertyBool(this, "separator", 4098, false);
    protected final DPropertyBool visible = new DPropertyBool(this, "visible", 8194, true);
    protected final DAccessRights accessRights = new DAccessRights(this, "accessRights");
    protected final DPropertyBool enabled = new DPropertyBool(this, "enabled", 8194, true);
    protected final DPropertyString onClick = new DPropertyString(this, "onClick", 0x200002);
    protected final DPropertyBool newToolBar = new DPropertyBool(this, "newToolBar", 4098, false);
    protected final DPropertyInt keystroke = new DPropertyInt(this, "shortcut", 49154);
    protected final DPropertyBool autoSave = new DPropertyBool(this, "autoSave", 4098, false);
    protected final DPropertyBool editModeOnly = new DPropertyBool(this, "editModeOnly", 4098, false);
    protected final DFont font = new DFont(this, "font");
    protected final DPropertyBool parentFont = new DPropertyBool(this, "parentFont", 4098, false);
    protected final DPropertySecurity security = new DPropertySecurity(this, "security");

    public DFormExtButton(DProperty object) {
        super(object, null, 32);
        this.font.setStorableBy(this.parentFont, false);
    }

    @Override
    public boolean isPropVisible(DProperty prop) {
        if (prop == this.imageSize) {
            return this.imageId.value != 0;
        }
        if (prop == this.font) {
            return !this.parentFont.value;
        }
        return true;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        boolean showCaptionReaded = false;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 3: {
                    this.imageSize.loadTaggedContent(in);
                }
                case 2: {
                    this.imageId.loadTaggedContent(in);
                    break;
                }
                case 4: {
                    this.caption.loadTaggedContent(in);
                    break;
                }
                case 5: {
                    this.hint.loadTaggedContent(in);
                    break;
                }
                case 19: {
                    this.action.loadTaggedContent(in);
                    break;
                }
                case 7: {
                    this.separator.loadTaggedContent(in);
                    break;
                }
                case 8: {
                    this.onClick.loadTaggedContent(in);
                    break;
                }
                case 11: {
                    this.showCaption.loadTaggedContent(in);
                    showCaptionReaded = true;
                    break;
                }
                case 9: {
                    this.visible.loadTaggedContent(in);
                    break;
                }
                case 24: {
                    this.keystroke.loadTaggedContent(in);
                    break;
                }
                case 154: {
                    this.accessRights.loadTaggedContent(in);
                    break;
                }
                case 20: {
                    this.scriptName.loadTaggedContent(in);
                    break;
                }
                case 21: {
                    this.enabled.loadTaggedContent(in);
                    break;
                }
                case 23: {
                    this.newToolBar.loadTaggedContent(in);
                    break;
                }
                case 28: {
                    this.autoSave.loadTaggedContent(in);
                    break;
                }
                case 30: {
                    this.editModeOnly.loadTaggedContent(in);
                    break;
                }
                case 31: {
                    this.font.loadTaggedContent(in);
                    this.parentFont.setValue(false);
                    break;
                }
                case 37: {
                    this.security.loadTaggedContent(in);
                    break;
                }
                case 10: {
                    if (!showCaptionReaded) {
                        this.showCaption.setValue(!this.caption.isEmpty() && this.imageId.value == 0);
                    }
                    return;
                }
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        out.putEmpty(1);
        this.accessRights.storeTaggedContentAs(154, out);
        if (this.imageId.value != 0) {
            this.imageSize.storeTaggedContentAs(3, out);
            this.imageId.storeTaggedContentAs(2, out);
        }
        this.caption.storeTaggedContentAs(4, out);
        this.hint.storeTaggedContentAs(5, out);
        this.action.storeTaggedContentAs(19, out);
        this.separator.storeTaggedContentAs(7, out);
        this.visible.storeTaggedContentAs(9, out);
        this.onClick.storeTaggedContentAs(8, out);
        this.showCaption.storeTaggedContentAs(11, out);
        this.scriptName.storeTaggedContentAs(20, out);
        this.keystroke.storeTaggedContentAs(24, out);
        this.enabled.storeTaggedContentAs(21, out);
        this.newToolBar.storeTaggedContentAs(23, out);
        this.autoSave.storeTaggedContentAs(28, out);
        this.editModeOnly.storeTaggedContentAs(30, out);
        this.font.storeTaggedContentAs(31, out);
        this.security.storeTaggedContentAs(37, out);
        out.putEmpty(10);
    }
}

