/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DDisplayExpression;
import inform.agent.mtd.obj.DFieldPath;
import inform.agent.mtd.obj.DFieldPathItem;
import inform.agent.mtd.obj.DNodeTypeFilter;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DParamAssocForm;
import inform.agent.mtd.obj.DParameters;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.DPropertyValues;
import java.io.IOException;
import java.util.ArrayList;

public class DParameter
extends DObject {
    protected final DParameters.Kind kind;
    protected final DPropertyInt id = new DPropertyInt(this, "id", 32768);
    protected final DPropertyString scriptName = new DPropertyString(this, "name", 0x200002);
    public final DPropertyEnum dataType = new DPropertyEnum(this, "dataType", 32768, 0, DATA_TYPE_VALUES, DATA_TYPE_NAMES);
    protected final DPropertyString caption = new DPropertyString(this, "caption", 0x200002);
    protected final DPropertyInt group = new DPropertyInt(this, "group", 32770);
    protected final DFieldPath association = new DFieldPath(this, "association", 2);
    protected final DPropertyInt associationActualPointParam = new DPropertyInt(this, "associationActualPointParam", 32770);
    protected final DFieldPath selectedField = new DFieldPath(this, "selectedField", 2);
    protected final DPropertyInt associateDatasource = new DPropertyInt(this, "associateDatasource", 32770);
    protected final DPropertyInt associateField = new DPropertyInt(this, "associateField", 32770);
    protected final DParamAssocForm assocForm = new DParamAssocForm(this, "form");
    protected final DPropertyBool returning = new DPropertyBool(this, "returning", 4098, false);
    protected final DNodeTypeFilter nodeTypes = new DNodeTypeFilter(this, "nodeTypes");
    protected final DPropertyEnum storeKind = new DPropertyEnum((DProperty)this, "storeKind", 32770, 0, PARAM_STORE_KIND);
    protected final DPropertyBool withFileDialog = new DPropertyBool(this, "withFileDialog", 4098, false);
    protected final DPropertyBool ignored = new DPropertyBool(this, "ignored", 4098, false);
    protected final DPropertyInt constant = new DPropertyInt(this, "constant", 32770);
    protected final DPropertyEnum dateFunction = new DPropertyEnum(this, "dateFunction", 32770, DATE_TIME_FUNCTION_NAMES);
    protected final DPropertyValues values = new DPropertyValues((DProperty)this, "values", this.dataType);
    protected final DPropertyInt param = new DPropertyInt(this, "param", 32770);
    protected final DPropertyEnum format = new DPropertyEnum(this, "format", 32770, 0, FORMAT_VALUES, FORMAT_NAMES);
    protected final DPropertyBool hidden = new DPropertyBool(this, "hidden", 4098, false);
    public final DPropertyBool singleValue = new DPropertyBool(this, "singleValue", 4098, false);
    protected final DPropertyBool notNull = new DPropertyBool(this, "notNull", 4098, false);
    protected final DDisplayExpression displayExpression = new DDisplayExpression(this, "displayExpression");
    protected final DPropertyString notes = new DPropertyString(this, "notes", 0x200002);
    protected final DPropertyString onChange = new DPropertyString(this, "onChange", 524290, "");
    protected final DPropertyString onBeforeChange = new DPropertyString(this, "onBeforeChange", 524290, "");

    public DParameter(DParameters object) {
        this(object, object.kind, object.parameterDsl);
    }

    public DParameter(DObject object, DParameters.Kind kind, String dsl) {
        super(object, null, 32);
        this.kind = kind;
        this.values.setStorableBy(this.ignored, false);
        this.dsl = dsl;
    }

    public String getComment() {
        if (!this.scriptName.isEmpty()) {
            return this.caption.value + " [" + this.scriptName.value + "]";
        }
        return this.caption.value;
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        DFieldPathItem fpi;
        if (this.ignored.value) {
            this.dateFunction.value = 0;
            this.constant.value = 0;
            this.values.properties.clear();
            this.param.value = 0;
            this.associateDatasource.value = 0;
            this.associateField.value = 0;
        } else if (this.associateDatasource.value != 0) {
            this.dateFunction.value = 0;
            this.constant.value = 0;
            this.values.properties.clear();
            this.param.value = 0;
        } else if (this.param.value != 0) {
            this.dateFunction.value = 0;
            this.constant.value = 0;
            this.values.properties.clear();
            this.associateDatasource.value = 0;
            this.associateField.value = 0;
        } else if (this.dateFunction.value != 0) {
            this.constant.value = 0;
            this.values.properties.clear();
            this.param.value = 0;
            this.associateDatasource.value = 0;
            this.associateField.value = 0;
        } else if (this.constant.value != 0) {
            this.dateFunction.value = 0;
            this.values.properties.clear();
            this.param.value = 0;
            this.associateDatasource.value = 0;
            this.associateField.value = 0;
        }
        int offset = 0;
        byte[] raw = new byte[8];
        LittleEndian.setInteger(this.id.value, raw, offset);
        LittleEndian.setInteger(this.dataType.value, raw, offset += 4);
        out.putRaw(1, raw);
        this.scriptName.storeTaggedContentAs(16, out);
        this.caption.storeTaggedContentAs(2, out);
        if (this.kind == DParameters.Kind.Server) {
            this.returning.storeTaggedContentAs(37, out);
        }
        this.format.storeTaggedContentAs(3, out);
        for (DProperty p : this.association.properties) {
            if (!(p instanceof DFieldPathItem)) continue;
            fpi = (DFieldPathItem)p;
            if (fpi.field.value == 0) continue;
            out.putEmpty(19);
            fpi.table.storeTaggedContentAs(151, out);
            fpi.field.storeTaggedContentAs(18, out);
        }
        for (DProperty p : this.selectedField.properties) {
            if (!(p instanceof DFieldPathItem)) continue;
            fpi = (DFieldPathItem)p;
            if (fpi.field.value == 0) continue;
            fpi.table.storeTaggedContentAs(31, out);
            fpi.table.storeTaggedContentAs(151, out);
            fpi.field.storeTaggedContentAs(30, out);
        }
        this.displayExpression.storeTaggedContentAs(41, out);
        if (!this.association.properties.isEmpty()) {
            this.associationActualPointParam.storeTaggedContentAs(36, out);
        }
        this.hidden.storeTaggedContentAs(6, out);
        this.notNull.storeTaggedContentAs(22, out);
        this.singleValue.storeTaggedContentAs(23, out);
        this.ignored.storeTaggedContentAs(7, out);
        this.group.storeTaggedContentAs(8, out);
        if (this.dateFunction.value != 0) {
            this.dateFunction.storeTaggedContentAs(9, out);
        } else if (this.constant.value != 0) {
            this.constant.storeTaggedContentAs(17, out);
        } else if (this.param.value != 0) {
            this.param.storeTaggedContentAs(21, out);
        } else if (this.values.value.size() > 1) {
            if (this.singleValue.value) {
                this.storeTaggedValue(out, 0);
            } else {
                out.putInt32(15, this.values.value.size());
                int count = this.values.value.size();
                for (int index = 0; index < count; ++index) {
                    this.storeTaggedValue(out, index);
                }
            }
        } else {
            this.storeTaggedValue(out, 0);
        }
        if (this.assocForm.node.value != 0.0) {
            this.assocForm.node.storeTaggedContentAs(25, out);
            this.assocForm.node.storeTaggedContentAs(151, out);
            this.assocForm.parameters.storeTaggedContentAsNonEmptyStream(26, out);
            this.assocForm.datasource.storeTaggedContentAs(27, out);
            this.assocForm.field.storeTaggedContentAs(28, out);
            this.assocForm.control.storeTaggedContentAs(29, out);
        }
        this.associateDatasource.storeTaggedContentAs(32, out);
        this.associateField.storeTaggedContentAs(33, out);
        if (this.dataType.value == 10) {
            for (DProperty p : this.nodeTypes.properties) {
                p.storeTaggedContentAs(34, out);
            }
        }
        if (this.storeKind.value == 1) {
            out.putEmpty(39);
        }
        this.storeKind.storeTaggedContentAs(42, out);
        this.withFileDialog.storeTaggedContentAs(40, out);
        this.notes.storeTaggedContentAs(43, out);
    }

    protected void storeTaggedValue(TaggedWriter out, int index) throws IOException {
        DParameter.storeTaggedValue(out, this.values.value, index, this.dataType.value);
    }

    public static void storeTaggedValue(TaggedWriter out, ArrayList<Object> values, int index, int dataType) throws IOException {
        if (values.isEmpty()) {
            out.putEmpty(14);
            return;
        }
        Object v = values.get(index);
        if (v == null) {
            out.putEmpty(14);
            return;
        }
        switch (dataType) {
            case 8: 
            case 9: {
                if (v instanceof byte[]) {
                    out.putRaw(38, (byte[])v);
                    break;
                }
                out.putRaw(38, ValueCaster.toBytes(v));
                break;
            }
            case 1: {
                out.putInt32(10, ValueCaster.toInt(v));
                break;
            }
            case -1: 
            case 2: 
            case 5: 
            case 10: {
                out.putDouble(11, ValueCaster.toDouble(v));
                break;
            }
            case 3: {
                out.putString(12, ValueCaster.toString(v));
                break;
            }
            case 4: {
                out.putDouble(13, ValueCaster.toDouble(v));
                break;
            }
            case 7: {
                out.putInt32(10, ValueCaster.toBoolean(v) != false ? 1 : 0);
                break;
            }
            case 6: {
                out.putDouble(11, ValueCaster.toDouble(v));
            }
        }
    }
}

