/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyACLEntry;
import java.io.IOException;

public class DPropertyACL
extends DObject {
    public DPropertyACL(DProperty object, String name) {
        super(object, name, 16);
    }

    @Override
    public boolean isDefault() {
        return this.checkPropOptions(2) && this.properties.isEmpty();
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        byte[] content = in.getRaw();
        int count = content.length / 16 * 16;
        for (int index = 0; index < count; index += 4) {
            DPropertyACLEntry entry = new DPropertyACLEntry(this);
            entry.user.value = LittleEndian.getDouble(content, index);
            entry.allowed.value = LittleEndian.getInt(content, index += 8);
            entry.denied.value = LittleEndian.getInt(content, index += 4);
        }
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        if (!this.isStorable() || this.isDefault()) {
            return;
        }
        byte[] content = new byte[16 * this.properties.size()];
        int offset = 0;
        for (DProperty p : this.properties) {
            if (!(p instanceof DPropertyACLEntry)) continue;
            DPropertyACLEntry entry = (DPropertyACLEntry)p;
            LittleEndian.setDouble(entry.user.value, content, offset);
            LittleEndian.setInteger(entry.allowed.value, content, offset += 8);
            LittleEndian.setInteger(entry.denied.value, content, offset += 4);
            offset += 4;
        }
        out.putRaw(tag, content);
    }
}

