/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyComponent;
import inform.agent.mtd.obj.DPropertyInt;
import java.io.IOException;

public class DPropertyAction
extends DObject {
    protected NS namespace = NS.none;
    protected final DPropertyComponent component = new DPropertyComponent(this, "component");
    protected final DPropertyInt actionId = new DPropertyInt(this, "actionId", 32768);

    public DPropertyAction(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public boolean isDefault() {
        return this.checkPropOptions(2) && this.component.value == 0;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        byte[] content = in.getRaw();
        int offset = 0;
        this.component.setValue(LittleEndian.getInt(content, offset));
        this.namespace = NS.get(content[offset += 4]);
        this.actionId.setValue(content[++offset]);
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        if (!this.isStorable() || this.isDefault()) {
            return;
        }
        int offset = 0;
        byte[] raw = new byte[6];
        LittleEndian.setInteger(this.component.value, raw, offset);
        offset += 4;
        raw[offset++] = (byte)this.namespace.value;
        raw[offset] = (byte)this.actionId.value;
        out.putRaw(tag, raw);
    }

    protected static enum NS {
        none(0),
        common(1),
        components(2),
        datamodel(3);

        private final int value;

        private NS(int value) {
            this.value = value;
        }

        public int toInt() {
            return this.value;
        }

        public static NS get(int value) {
            for (NS t : NS.values()) {
                if (t.toInt() != value) continue;
                return t;
            }
            return none;
        }
    }
}

