/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.mtd.obj.DParameter;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.search.DSearch;
import inform.agent.mtd.obj.search.DSearchEntry;
import inform.agent.mtd.obj.search.DSearchEntryContainer;

public class DPropertySearchField
extends DPropertyInt {
    protected final Kind kind;
    protected final DSearchEntry entry;
    protected final DPropertyInt entryId;

    public DPropertySearchField(DProperty object, String name, int propOption, DPropertyInt entryId) {
        super(object, name, 0x8000 | propOption);
        this.kind = Kind.Generic;
        this.entry = null;
        this.entryId = entryId;
    }

    public DPropertySearchField(DProperty object, String name, int propOption, DSearchEntry entry) {
        super(object, name, 0x8000 | propOption);
        this.kind = Kind.Generic;
        this.entry = entry;
        this.entryId = null;
    }

    public DPropertySearchField(DProperty object, String name, int propOption, Kind kind) {
        super(object, name, 0x8000 | propOption);
        this.kind = kind;
        this.entry = null;
        this.entryId = null;
    }

    @Override
    protected String getComment() {
        if (this.value != 0) {
            FieldDescriptor field;
            TableDescriptor table;
            DParameter parameter;
            double tableId = 0.0;
            if (this.entry != null) {
                tableId = this.entry.tableId;
            } else if (this.entryId != null) {
                DSearchEntry entry;
                DSearchEntryContainer container = DSearch.findEntryContainer(this);
                if (container != null && (entry = container.findEntry(this.entryId.getValue())) != null) {
                    tableId = entry.tableId;
                }
            } else if (this.kind == Kind.Parameter && (parameter = DSearch.findSearchParameter(this, this.value)) != null) {
                return parameter.getComment();
            }
            if (tableId != 0.0 && (table = TableDescriptor.getIfExists(tableId)) != null && (field = table.getFieldDescriptor(this.value)) != null) {
                String n = field.getIdent();
                if (!Strings.isVoid(n)) {
                    return field.getCaption() + " [" + n + "]";
                }
                return field.getCaption();
            }
            return "???";
        }
        return null;
    }

    public static enum Kind {
        Generic,
        Field,
        Parameter;

    }
}

