/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DParameter;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyValue;
import inform.agent.mtd.obj.search.DSearch;
import inform.agent.mtd.obj.search.DSearchConditionOperand;
import inform.agent.mtd.obj.search.DSearchEntry;
import inform.agent.mtd.obj.search.DSearchEntryContainer;
import inform.agent.mtd.obj.search.DSearchFieldExpression;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public class DSearchConditionItem
extends DObject {
    protected DataType dataType = null;
    protected final DPropertyInt braceCount = new DPropertyInt(this, "braceCount", 32770);
    protected final DPropertyEnum operator = new DPropertyEnum(this, "operator", 0x808002, DSearch.LOGICAL_OPERATOR_NAMES);
    protected final DSearchConditionOperand left = new DSearchConditionOperand(this, "left");
    protected final DPropertyEnum compare = new DPropertyEnum(this, "compare", 0x808002, DSearch.COMPARE_OPERATOR_NAMES);
    protected final DSearchConditionOperand right = new DSearchConditionOperand(this, "right");
    protected final DSearchFieldExpression rightExpression = new DSearchFieldExpression(this, "rightExpression");
    protected final DPropertyEnum modificator = new DPropertyEnum(this, "modificator", 32778, DSearch.DATE_MODIFICATOR_NAMES);

    public DSearchConditionItem(DProperty object) {
        super(object, null, 288);
    }

    protected void updateDataType() {
        if (this.dataType == null) {
            if (!this.left.parameter.isDefault()) {
                DParameter parameter = DSearch.findSearchParameter(this, this.left.parameter.getValue());
                this.dataType = parameter != null ? DataType.getDataTypeById(parameter.dataType.getValue()) : DataType.NONE;
            } else if (!this.left.entry.isDefault() && !this.left.field.isDefault()) {
                TableDescriptor table;
                DSearchEntry entry;
                FieldDescriptor field = null;
                double tableId = 0.0;
                DSearchEntryContainer container = DSearch.findEntryContainer(this);
                if (container != null && (entry = container.findEntry(this.left.entry.getValue())) != null) {
                    tableId = entry.tableId;
                }
                if (tableId != 0.0 && (table = TableDescriptor.getIfExists(tableId)) != null) {
                    field = table.getFieldDescriptor(this.left.field.getValue());
                }
                this.dataType = field != null ? field.getType() : DataType.NONE;
            } else {
                this.dataType = DataType.NONE;
            }
            switch (this.dataType) {
                case BOOLEAN: {
                    this.modificator.setMaps(DSearch.BOOL_MODIFICATOR_NAMES);
                    this.modificator.setStorable(true);
                    break;
                }
                case DATE_TIME: {
                    this.modificator.setMaps(DSearch.DATE_MODIFICATOR_NAMES);
                    this.modificator.setStorable(true);
                    break;
                }
                case STRING: 
                case UNICODE: {
                    this.modificator.setMaps(DSearch.STRING_MODIFICATOR_NAMES);
                    this.modificator.setStorable(true);
                    break;
                }
                default: {
                    this.modificator.setStorable(false);
                }
            }
        }
    }

    public DSearchConditionOperand getOperandToLoad() {
        if (this.left.checkPropOptions(8)) {
            this.left.setStorable(true);
            return this.left;
        }
        this.right.setStorable(true);
        return this.right;
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        this.updateDataType();
        byte[] raw = new byte[12];
        LittleEndian.setInteger(this.braceCount.getValue(), raw, 0);
        LittleEndian.setInteger(this.compare.getValue(), raw, 4);
        LittleEndian.setInteger(this.operator.getValue(), raw, 8);
        out.putRaw(1, raw);
        raw = new byte[8];
        if (!this.left.parameter.isDefault()) {
            LittleEndian.setInteger(-1, raw, 0);
            LittleEndian.setInteger(this.left.parameter.getValue(), raw, 4);
        } else {
            LittleEndian.setInteger(this.left.entry.getValue(), raw, 0);
            LittleEndian.setInteger(this.left.field.getValue(), raw, 4);
        }
        if (this.left.prior.getValue()) {
            out.putRaw(10, raw);
        } else {
            out.putRaw(2, raw);
        }
        this.modificator.storeTaggedContentAs(12, out);
        if (!this.rightExpression.isDefault()) {
            this.rightExpression.storeTaggedContentAsStream(11, out);
        } else {
            if (!this.right.parameter.isDefault()) {
                this.right.entry.setValue(0);
                this.right.field.setValue(0);
            }
            if (this.right.entry.getValue() == -1) {
                this.right.parameter.setValue(this.right.field.getValue());
                this.right.entry.setValue(0);
                this.right.field.setValue(0);
            }
            if (!this.right.entry.isDefault()) {
                LittleEndian.setInteger(this.right.entry.getValue(), raw, 0);
                LittleEndian.setInteger(this.right.field.getValue(), raw, 4);
                if (this.right.prior.getValue()) {
                    out.putRaw(10, raw);
                } else {
                    out.putRaw(2, raw);
                }
                this.right.function.storeTaggedContentAs(13, out);
            } else if (!this.right.parameter.isDefault()) {
                this.right.parameter.storeTaggedContentAs(8, out);
            } else if (!(this.right.value.isStorable() || this.right.valueBool.isStorable() || this.right.valueInt.isStorable() || this.right.valueDouble.isStorable() || this.right.valueDateTime.isStorable() || this.right.valueString.isStorable())) {
                out.putEmpty(7);
            } else if (this.right.value.isStorable()) {
                if (this.right.value.getType() == DPropertyValue.Type.Null) {
                    out.putEmpty(7);
                } else {
                    this.right.value.storeTaggedContentAs(5, out);
                }
            } else if (this.right.valueBool.isStorable()) {
                out.putInt32(3, this.right.valueBool.getValue() ? 1 : 0);
            } else if (this.right.valueInt.isStorable()) {
                this.right.valueInt.storeTaggedContentAs(3, out);
            } else if (this.right.valueDouble.isStorable()) {
                this.right.valueDouble.storeTaggedContentAs(4, out);
            } else if (this.right.valueDateTime.isStorable()) {
                this.right.valueDateTime.storeTaggedContentAs(6, out);
            } else if (this.right.valueString.isStorable()) {
                this.right.valueString.storeTaggedContentAs(5, out);
            }
        }
    }

    @Override
    public void loadScriptContent(ScriptableObject source) {
        super.loadScriptContent(source);
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        this.updateDataType();
        return super.storeTextContent(textOptions, out, level, needComma);
    }
}

