/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.TableDescriptor;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.sql.engine.Function;
import inform.agent.db.types.DataType;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.search.DSearch;
import inform.agent.mtd.obj.search.DSearchFieldExprItem;
import inform.agent.mtd.obj.search.DSearchRoot;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public class DSearchFieldExpression
extends DArray {
    public DSearchFieldExpression(DProperty object, String name) {
        super(object, name, 2);
    }

    public void load(TaggedReader in, DataType dataType) throws IOException {
        DSearchFieldExprItem item = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 7: {
                    item = new DSearchFieldExprItem(this);
                    this.properties.add(item);
                    item.kind.loadTaggedContent(in);
                    break;
                }
                case 3: {
                    if (item == null) break;
                    item.braceCount.loadTaggedContent(in);
                    break;
                }
                case 4: {
                    if (item == null) break;
                    item.entry.loadTaggedContent(in);
                    break;
                }
                case 5: {
                    if (item == null) break;
                    item.field.loadTaggedContent(in);
                    break;
                }
                case 6: {
                    if (item == null || item.kind.getValue() != FieldExpression.Kind.Function.toInt()) break;
                    item.function.loadTaggedContent(in);
                    if (item.function.getValue() != Function.RoundTo.toInt() && item.function.getValue() != Function.Trunc.toInt()) break;
                    item.scale.setScriptable(true);
                    break;
                }
                case 16: {
                    if (item == null) break;
                    item.parameter.loadTaggedContent(in);
                    break;
                }
                case 15: {
                    if (item == null) break;
                    item.scale.loadTaggedContent(in);
                    item.scale.setStorable(true);
                    break;
                }
                case 10: {
                    if (item == null) break;
                    if (dataType == DataType.BOOLEAN) {
                        item.valueBool.setValue(in.getInt() != 0);
                        item.valueBool.setStorable(true);
                        break;
                    }
                    item.valueInt.loadTaggedContent(in);
                    item.valueInt.setStorable(true);
                    break;
                }
                case 11: {
                    if (item == null) break;
                    item.valueDouble.loadTaggedContent(in);
                    item.valueDouble.setStorable(true);
                    break;
                }
                case 13: {
                    if (item == null) break;
                    item.valueDateTime.loadTaggedContent(in);
                    item.valueDateTime.setStorable(true);
                    break;
                }
                case 12: {
                    if (item == null) break;
                    if (item.dataType.getValue() == 0) {
                        item.value.loadTaggedContent(in);
                        item.value.setStorable(true);
                        break;
                    }
                    item.valueString.loadTaggedContent(in);
                    item.valueString.setStorable(true);
                    break;
                }
                case 17: {
                    if (item == null) break;
                    item.typeCast.loadTaggedContent(in);
                    break;
                }
                case 18: {
                    if (item == null) break;
                    item.dataType.loadTaggedContent(in);
                }
            }
        }
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DSearchFieldExprItem item = new DSearchFieldExprItem(this.object);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    public void loadScriptContent(ScriptableObject obj) {
        super.loadScriptContent(obj);
        DSearch search = ((DSearchRoot)this.object.object.object).search;
        TableDescriptor table = search.getRootTableDescriptor();
    }

    @Override
    protected void doAssign(DItem source) {
        if (DSearchFieldExpression.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DSearchFieldExpression)source).properties) {
                if (!(sourceProperty instanceof DSearchFieldExprItem)) continue;
                DSearchFieldExprItem sourceItem = (DSearchFieldExprItem)sourceProperty;
                DSearchFieldExprItem item = new DSearchFieldExprItem(this.object);
                item.assign(sourceItem);
                this.properties.add(item);
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        for (DProperty p : this.properties) {
            if (!(p instanceof DSearchFieldExprItem)) continue;
            p.storeTaggedContent(out);
        }
    }
}

