/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.TableDescriptor;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.sql.engine.Function;
import inform.agent.db.types.DataType;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.search.DSearch;
import inform.agent.mtd.obj.search.DSearchFieldExprItem;
import inform.agent.mtd.obj.search.DSearchRoot;
import inform.agent.mtd.obj.search.DSearchRootField;
import java.io.IOException;

public class DSearchRootFields
extends DArray {
    public DSearchRootFields(DSearchRoot root, String name) {
        this(root, name, 0);
    }

    public DSearchRootFields(DSearchRoot root, String name, int propOptions) {
        super(root, name, propOptions);
    }

    public DSearchRootField find(int fieldId) {
        for (DProperty property : this.properties) {
            if (!(property instanceof DSearchRootField)) continue;
            DSearchRootField field = (DSearchRootField)property;
            if (field.fieldId.getValue() != fieldId) continue;
            return field;
        }
        return null;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        DSearch search = ((DSearchRoot)this.object).search;
        TableDescriptor table = search.getRootTableDescriptor();
        DSearchRootField field = null;
        DSearchFieldExprItem item = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    field = new DSearchRootField(this);
                    field.fieldId.loadTaggedContent(in);
                    field.tableId.setValue(search.getRootTableId());
                    this.add(field);
                    break;
                }
                case 2: {
                    if (field == null) break;
                    field.aggregativeFunction.loadTaggedContent(in);
                    break;
                }
                case 7: {
                    if (field == null) break;
                    item = new DSearchFieldExprItem(field);
                    field.expression.add(item);
                    item.kind.loadTaggedContent(in);
                    break;
                }
                case 3: {
                    if (field == null) break;
                    if (item == null) {
                        item = new DSearchFieldExprItem(field);
                        item.kind.setValue(FieldExpression.Kind.Field.toInt());
                        field.expression.add(item);
                    }
                    item.braceCount.loadTaggedContent(in);
                    break;
                }
                case 4: {
                    if (item == null) break;
                    item.entry.loadTaggedContent(in);
                    break;
                }
                case 5: {
                    if (item == null) break;
                    item.field.loadTaggedContent(in);
                    break;
                }
                case 6: {
                    if (item == null || item.kind.getValue() != FieldExpression.Kind.Function.toInt()) break;
                    item.function.loadTaggedContent(in);
                    if (item.function.getValue() != Function.RoundTo.toInt() && item.function.getValue() != Function.Trunc.toInt()) break;
                    item.scale.setScriptable(true);
                    break;
                }
                case 10: 
                case 14: {
                    if (item == null) break;
                    if (item.dataType.getValue() == DataType.BOOLEAN.toInt()) {
                        item.valueBool.setValue(in.getInt() != 0);
                        item.valueBool.setStorable(true);
                        break;
                    }
                    item.valueInt.loadTaggedContent(in);
                    item.valueInt.setStorable(true);
                    break;
                }
                case 11: {
                    if (item == null) break;
                    item.valueDouble.loadTaggedContent(in);
                    item.valueDouble.setStorable(true);
                    break;
                }
                case 13: {
                    if (item == null) break;
                    item.valueDateTime.loadTaggedContent(in);
                    item.valueDateTime.setStorable(true);
                    break;
                }
                case 12: {
                    if (item == null) break;
                    if (item.dataType.getValue() == 0) {
                        item.value.loadTaggedContent(in);
                        item.value.setStorable(true);
                        break;
                    }
                    item.valueString.loadTaggedContent(in);
                    item.valueString.setStorable(true);
                    break;
                }
                case 15: {
                    if (item == null) break;
                    item.scale.loadTaggedContent(in);
                    item.scale.setStorable(true);
                    break;
                }
                case 16: {
                    if (item == null) break;
                    item.parameter.loadTaggedContent(in);
                    break;
                }
                case 17: {
                    if (item == null) break;
                    item.typeCast.loadTaggedContent(in);
                    break;
                }
                case 18: {
                    if (item == null) break;
                    item.dataType.loadTaggedContent(in);
                }
            }
        }
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DSearchRootField field = new DSearchRootField(this);
        field.loadScriptValue(obj);
        return field;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DSearchRootFields.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DSearchRootFields)source).properties) {
                if (!(sourceProperty instanceof DSearchRootField)) continue;
                DSearchRootField sourceField = (DSearchRootField)sourceProperty;
                DSearchRootField field = new DSearchRootField(this);
                field.assign(sourceField);
                this.properties.add(field);
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        for (DProperty p : this.properties) {
            if (!(p instanceof DSearchRootField)) continue;
            p.storeTaggedContent(out);
        }
    }
}

