/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActiveDirectory;
import inform.agent.LogContext;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.Security;
import inform.agent.mtd.nodes.UserNode;

public class CheckAuthentication
extends Request {
    private UserNode userNode = null;
    private ActiveDirectory activeDirectory = null;
    private byte[] disposibleKey;
    private byte[] salt;

    public CheckAuthentication(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        LogContext.Builder blockCause;
        TaggedReader in = this.createRequestContentReader();
        String userName = "";
        String domain = "";
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 20: {
                    userName = in.getAnsi();
                    break;
                }
                case 41: {
                    domain = in.getAnsi();
                }
            }
        }
        this.userNode = MtdEngine.getUserNodeByName(userName);
        if (this.userNode == null) {
            throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
        }
        boolean activeDirectoryAuthorization = this.userNode.isActiveDirectoryAuthorization();
        if (activeDirectoryAuthorization) {
            this.userNode = MtdEngine.getAcitiveDirectoryUserNodes(userName);
        }
        if (this.userNode.isAccountBlocked(blockCause = new LogContext.Builder())) {
            throw new InformException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d");
        }
        ByteArrayOutputStream chunk = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(chunk);
        if (activeDirectoryAuthorization) {
            throw new InformException("\u0410\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f AD \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }
        if (this.userNode.isSha256()) {
            this.disposibleKey = Security.sha256GenerateSalt();
            this.salt = this.userNode.getSha256Salt();
        } else {
            this.disposibleKey = Security.generateSalt();
            this.salt = this.userNode.getSecuritySalt();
        }
        out.putRaw(22, this.salt);
        out.putRaw(24, this.disposibleKey);
        out.flush();
        this.sendChunk(chunk.internalBuffer(), chunk.size());
        this.setChunkedInput();
        this.processChunkedInput();
        chunk.reset();
        out.reset(chunk);
        out.putInt32(38, this.userNode.getRole().toInt());
        out.flush();
        this.sendResult(null, 0, chunk.internalBuffer(), chunk.size());
    }

    @Override
    protected void processInputChunk(byte[] chunk) throws Exception {
        if (chunk == null || chunk.length == 0) {
            return;
        }
        TaggedReader in = new TaggedReader(chunk);
        if (this.activeDirectory == null) {
            byte[] calcHash;
            if (in.next() && in.getCurrentTagSize() == 32) {
                in.checkCurrentTag(21, 32);
            } else {
                in.checkCurrentTag(21, 16);
            }
            byte[] clientHash = in.getRaw();
            if (this.userNode.isSha256()) {
                byte[] userHash = this.userNode.getSha256Hash();
                calcHash = Security.sha256CalculateH2(userHash, this.disposibleKey);
            } else {
                byte[] userHash = this.userNode.getSecurityHash();
                calcHash = Security.calculateH2(userHash, this.disposibleKey);
            }
            if (!Security.isHashEquals(calcHash, clientHash)) {
                throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
            }
            this.endInputChunk();
        } else {
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 47: {
                        throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                    }
                    case 45: {
                        byte[] data = in.getRaw();
                        data = this.activeDirectory.process(data);
                        if (data.length == 0) break;
                        ByteArrayOutputStream res = new ByteArrayOutputStream();
                        TaggedWriter out = new TaggedWriter(res);
                        out.putRaw(45, data);
                        out.flush();
                        this.sendChunk(res.internalBuffer(), res.size());
                    }
                }
            }
        }
    }
}

