/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Security;
import java.util.BitSet;

public class GetNodeChildsByUserAndPerms
extends Request {
    private static final int TAG_USER_ID = 1;
    private static final int TAG_TYPE_SET = 2;
    private static final int TAG_PERMISSIONS = 3;

    public GetNodeChildsByUserAndPerms(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        Node node;
        double nodeId = this.getTranslatedNodeID();
        if (this.getNodeID() == 0.0) {
            node = MtdEngine.getNode(nodeId);
            if (node == null) {
                throw new InformException("\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
        } else {
            node = MtdEngine.getValidNode(nodeId);
        }
        BitSet nodeTypeFilter = null;
        int permissions = 0;
        Security sec = this.security();
        TaggedReader in = this.createRequestContentReader();
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 2: {
                    int[] types;
                    nodeTypeFilter = new BitSet();
                    for (int typeId : types = LittleEndian.toIntArray(in.getRaw())) {
                        nodeTypeFilter.set(typeId);
                    }
                    if (!nodeTypeFilter.isEmpty()) break;
                    nodeTypeFilter = null;
                    break;
                }
                case 1: {
                    sec = new Security(in.getDouble());
                    break;
                }
                case 3: {
                    permissions = in.getInt();
                }
            }
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("rq:GetNodeChildsByUserAndPerms");){
            double[] children;
            Node.NodeInfoArg arg = new Node.NodeInfoArg(connection, sec, nodeTypeFilter, out);
            for (double childId : children = node.getChildrenByFilters(connection, nodeTypeFilter, permissions, sec)) {
                Node childNode = MtdEngine.getNode(childId);
                if (childNode == null) continue;
                node.getChildInfo(childNode, arg);
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

