/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.obj.DslRuntime;
import inform.common.Empty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.Adler32;

public class GetNodeContent
extends Request {
    public static final int TAG_RESULT_INFO_REAL_NODE_ID = 1;
    public static final int TAG_RESULT_INFO_NODE_TYPE = 2;
    public static final int TAG_RESULT_INFO_LAST_CONTENT_STAMP = 3;
    public static final int TAG_RESULT_INFO_CONTENT_KIND = 4;
    public static final int TAG_GNC_ADLER32 = 1;
    public static final int TAG_GNC_CONTENT = 2;
    public static final int TAG_GNC_TARNSLATE = 3;
    public static final int TAG_GNC_CONTENT_SIZE = 4;
    public static final int TAG_GNC_CONTENT_UNCHANGED = 5;
    public static final int TAG_GNC_USER_CONF = 6;
    public static final int TAG_GNC_CONTENT_TYPE = 7;
    public static final int TAG_GNC_DSL_CONTENT = 8;
    public static final int TAG_NHISTORY_ENTRY_ID = 4;
    private Type contentType;
    private boolean ifModified;

    public GetNodeContent(RequestHeader rq, Type contentType, boolean ifModified) {
        super(rq, RequestDuration.NORMAL);
        this.contentType = contentType;
        this.ifModified = ifModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        int nodeType;
        double nodeId;
        long clientAdler32 = 0L;
        int clientSize = 0;
        double pinId = -1.0;
        String dslContent = null;
        TaggedReader in = this.createRequestContentReader();
        if (this.ifModified) {
            while (in.getNextTag() != 0) {
                switch (in.getCurrentTag()) {
                    case 1: {
                        clientAdler32 = (long)in.getInt() & 0xFFFFFFFFL;
                        break;
                    }
                    case 3: {
                        this.contentType = Type.Translated;
                        break;
                    }
                    case 7: {
                        this.contentType = Type.get(in.getInt());
                        break;
                    }
                    case 4: {
                        clientSize = in.getInt();
                        break;
                    }
                    case 6: {
                        this.contentType = Type.Config;
                        break;
                    }
                    case 8: {
                        dslContent = in.getString();
                    }
                }
            }
        } else {
            while (in.getNextTag() != 0) {
                switch (in.getCurrentTag()) {
                    case 4: {
                        pinId = in.getDouble();
                        break;
                    }
                    case 6: {
                        this.contentType = Type.Config;
                        break;
                    }
                    case 8: {
                        dslContent = in.getString();
                    }
                }
            }
        }
        double requestedNodeId = this.getTranslatedNodeID();
        byte[] content = Empty.byteArray;
        Kind contentKind = Kind.Binary;
        ByteArrayOutputStream info = new ByteArrayOutputStream();
        TaggedWriter infoWriter = new TaggedWriter(info);
        if (this.contentType == Type.Config) {
            nodeId = this.getNodeID();
            nodeType = 16;
            try (Connector.Metabase connector = new Connector.Metabase();){
                connector.markAsReadonly();
                MetadataNodeReader.ConfNode conf = new MetadataNodeReader.ConfNode(this.getNodeID(), connector.connection());
                content = conf.content;
                connector.commit();
            }
        } else {
            BasicNode node = MtdEngine.getValidNode(requestedNodeId).getRealNode();
            this.checkAccess(node, this.contentType == Type.Translated ? 0x8000000 : Integer.MIN_VALUE);
            if (node.getType() != 0) {
                long contentStamp;
                if (dslContent == null) {
                    BasicNode.NodeContent nodeContent = pinId < 0.0 ? node.getNodeContent(0.0, true) : node.getNodeContent(pinId, false);
                    content = nodeContent.content;
                    dslContent = nodeContent.dslContent;
                    contentStamp = nodeContent.lastContentTime;
                } else {
                    contentStamp = 0L;
                }
                if (dslContent != null) {
                    switch (this.contentType) {
                        case Binary: 
                        case Config: {
                            MtdEngine.throwDetailError("\u0423\u0437\u0435\u043b \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0435\u043d\u0442", requestedNodeId);
                            break;
                        }
                        case Translated: 
                        case Runtime: {
                            content = DslRuntime.getContent(null, null, this, node, dslContent);
                            break;
                        }
                        case Design: {
                            contentKind = Kind.Text;
                            content = dslContent.getBytes(TaggedWriter.UTF8);
                        }
                    }
                }
                infoWriter.putInt64(3, contentStamp);
            }
            if (this.contentType == Type.Translated) {
                content = GetNodeContent.translateContent(this, content, true);
            }
            nodeId = node.getId();
            nodeType = node.getType();
        }
        infoWriter.putInt32(4, contentKind.toInt());
        byte[] result = null;
        int resultLength = 0;
        if (pinId >= 0.0) {
            if (nodeId != requestedNodeId) {
                infoWriter.putDouble(1, nodeId);
            }
            infoWriter.putInt32(2, nodeType);
        }
        if (this.ifModified) {
            boolean modified;
            boolean bl = modified = content.length != clientSize;
            if (!modified) {
                Adler32 crc = new Adler32();
                crc.update(content, 0, content.length);
                modified = clientAdler32 != crc.getValue();
            }
            ByteArrayOutputStream _content = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(_content);
            if (modified) {
                writer.putRaw(2, content);
            } else {
                writer.putEmpty(5);
            }
            writer.flush();
            result = _content.internalBuffer();
            resultLength = _content.size();
        } else {
            result = content;
            resultLength = content.length;
        }
        infoWriter.flush();
        this.sendResult(result, resultLength, info.internalBuffer(), info.size());
    }

    static byte[] translateContent(Request request, byte[] content, boolean checkMtdSignature) throws IOException, InformException, InterruptedException {
        if (content.length == 0) {
            return content;
        }
        if (checkMtdSignature && !TaggedReader.containsTag(150, content)) {
            return content;
        }
        TaggedReader reader = new TaggedReader(new ByteArrayInputStream(content), content.length);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        block4: while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 202: {
                    writer.putRaw(202, GetNodeContent.translateContent(request, reader.getRaw(), false));
                    continue block4;
                }
                case 154: {
                    writer.putInt32(156, GetNodeContent.translateAcl(request, reader.getRaw()));
                    continue block4;
                }
            }
            writer.putRaw(reader.getCurrentTag(), reader.getRaw());
        }
        writer.flush();
        return result.toByteArray();
    }

    static int translateAcl(Request request, byte[] aclData) throws IOException, InformException, InterruptedException {
        Acl acl = new Acl();
        acl.load(aclData);
        return request.security().accessMask(acl);
    }

    public static enum Type {
        Binary(0),
        Translated(1),
        Config(2),
        Runtime(3),
        Design(4);

        private final int value;

        public int toInt() {
            return this.value;
        }

        public static Type get(int value) {
            for (Type t : Type.values()) {
                if (t.toInt() != value) continue;
                return t;
            }
            throw new InformException("\u041d\u0435 \u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f (" + value + ") \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430 \u0443\u0437\u043b\u0430");
        }

        private Type(int value) {
            this.value = value;
        }
    }

    public static enum Kind {
        Binary(0),
        Text(1);

        private final int value;

        public int toInt() {
            return this.value;
        }

        public static Kind get(int value) {
            for (Kind t : Kind.values()) {
                if (t.toInt() != value) continue;
                return t;
            }
            throw new InformException("\u041d\u0435 \u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0432\u0438\u0434 (" + value + ") \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430 \u0443\u0437\u043b\u0430");
        }

        private Kind(int value) {
            this.value = value;
        }
    }
}

