/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.SymLinkNodeCache;
import inform.agent.mtd.nodes.VirtualUser;
import java.io.IOException;
import java.util.Arrays;

public class GetNodeInfo
extends Request {
    public GetNodeInfo(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    private int parseOptions() throws IOException, TaggedReaderException {
        TaggedReader in = this.createRequestContentReader();
        while (in.getNextTag() != 0) {
            if (in.getCurrentTag() != 22) continue;
            return in.getInt();
        }
        return 0;
    }

    public static double[] getSymlinkPath(double rootNodeId, double[] path, int level) throws InformException {
        if (level-- < 0) {
            return null;
        }
        SymLinkNodeCache symlinkCache = MtdEngine.getSymlinkCache();
        for (int i = path.length - 2; i > 0; --i) {
            DoubleList symlinks = symlinkCache.get(path[i]);
            if (symlinks == null) continue;
            for (Cursor.Double c : symlinks) {
                double[] symPath;
                Node symNode = MtdEngine.getNode(c.value);
                if (symNode == null || (symPath = symNode.getNodeIDPath(rootNodeId))[0] != rootNodeId && (symPath = GetNodeInfo.getSymlinkPath(rootNodeId, symPath, level))[0] != rootNodeId) continue;
                double[] p = Arrays.copyOf(symPath, symPath.length + path.length - i);
                int symIndex = symPath.length;
                p[symIndex++] = symNode.getId();
                for (int index = i + 1; index < path.length; ++index) {
                    p[symIndex++] = path[index];
                }
                return p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        Object path;
        Node node;
        int options = this.parseOptions();
        double nodeId = (options & 0x400) != 0 ? this.getNodeID() : this.getTranslatedNodeID();
        boolean isMetadataNode = true;
        if (this.getNodeID() == 0.0) {
            node = MtdEngine.getNode(nodeId);
            if (node == null) {
                if ((options & 0x300) != 0 && MtdEngine.serverNode().descriptor().useUsersTable) {
                    node = VirtualUser.getUser(nodeId);
                    isMetadataNode = false;
                }
                if (node == null) {
                    throw new InformException("\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
            }
        } else {
            node = MtdEngine.getNode(nodeId);
            if (node == null) {
                if ((options & 0x300) != 0 && MtdEngine.serverNode().descriptor().useUsersTable) {
                    node = VirtualUser.getUser(nodeId);
                    isMetadataNode = false;
                }
                if (node == null) {
                    this.sendError("\u0423\u0437\u0435\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", String.format("Node[%.0f]", nodeId));
                    return;
                }
            }
        }
        if ((options & 0x300) != 0 && node.getType() == 3 && isMetadataNode) {
            node = MtdEngine.getValidAccountNode(nodeId);
            isMetadataNode = !(node instanceof VirtualUser);
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        try (Connector.Metabase connector = new Connector.Metabase();){
            Node.NodeInfoArg arg = new Node.NodeInfoArg(connector, this.security(), null, out);
            arg.options = options;
            node.getNodeInfo(arg);
        }
        if ((options & 1) != 0 && isMetadataNode) {
            double rootNodeId = 0.0;
            if ((options & 0x10) == 0) {
                rootNodeId = this.getRootNodeID();
            }
            path = new StringBuilder();
            node.getNodeStringPath(rootNodeId, (StringBuilder)path);
            out.putAnsi(14, ((StringBuilder)path).toString());
        }
        if ((options & 2) != 0 && isMetadataNode) {
            double[] symPath;
            double rootNodeId = 0.0;
            if ((options & 0x10) == 0) {
                rootNodeId = this.getRootNodeID();
            }
            if ((path = (Object)node.getNodeIDPath(rootNodeId))[0] != rootNodeId && (symPath = GetNodeInfo.getSymlinkPath(rootNodeId, (double[])path, 32)) != null) {
                path = symPath;
            }
            if (path != null) {
                out.putRaw(15, LittleEndian.doubleArrayToBinary((double[])path));
            }
        }
        if ((options & 8) != 0 && isMetadataNode) {
            node.getAclContent(out);
        }
        if ((options & 0x80) != 0 && isMetadataNode) {
            out.putInt32(27, node.getRecordCount());
        }
        if ((options & 0x40) != 0 && isMetadataNode) {
            out.putInt32(6, node.getRealNode().getContentSize());
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

