/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.Security;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.scripts.SSContext;
import inform.common.Base64BinString;
import inform.common.Empty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class GetUserAccessRightsHistory
extends Request {
    private static final int TAG_ARHISTORY_START_DATE = 1;
    private static final int TAG_ARHISTORY_END_DATE = 2;
    private static final int TAG_ARHISTORY_USER = 3;
    private static final int TAG_ARHISTORY_OPERATIONS = 4;
    private static final int TAG_ARHISTORY_NODE_ID = 3;
    private static final int TAG_ARHISTORY_NODE_NAME = 4;
    private static final int TAG_ARHISTORY_TYPE = 5;
    private static final int TAG_ARHISTORY_NODE_DELETED = 6;
    private static final int TAG_ARHISTORY_MODIFICATIONS = 7;
    private static final int TAG_ARHISTORY_MOD_TIME = 1;
    private static final int TAG_ARHISTORY_MOD_USER_ID = 2;
    private static final int TAG_ARHISTORY_MOD_ROLE = 3;
    private static final int TAG_ARHISTORY_MOD_OPERATION = 4;
    private static final int TAG_ARHISTORY_MOD_COMMENT = 5;
    public static final int DELETED = 1;
    public static final int ADDED = 2;
    public static final int LOCKED = 3;
    public static final int UNLOCKED = 4;
    public static final int PASS_CHANGING = 5;
    public static final int CONST_CHANGING = 6;
    public static final int START_CHANGING = 7;
    public static final int PRIVATE_CHANGING = 8;
    private static final int[] HISTORY_UTFS = new int[]{4, 14, 15, 16};

    public GetUserAccessRightsHistory(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        UserAccessRightsHistorFilter filter = new UserAccessRightsHistorFilter();
        filter.userId = -1.0;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    filter.startDate = new Timestamp(in.getDate(this).getTime());
                    break;
                }
                case 2: {
                    filter.endDate = new Timestamp(in.getDate(this).getTime());
                    break;
                }
                case 3: {
                    filter.userId = in.getDouble();
                    break;
                }
                case 4: {
                    filter.operations = LittleEndian.toIntArray(in.getRaw());
                }
            }
        }
        if (filter.startDate == null) {
            this.sendError("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u0430\u0442\u0430!", "");
            return;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        try {
            if (filter.userId == -1.0) {
                for (Cursor.Double c : GetUserAccessRightsHistory.getNodes(null, filter)) {
                    UserARsHistory history = GetUserAccessRightsHistory.getNodeAccessRightsHistory(null, c.value, filter, true);
                    if (history == null || history.mods.isEmpty()) continue;
                    this.storeRolesModification(out, history);
                }
            } else {
                UserARsHistory history = GetUserAccessRightsHistory.getNodeAccessRightsHistory(null, filter.userId, filter, true);
                if (history != null && !history.mods.isEmpty()) {
                    this.storeRolesModification(out, history);
                }
            }
        }
        catch (Exception e) {
            Core.logger.error(null, e);
            this.sendError(e.getMessage(), "");
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DoubleList getNodes(SSContext ssContext, UserAccessRightsHistorFilter filter) throws InformException, SQLException {
        DoubleList result = new DoubleList(1);
        DatabaseDescriptor dd = DatabaseDescriptor.getMetabase();
        try (DatabaseConnection c = dd.connectPrivileged("rq:GetUserAccessRightsHistory::getNodes");){
            StringBuilder sql = new StringBuilder("SELECT DISTINCT NODE_ID FROM " + MetadataNodeReader.mtdTreeLogTableName + " WHERE ");
            sql.append("OP_CODE IN (").append(4).append(", ").append(2).append(") ");
            sql.append(" AND NODE_TYPE IN ( ").append(3).append(", ").append(4).append(',').append(57).append(") ");
            sql.append(" AND ").append("OP_TIME >= ?");
            if (filter.endDate != null) {
                sql.append(" AND OP_TIME <= ? ");
            }
            PreparedStatement ps = c.prepareStatement("GetAccessRightsHistory: getNodes", sql.toString());
            ps.setTimestamp(1, filter.startDate);
            if (filter.endDate != null) {
                ps.setTimestamp(2, filter.endDate);
            }
            try (ResultSet resultSet = ps.executeQuery(ssContext);){
                while (resultSet.next()) {
                    result.add(resultSet.getDouble(1));
                }
            }
            finally {
                ps.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserARsHistory getNodeAccessRightsHistory(SSContext ssContext, double nodeId, UserAccessRightsHistorFilter filter, boolean forceMeta) throws InformException, SQLException, IOException, TaggedReaderException {
        UserAccessRightsEntry entry = null;
        AccountNode node = MtdEngine.getAccountNode(nodeId);
        if (node != null) {
            entry = new UserAccessRightsEntry();
            entry.nodeId = nodeId;
            entry.deleted = false;
            entry.nodeType = node.getType();
            entry.nodeName = node.getName();
        }
        DatabaseDescriptor dd = DatabaseDescriptor.getMetabase();
        try (DatabaseConnection c = dd.connectPrivileged("rq:GetUserAccessRightsHistory::getNodeAccessRightsHistory");){
            AccessRightsModifications mods;
            byte[] raw_content;
            byte[] content;
            double modUserId;
            double modTime;
            ResultSet resultSet;
            if (!forceMeta && node instanceof VirtualUser) {
                assert (entry != null);
                UserARsHistory result = new UserARsHistory(entry);
                UsersTable ut = new UsersTable(MtdEngine.serverNode().descriptor(), true);
                double rid = node.getId();
                if (ut.field(0) != ut.pkfield()) {
                    SqlStringBuilder sql = new SqlStringBuilder();
                    sql.append("select ").append(ut.pkfield()).append(" from ").appendFull(ut.table()).append(" where ").append(ut.validField(0)).append("=?");
                    try (PreparedStatement ps = c.prepareStatement("resolveUserPK", sql.toString());){
                        ps.setDouble(1, rid);
                        try (ResultSet rs = ps.executeQuery(ssContext);){
                            if (rs.next()) {
                                rid = rs.getDouble(1);
                            }
                        }
                    }
                }
                DatabaseDescriptor db_c = ut.table().getDatabaseDescriptor();
                SqlStringBuilder sql = new SqlStringBuilder();
                sql.append("select * from (").append(" select ").append(3).append(" as utf,").append(TableDataAudit.DATA_AUDIT_TIME_FIELD).append(',').append(TableDataAudit.DATA_AUDIT_USER_ID_FIELD).append(',').append(TableDataAudit.DATA_AUDIT_BLOB_VALUE_FIELD).append(",null,").append(TableDataAudit.DATA_AUDIT_TABLE_ID_FIELD).append(',').append(TableDataAudit.DATA_AUDIT_RECORD_ID_FIELD).append(" from ");
                db_c.appendDetailAuditTableRawName(TableDataAudit.getSystemChangelogBlobDescriptor().getRawName(), sql.getBuilder());
                sql.append(" where ").append(TableDataAudit.DATA_AUDIT_FIELD_ID_FIELD).append('=').append(ut.validField(3).getId());
                for (Object utf : (ResultSet)HISTORY_UTFS) {
                    FieldDescriptor fieldDescriptor = ut.field((int)utf);
                    if (fieldDescriptor == null) continue;
                    sql.append(" union all").append(" select ").append((int)utf).append(" as utf,").append(TableDataAudit.DATA_AUDIT_TIME_FIELD).append(',').append(TableDataAudit.DATA_AUDIT_USER_ID_FIELD).append(",null,").append(TableDataAudit.DATA_AUDIT_NUMBER_VALUE_FIELD).append(',').append(TableDataAudit.DATA_AUDIT_TABLE_ID_FIELD).append(',').append(TableDataAudit.DATA_AUDIT_RECORD_ID_FIELD).append(" from ");
                    db_c.appendDetailAuditTableRawName(TableDataAudit.getSystemChangelogValDescriptor().getRawName(), sql.getBuilder());
                    sql.append(" where ").append(TableDataAudit.DATA_AUDIT_FIELD_ID_FIELD).append('=').append(fieldDescriptor.getId());
                }
                sql.append(") t where ").append(TableDataAudit.DATA_AUDIT_TABLE_ID_FIELD).append('=').append(ut.table().getNodeId()).append(" and ").append(TableDataAudit.DATA_AUDIT_RECORD_ID_FIELD).append("=?");
                String sqlpfx = sql.toString();
                sql = new SqlStringBuilder();
                sql.append(sqlpfx).append(" order by ").append(TableDataAudit.DATA_AUDIT_TIME_FIELD).append(" ASC ").append(", utf DESC");
                try (PreparedStatement ps = c.prepareStatement("getEntries", sql.toString());){
                    boolean recordStartup = false;
                    ps.setDouble(1, rid);
                    try (ResultSet rs = ps.executeQuery(ssContext);){
                        AccessRightsModifications prev = new AccessRightsModifications();
                        while (rs.next()) {
                            int utf = rs.getInt(1);
                            AccessRightsModifications curr = new AccessRightsModifications();
                            curr.isLocked = prev.isLocked;
                            curr.inheritedStartup = prev.inheritedStartup;
                            curr.rootNode = prev.rootNode;
                            curr.startNode = prev.startNode;
                            curr.modTime = rs.getDateTime(2);
                            curr.modUserId = rs.getDouble(3);
                            switch (utf) {
                                case 4: {
                                    boolean bl = curr.isLocked = rs.getDouble(5) != 0.0;
                                    if (rs.wasNull()) {
                                        curr.isLocked = true;
                                    }
                                    if (prev.isLocked != curr.isLocked) {
                                        result.mods.add(new RoleModification(curr, curr.isLocked ? 3 : 4, null));
                                    }
                                    prev.isLocked = curr.isLocked;
                                    break;
                                }
                                case 14: {
                                    recordStartup = true;
                                    if (!GetUserAccessRightsHistory.includeOperation(filter.operations, 7)) break;
                                    double v = rs.getDouble(5);
                                    if (rs.wasNull()) break;
                                    boolean bl = curr.inheritedStartup = v != 0.0;
                                    if (prev.inheritedStartup != curr.inheritedStartup) {
                                        if (curr.inheritedStartup) {
                                            result.mods.add(new RoleModification(curr, 7, "\u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442 \u0433\u0440\u0443\u043f\u043f\u044b \u0414\u0410"));
                                        } else {
                                            result.mods.add(new RoleModification(curr, 7, "\u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442 \u0433\u0440\u0443\u043f\u043f\u044b \u041d\u0415\u0422"));
                                        }
                                    }
                                    prev.inheritedStartup = curr.inheritedStartup;
                                    break;
                                }
                                case 15: {
                                    recordStartup = true;
                                    if (!GetUserAccessRightsHistory.includeOperation(filter.operations, 7) || curr.inheritedStartup) break;
                                    double v = rs.getDouble(5);
                                    if (rs.wasNull()) break;
                                    curr.rootNode = v;
                                    if (prev.rootNode != curr.rootNode) {
                                        result.mods.add(new RoleModification(curr, 7, String.format("\u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b '%.0f' => '%.0f'", prev.rootNode, curr.rootNode)));
                                    }
                                    prev.rootNode = curr.rootNode;
                                    break;
                                }
                                case 16: {
                                    recordStartup = true;
                                    if (!GetUserAccessRightsHistory.includeOperation(filter.operations, 7) || curr.inheritedStartup) break;
                                    double v = rs.getDouble(5);
                                    if (rs.wasNull()) break;
                                    curr.startNode = v;
                                    if (prev.startNode != curr.startNode) {
                                        result.mods.add(new RoleModification(curr, 7, String.format("\u0441\u0442\u0430\u0440\u043e\u0432\u044b\u0439 \u0443\u0437\u0435\u043b '%.0f' => '%.0f'", prev.startNode, curr.startNode)));
                                    }
                                    prev.startNode = curr.startNode;
                                    break;
                                }
                                case 3: {
                                    int k;
                                    String comm;
                                    if (!recordStartup) {
                                        curr.inheritedStartup = true;
                                    }
                                    GetUserAccessRightsHistory.fillModsByRawContent(curr, rs.getBlobBytes(4));
                                    if (!Arrays.equals(prev.securityHash, curr.securityHash)) {
                                        result.mods.add(new RoleModification(curr, 5, null));
                                    }
                                    if (GetUserAccessRightsHistory.includeOperation(filter.operations, 8) && !Arrays.equals(prev.props, curr.props) && !(comm = GetUserAccessRightsHistory.diff("", GetUserAccessRightsHistory.getProps(prev.props), GetUserAccessRightsHistory.getProps(curr.props))).isEmpty()) {
                                        result.mods.add(new RoleModification(curr, 8, comm));
                                    }
                                    if (GetUserAccessRightsHistory.includeOperation(filter.operations, 6) && !Arrays.equals(prev.constants, curr.constants) && !(comm = GetUserAccessRightsHistory.diff("\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430", GetUserAccessRightsHistory.getConstants(prev.constants), GetUserAccessRightsHistory.getConstants(curr.constants))).isEmpty()) {
                                        result.mods.add(new RoleModification(curr, 6, comm));
                                    }
                                    if (GetUserAccessRightsHistory.includeOperation(filter.operations, 7) && !recordStartup) {
                                        if (prev.inheritedStartup != curr.inheritedStartup) {
                                            if (curr.inheritedStartup) {
                                                result.mods.add(new RoleModification(curr, 7, "\u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442 \u0433\u0440\u0443\u043f\u043f\u044b \u0414\u0410"));
                                            } else {
                                                result.mods.add(new RoleModification(curr, 7, "\u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442 \u0433\u0440\u0443\u043f\u043f\u044b \u041d\u0415\u0422"));
                                            }
                                        }
                                        if (prev.rootNode != curr.rootNode && !recordStartup) {
                                            result.mods.add(new RoleModification(curr, 7, String.format("\u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b '%.0f' => '%.0f'", prev.rootNode, curr.rootNode)));
                                        }
                                        if (prev.startNode != curr.startNode && !recordStartup) {
                                            result.mods.add(new RoleModification(curr, 7, String.format("\u0441\u0442\u0430\u0440\u043e\u0432\u044b\u0439 \u0443\u0437\u0435\u043b '%.0f' => '%.0f'", prev.startNode, curr.startNode)));
                                        }
                                    }
                                    if (GetUserAccessRightsHistory.includeOperation(filter.operations, 1)) {
                                        for (int j = 0; j < prev.groups.length; ++j) {
                                            boolean del = true;
                                            for (k = 0; k < curr.groups.length; ++k) {
                                                if (prev.groups[j] != curr.groups[k]) continue;
                                                del = false;
                                                break;
                                            }
                                            if (!del) continue;
                                            result.mods.add(new RoleModification(curr, 1, null, prev.groups[j]));
                                        }
                                    }
                                    if (GetUserAccessRightsHistory.includeOperation(filter.operations, 2)) {
                                        for (int j = 0; j < curr.groups.length; ++j) {
                                            boolean add = true;
                                            for (k = 0; k < prev.groups.length; ++k) {
                                                if (curr.groups[j] != prev.groups[k]) continue;
                                                add = false;
                                                break;
                                            }
                                            if (!add) continue;
                                            result.mods.add(new RoleModification(curr, 2, null, curr.groups[j]));
                                        }
                                    }
                                    prev = curr;
                                }
                            }
                        }
                    }
                }
                UserARsHistory userARsHistory = result;
                return userARsHistory;
            }
            String selFlds = String.format("%s, %s, %s, %s, %s, %s ", "OP_TIME", "NODE_TYPE", "NODE_NAME", "USER_ID", "ATTRS_B64", "RAW_CONTENT");
            String subSQL = String.format("SELECT MAX(%s) FROM %s WHERE %s = ? AND %s < ? ", "OP_TIME", MetadataNodeReader.mtdTreeLogTableName, "NODE_ID", "OP_TIME");
            StringBuilder sql = new StringBuilder("SELECT " + selFlds + "FROM " + MetadataNodeReader.mtdTreeLogTableName);
            sql.append(" WHERE OP_TIME = ALL(").append(subSQL).append(") AND NODE_ID = ? ORDER BY OP_TIME DESC");
            PreparedStatement ps = c.prepareStatement("GetAccessRightsHistory: getNodeAccessRightsHistory[" + nodeId + "]", sql.toString());
            ps.setDouble(1, nodeId);
            ps.setTimestamp(2, filter.startDate);
            ps.setDouble(3, nodeId);
            try {
                resultSet = ps.executeQuery(ssContext);
                try {
                    if (resultSet.next()) {
                        if (entry == null) {
                            entry = new UserAccessRightsEntry();
                            entry.nodeId = nodeId;
                            entry.deleted = true;
                            entry.nodeType = resultSet.getInt(2);
                            entry.nodeName = resultSet.getString(3);
                        }
                        modTime = resultSet.getDateTime(1);
                        modUserId = resultSet.getDouble(4);
                        content = Base64BinString.Decode(resultSet.getString(5));
                        raw_content = resultSet.getBlobBytes(6);
                        mods = GetUserAccessRightsHistory.getModsByContent(content, raw_content);
                        mods.modTime = modTime;
                        mods.modUserId = modUserId;
                        entry.mods.add(mods);
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                ps.close();
            }
            sql = new StringBuilder("SELECT " + selFlds + " FROM " + MetadataNodeReader.mtdTreeLogTableName + " WHERE ");
            sql.append("OP_CODE IN (").append(4).append(", ").append(2).append(", ").append(1).append(") ");
            sql.append(" AND NODE_ID = ? AND OP_TIME >= ?");
            if (filter.endDate != null) {
                sql.append(" AND OP_TIME <= ? ");
            }
            sql.append(" ORDER BY OP_TIME ASC");
            ps = c.prepareStatement("GetAccessRightsHistory: getNodeAccessRightsHistory", sql.toString());
            ps.setDouble(1, nodeId);
            ps.setTimestamp(2, filter.startDate);
            if (filter.endDate != null) {
                ps.setTimestamp(3, filter.endDate);
            }
            try {
                resultSet = ps.executeQuery(ssContext);
                try {
                    while (resultSet.next()) {
                        if (entry == null) {
                            entry = new UserAccessRightsEntry();
                            entry.nodeId = nodeId;
                            entry.deleted = true;
                            entry.nodeType = resultSet.getInt(2);
                            entry.nodeName = resultSet.getString(3);
                        }
                        modTime = resultSet.getDateTime(1);
                        modUserId = resultSet.getDouble(4);
                        content = Base64BinString.Decode(resultSet.getString(5));
                        raw_content = resultSet.getBlobBytes(6);
                        mods = GetUserAccessRightsHistory.getModsByContent(content, raw_content);
                        mods.modTime = modTime;
                        mods.modUserId = modUserId;
                        entry.mods.add(mods);
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                ps.close();
            }
        }
        return GetUserAccessRightsHistory.diffGroups(entry, filter);
    }

    private static AccessRightsModifications getModsByContent(byte[] bytes, byte[] raw_bytes) throws IOException, TaggedReaderException {
        AccessRightsModifications mods = new AccessRightsModifications();
        mods.groups = Empty.doubleArray;
        mods.isLocked = false;
        if (bytes == null) {
            return mods;
        }
        TaggedReader reader = new TaggedReader(bytes);
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 105: {
                    mods.groups = LittleEndian.toDoubleArray(reader.getRaw());
                    break;
                }
                case 115: {
                    mods.isLocked = reader.getBoolean();
                    break;
                }
                case 101: {
                    reader.getRaw(mods.securityHash, mods.securityHash.length);
                    break;
                }
                case 121: {
                    mods.securityHash = reader.getRaw();
                }
            }
        }
        if (raw_bytes == null) {
            return mods;
        }
        TaggedReader raw_reader = new TaggedReader(raw_bytes);
        while (raw_reader.getNextTag() != 0) {
            switch (raw_reader.getCurrentTag()) {
                case 7: {
                    mods.props = raw_reader.getRaw();
                    break;
                }
                case 6: {
                    raw_reader.skip();
                    mods.constants = raw_reader.getRaw();
                    break;
                }
                case 2: {
                    raw_reader.skip();
                    mods.startNode = raw_reader.getDouble(151);
                }
            }
        }
        return mods;
    }

    private static void fillModsByRawContent(AccessRightsModifications mods, byte[] raw) throws IOException, TaggedReaderException {
        if (raw == null) {
            return;
        }
        TaggedReader reader = new TaggedReader(raw);
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 34: {
                    mods.groups = LittleEndian.toDoubleArray(reader.getRaw());
                    break;
                }
                case 30: {
                    reader.getRaw(mods.securityHash, mods.securityHash.length);
                    break;
                }
                case 115: {
                    mods.securityHash = reader.getRaw();
                    break;
                }
                case 42: {
                    mods.props = reader.getRaw();
                    break;
                }
                case 37: {
                    mods.constants = reader.getRaw();
                    break;
                }
                case 83: {
                    mods.inheritedStartup = false;
                    TaggedReader stream = reader.getStreamReader();
                    while (stream.next()) {
                        switch (stream.getCurrentTag()) {
                            case 2: {
                                stream.skip();
                                mods.startNode = stream.getDouble(151);
                                break;
                            }
                            case 1: {
                                stream.skip();
                                mods.rootNode = stream.getDouble(151);
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public static boolean includeOperation(int[] ops, int Operation2) {
        if (ops == null) {
            return true;
        }
        for (int i = 0; i < ops.length; ++i) {
            if (ops[i] != Operation2) continue;
            return true;
        }
        return false;
    }

    public static SortedMap<String, String> getConstants(byte[] inb) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (inb == null) {
            return result;
        }
        String curTitle = "";
        TaggedReader in = new TaggedReader(new ByteArrayInputStream(inb), inb.length);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 19: {
                    curTitle = String.format("%d", in.getInt());
                    break;
                }
                case 13: {
                    result.put(curTitle, String.format("%d", in.getInt()));
                    break;
                }
                case 14: {
                    result.put(curTitle, String.format("%15.8f", in.getDouble()));
                    break;
                }
                case 15: {
                    result.put(curTitle, in.getAnsi());
                    break;
                }
                case 34: {
                    break;
                }
                case 16: {
                    result.put(curTitle, DateTime.toString(in.getDouble()));
                    break;
                }
                case 17: {
                    result.put(curTitle, "null");
                    break;
                }
                case 22: {
                    result.put(curTitle, String.format("%.0f", in.getDouble()));
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    result.put(curTitle, String.format("%d", in.getInt()));
                    break;
                }
                case 28: {
                    result.put(curTitle, String.format("%.0f", in.getDouble()));
                }
            }
        }
        return result;
    }

    public static SortedMap<String, String> getProps(byte[] inb) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (inb == null) {
            return result;
        }
        TaggedReader in = new TaggedReader(new ByteArrayInputStream(inb), inb.length);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    result.put("\u0424.\u0418.\u041e.", String.format("%s", in.getAnsi()));
                    break;
                }
                case 2: {
                    result.put("\u041f\u043e\u0434\u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u0438\u0435", String.format("%s", in.getAnsi()));
                    break;
                }
                case 3: {
                    result.put("\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c", String.format("%s", in.getAnsi()));
                    break;
                }
                case 4: {
                    result.put("\u0422\u0435\u043b\u0435\u0444\u043e\u043d", String.format("%s", in.getAnsi()));
                    break;
                }
                case 5: {
                    result.put("E-mail", String.format("%s", in.getAnsi()));
                    break;
                }
                case 6: {
                    result.put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440", String.format("%s", in.getAnsi()));
                    break;
                }
                case 7: {
                    result.put("\u041c\u0430\u0441\u0448\u0442\u0430\u0431\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", String.format("%15.8f", in.getDouble()));
                }
            }
        }
        if (result.get("\u041c\u0430\u0441\u0448\u0442\u0430\u0431\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435") == null) {
            result.put("\u041c\u0430\u0441\u0448\u0442\u0430\u0431\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", String.format("%15.8f", 1.0));
        }
        return result;
    }

    public static String diff(String pfx, SortedMap<String, String> m1, SortedMap<String, String> m2) {
        String key;
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> e : m1.entrySet()) {
            key = e.getKey();
            String value = e.getValue();
            String _value = (String)m2.get(key);
            if (_value == null) {
                result.append(String.format("%s[%s]: '%s' => _\n", pfx, key, value));
                continue;
            }
            if (value.equals(_value)) continue;
            result.append(String.format("%s[%s]: '%s' => '%s'\n", pfx, key, value, _value));
        }
        for (Map.Entry<String, String> e : m2.entrySet()) {
            key = e.getKey();
            String _value = (String)m1.get(key);
            if (_value != null) continue;
            result.append(String.format("%s[%s]: _ => '%s'\n", pfx, key, e.getValue()));
        }
        return result.toString();
    }

    public static UserARsHistory diffGroups(UserAccessRightsEntry entry, UserAccessRightsHistorFilter filter) {
        if (entry == null || entry.mods.size() < 2) {
            return null;
        }
        UserARsHistory result = new UserARsHistory(entry);
        for (int i = 1; i < entry.mods.size(); ++i) {
            int k;
            AccessRightsModifications prev = entry.mods.get(i - 1);
            AccessRightsModifications cur = entry.mods.get(i);
            if (!Arrays.equals(prev.securityHash, cur.securityHash)) {
                result.mods.add(new RoleModification(cur, 5, null));
            }
            boolean propsModified = GetUserAccessRightsHistory.includeOperation(filter.operations, 8) && !Arrays.equals(prev.props, cur.props);
            try {
                String comm;
                if (propsModified && !(comm = GetUserAccessRightsHistory.diff("", GetUserAccessRightsHistory.getProps(prev.props), GetUserAccessRightsHistory.getProps(cur.props))).isEmpty()) {
                    result.mods.add(new RoleModification(cur, 8, comm));
                }
            }
            catch (Exception ignore) {
                Core.logger.error(null, ignore);
            }
            boolean constsModified = GetUserAccessRightsHistory.includeOperation(filter.operations, 6) && !Arrays.equals(prev.constants, cur.constants);
            try {
                String comm;
                if (constsModified && !(comm = GetUserAccessRightsHistory.diff("\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430", GetUserAccessRightsHistory.getConstants(prev.constants), GetUserAccessRightsHistory.getConstants(cur.constants))).isEmpty()) {
                    result.mods.add(new RoleModification(cur, 6, comm));
                }
            }
            catch (Exception ignore) {
                Core.logger.error(null, ignore);
            }
            if (GetUserAccessRightsHistory.includeOperation(filter.operations, 7) && prev.startNode != cur.startNode) {
                result.mods.add(new RoleModification(cur, 7, String.format("'%.0f' => '%.0f'", prev.startNode, cur.startNode)));
            }
            if (prev.isLocked != cur.isLocked) {
                result.mods.add(new RoleModification(cur, cur.isLocked ? 3 : 4, null));
            }
            if (GetUserAccessRightsHistory.includeOperation(filter.operations, 1)) {
                for (int j = 0; j < prev.groups.length; ++j) {
                    boolean del = true;
                    for (k = 0; k < cur.groups.length; ++k) {
                        if (prev.groups[j] != cur.groups[k]) continue;
                        del = false;
                        break;
                    }
                    if (!del) continue;
                    result.mods.add(new RoleModification(cur, 1, null, prev.groups[j]));
                }
            }
            if (!GetUserAccessRightsHistory.includeOperation(filter.operations, 2)) continue;
            for (int j = 0; j < cur.groups.length; ++j) {
                boolean add = true;
                for (k = 0; k < prev.groups.length; ++k) {
                    if (cur.groups[j] != prev.groups[k]) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                result.mods.add(new RoleModification(cur, 2, null, cur.groups[j]));
            }
        }
        return result;
    }

    private void storeRolesModification(TaggedWriter out, UserARsHistory history) throws IOException {
        out.putDouble(3, history.nodeId);
        out.putString(4, history.nodeName);
        out.putInt32(5, history.nodeType);
        if (history.deleted) {
            out.putEmpty(6);
        }
        ByteArrayOutputStream subStream = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(subStream);
        for (RoleModification mod : history.mods) {
            this.storeRoleModification(subWriter, mod);
        }
        subWriter.flush();
        out.putRaw(7, subStream);
    }

    private void storeRoleModification(TaggedWriter out, RoleModification mod) throws IOException {
        out.putDouble(1, mod.modTime);
        out.putDouble(2, mod.modUserId);
        out.putDouble(3, mod.group);
        out.putAnsiIf(5, mod.comment);
        out.putInt32(4, mod.operation);
    }

    public static class AccessRightsModifications {
        byte[] securityHash = Security.newMD5Hash();
        byte[] props;
        byte[] constants;
        boolean inheritedStartup;
        double rootNode;
        double startNode;
        boolean isLocked;
        double modTime;
        double modUserId;
        double[] groups = Empty.doubleArray;
    }

    public static class UserAccessRightsEntry {
        double nodeId;
        int nodeType;
        String nodeName;
        boolean deleted;
        ArrayList<AccessRightsModifications> mods = new ArrayList();
    }

    public static class RoleModification {
        public final double modTime;
        public final double modUserId;
        public final double group;
        public final int operation;
        public final String comment;

        RoleModification(AccessRightsModifications mod, int operation, String comment, double group) {
            this.modTime = mod.modTime;
            this.modUserId = mod.modUserId;
            this.operation = operation;
            this.comment = comment;
            this.group = group;
        }

        RoleModification(AccessRightsModifications mod, int operation, String comment) {
            this(mod, operation, comment, -1.0);
        }
    }

    public static class UserARsHistory {
        public final double nodeId;
        public final int nodeType;
        public final String nodeName;
        final boolean deleted;
        public final ArrayList<RoleModification> mods = new ArrayList();

        UserARsHistory(UserAccessRightsEntry e) {
            this.nodeId = e.nodeId;
            this.nodeType = e.nodeType;
            this.nodeName = e.nodeName;
            this.deleted = e.deleted;
        }
    }

    public static class UserAccessRightsHistorFilter {
        public Timestamp startDate;
        public Timestamp endDate;
        public int[] operations;
        public double userId;
    }
}

