/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.AclEntry;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.Security;

public class RedistributeACL
extends Request {
    public RedistributeACL(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        double userId = this.getUserID();
        Security security = this.security();
        double nodeId = this.getTranslatedNodeID();
        Node node = MtdEngine.getValidNode(nodeId).clone(Core.getApplicationId(), NodeStatus.MODIFIED);
        int accessMask = security.accessMask(node);
        if (node.getOwnerId() != userId && AccessMask.accessDenied(0x40000000, accessMask)) {
            throw new InformException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432 \u0443\u0437\u043b\u0430");
        }
        TaggedReader in = this.createRequestContentReader();
        try (Connector.Metabase connector = new Connector.Metabase();){
            Node.ModifyNodeArg arg = new Node.ModifyNodeArg(this, connector, NodeStatus.MODIFIED, security);
            arg.in = in;
            arg.userId = userId;
            arg.sessionId = this.getSessionID();
            AclEntry acl = new AclEntry(new LittleEndianDataInputStream(in.getStream()));
            node.redistributeAcl(acl, arg);
            MtdEngine.updateNodes(this.ssContext, arg);
        }
        this.sendResult();
    }
}

