/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.DateTime;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;

public class RegistrateAuditEvent
extends Request {
    private static final int TAG_RAE_START_TIME = 1;
    private static final int TAG_RAE_STOP_TIME = 2;
    private static final int TAG_RAE_CODE = 3;
    private static final int TAG_RAE_KIND = 4;
    private static final int TAG_RAE_REMARK = 6;
    private static final int TAG_RAE_ROW_ID = 7;
    private static final int TAG_RAE_TROWID = 8;
    private static final int TAG_RAE_LOADING_TIME1 = 9;
    private static final int TAG_RAE_LOADING_TIME2 = 10;

    public RegistrateAuditEvent(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        TaggedReader in = this.createRequestContentReader();
        AuditJournal.EventParams params = new AuditJournal.EventParams();
        AuditJournal.UpdateEventParams updateParams = new AuditJournal.UpdateEventParams();
        boolean updateMode = true;
        double auditId = 0.0;
        double recId = 0.0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    params.startTime = DateTime.toUnixTime(in.getDouble()) + (long)DateTime.serverTimeZoneOffset(this);
                    break;
                }
                case 2: {
                    params.stopTime = updateParams.stopTime = DateTime.toUnixTime(in.getDouble()) + (long)DateTime.serverTimeZoneOffset(this);
                    break;
                }
                case 3: {
                    params.code = in.getInt();
                    updateMode = false;
                    break;
                }
                case 4: {
                    params.kind = in.getInt();
                    break;
                }
                case 6: {
                    params.remark = in.getString();
                    break;
                }
                case 9: {
                    params.loadingTime1 = in.getDouble();
                    break;
                }
                case 10: {
                    params.loadingTime2 = in.getDouble();
                    break;
                }
                case 7: {
                    auditId = in.getDouble();
                    break;
                }
                case 8: {
                    recId = in.getDouble();
                }
            }
        }
        Node node = MtdEngine.getValidNode(this.getNodeID());
        if (recId == 0.0) {
            Core.logger.info("{} [node:{},user:{}]", updateMode ? "close" : "open", (long)node.getId(), (long)this.getUserID());
        } else {
            Core.logger.info("{} [node:{},rec:{},user:{}]", updateMode ? "close" : "open", (long)node.getId(), (long)recId, (long)this.getUserID());
        }
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.EVENTS);
        if (journal.isEnabled()) {
            if (!node.isAuditEvents()) {
                this.sendResult();
                return;
            }
            if (updateMode) {
                updateParams.auditId = auditId;
                updateParams.loadingTime1 = params.loadingTime1;
                updateParams.loadingTime2 = params.loadingTime2;
                if (updateParams.stopTime == 0L) {
                    updateParams.stopTime = System.currentTimeMillis();
                }
                journal.updateEvent(this.ssContext, updateParams, this.getUserID(), this.getSessionID());
                this.sendResult();
            } else {
                params.auditId = auditId;
                params.nodeId = node.getId();
                params.userId = this.getUserID();
                params.loginId = this.getSessionID();
                if (params.startTime == 0L) {
                    params.startTime = System.currentTimeMillis();
                }
                journal.registrateEvent(this.ssContext, params);
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                TaggedWriter out = new TaggedWriter(result);
                out.putDouble(7, params.auditId);
                out.flush();
                this.sendResult(result.internalBuffer(), result.size());
            }
        } else {
            this.sendResult();
        }
    }
}

