/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.scripts.License;

public class ValidateLicense
extends Request {
    public static final int TAG_VALIDATE_LICENCE_INSTALL = 1;
    public static final int TAG_VALIDATE_LICENCE_GET_STATE = 2;
    public static final int TAG_VALIDATE_LICENCE_VERIFIED = 1;
    public static final int TAG_VALIDATE_LICENCE_CLIENT_COUNT = 2;
    public static final int TAG_VALIDATE_LICENCE_MESSAGE = 3;
    public static final int TAG_VALIDATE_LICENCE_UNLIMITED = 4;
    public static final String INVALID_LICENCE_FORMAT = "\u041a\u043b\u044e\u0447 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043b\u044e\u0447.";
    public static final String INVALID_LICENCE = "\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u043d\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u0430";

    public ValidateLicense(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        block3: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.install(in.getAnsi());
                    continue block3;
                }
            }
            this.getLicenceState(7);
        }
    }

    private void install(String licenceContent) throws Exception {
        License license = new License();
        this.sendResult(license.install(licenceContent).getBytes(TaggedWriter.ANSI));
    }

    private void getLicenceState(int productId) throws Exception {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        ServerNode.Descriptor descriptor = MtdEngine.serverNode().descriptor();
        if (descriptor.licence == null) {
            out.putBool(1, true);
            out.putEmpty(4);
        } else {
            boolean verified = false;
            String message = null;
            int clientCount = Ini.MaxConnectionCount;
            try {
                License license = new License();
                if (license.checkLicence(productId, descriptor.licence)) {
                    clientCount = license.effectiveClientLimit();
                    message = license.generateKey();
                    verified = true;
                }
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
            out.putBool(1, verified);
            out.putInt32(2, clientCount);
            if (verified) {
                out.putString(3, message);
            }
        }
        out.flush();
        this.sendResult(data.internalBuffer(), data.size());
    }

    public static int validate(int productId, String licenseContent) {
        if (Strings.isVoid(licenseContent)) {
            return 2;
        }
        try {
            License license = new License();
            if (license.checkLicence(productId, licenseContent)) {
                return license.effectiveClientLimit();
            }
            return 2;
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
            return 2;
        }
    }

    public static void log(int productId) {
        ServerNode.Descriptor descriptor = MtdEngine.serverNode().descriptor();
        if (descriptor.licence == null) {
            return;
        }
        int clientCount = 2;
        boolean valid = false;
        try {
            License license = new License();
            if (license.checkLicence(productId, descriptor.licence)) {
                clientCount = license.effectiveClientLimit();
                valid = true;
            }
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
        }
        if (valid) {
            Core.logger.info("Licence for {} client connections", (Object)clientCount);
        } else {
            Core.logger.info("Licence not valid. Limit on {} client connections", (Object)clientCount);
        }
    }
}

