/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.Strings;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.net.ClientSession;
import inform.agent.net.WebSocketSession;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;

public class MultiProtocolServerHandler
extends FrameDecoder {
    private static SSLContext _sslContext = null;

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        short header3;
        short header2;
        short header1;
        if (buffer.readableBytes() < 2) {
            return null;
        }
        short magic1 = buffer.getUnsignedByte(buffer.readerIndex());
        short magic2 = buffer.getUnsignedByte(buffer.readerIndex() + 1);
        if (buffer.readableBytes() > 5 && MultiProtocolServerHandler.isAsmo(magic1, magic2, header1 = buffer.getUnsignedByte(buffer.readerIndex() + 2), header2 = buffer.getUnsignedByte(buffer.readerIndex() + 3), header3 = buffer.getUnsignedByte(buffer.readerIndex() + 4))) {
            this.switchToTCP(ctx);
            return buffer.readBytes(buffer.readableBytes());
        }
        if (MultiProtocolServerHandler.isSsl(magic1)) {
            this.switchToSsl(ctx);
        } else if (MultiProtocolServerHandler.isHttp(magic1, magic2)) {
            this.switchToHttp(ctx);
        } else {
            this.switchToTCP(ctx);
        }
        return buffer.readBytes(buffer.readableBytes());
    }

    public static boolean isAsmo(int magic1, int magic2, int header1, int header2, int header3) {
        return magic1 == 201 && magic2 == 6 && header1 == 116 && header2 == 105 && header3 == 111;
    }

    public static boolean isAsmo(byte[] magic) {
        return magic.length >= 5 && MultiProtocolServerHandler.isAsmo(magic[0] & 0xFF, magic[1] & 0xFF, magic[2] & 0xFF, magic[3] & 0xFF, magic[4] & 0xFF);
    }

    public static void getRedirectClientToTCPResponse(OutputStream stream) {
        TaggedWriter out = new TaggedWriter(stream);
        try {
            out.putSignature();
            out.putInt32(7, 10);
            out.putInt32(14, Ini.ClientConnectionPort);
            out.flush();
        }
        catch (IOException e) {
            Core.logger.error(null, e);
        }
    }

    public static boolean isSsl(int magic1) {
        if (Strings.isVoid(Ini.KeyStore)) {
            return false;
        }
        switch (magic1) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 255: {
                return true;
            }
        }
        return magic1 >= 128;
    }

    public static boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void switchToSsl(ChannelHandlerContext ctx) throws Exception {
        if (_sslContext == null) {
            if (Strings.isVoid(Ini.KeyStore)) {
                this.switchToTCP(ctx);
                return;
            }
            Class<MultiProtocolServerHandler> clazz = MultiProtocolServerHandler.class;
            // MONITORENTER : inform.agent.net.MultiProtocolServerHandler.class
            try {
                String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
                String[] iniKs = Ini.KeyStore.split("@");
                String ksPath = iniKs[0];
                String ksP = iniKs.length > 1 ? iniKs[1] : "";
                KeyStore ks = KeyStore.getInstance("PKCS12");
                FileInputStream fin = new FileInputStream(ksPath);
                try {
                    ks.load(fin, ksP.toCharArray());
                }
                finally {
                    fin.close();
                    fin = null;
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                kmf.init(ks, ksP.toCharArray());
                _sslContext = SSLContext.getInstance("TLS");
                _sslContext.init(kmf.getKeyManagers(), null, null);
            }
            catch (Exception e) {
                Core.logger.error(null, e);
                _sslContext = null;
            }
        }
        if (_sslContext == null) {
            this.switchToTCP(ctx);
            return;
        }
        ChannelPipeline pipeline = ctx.getPipeline();
        SSLEngine engine = _sslContext.createSSLEngine();
        engine.setUseClientMode(false);
        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        pipeline.addLast("multi", (ChannelHandler)new MultiProtocolServerHandler());
        pipeline.remove((ChannelHandler)this);
    }

    private void switchToHttp(ChannelHandlerContext ctx) throws Exception {
        ChannelPipeline pipeline = ctx.getPipeline();
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        WebSocketSession session = new WebSocketSession();
        pipeline.addLast("handler", (ChannelHandler)session);
        pipeline.remove((ChannelHandler)this);
        session.initConnection(ctx);
    }

    private void switchToTCP(ChannelHandlerContext ctx) throws Exception {
        ChannelPipeline pipeline = ctx.getPipeline();
        ClientSession session = new ClientSession();
        pipeline.addLast("handler", (ChannelHandler)session);
        pipeline.remove((ChannelHandler)this);
        session.initConnection(ctx);
    }
}

