/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net.request;

import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;
import java.io.File;
import java.io.FileInputStream;

public class DownloadClient
extends Request {
    public DownloadClient(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        String path = null;
        int maj = 0;
        int min = 0;
        int rel = 0;
        boolean mirrors = false;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 5: {
                    path = in.getAnsi();
                    break;
                }
                case 1: {
                    maj = in.getInt();
                    break;
                }
                case 2: {
                    min = in.getInt();
                    break;
                }
                case 3: {
                    rel = in.getInt();
                    break;
                }
                case 8: {
                    mirrors = true;
                }
            }
        }
        if (path == null) {
            this.sendError("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0444\u0430\u0439\u043b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430", null);
            return;
        }
        File file = new File(path);
        if (!file.isFile() || !file.canRead()) {
            this.sendError("\u0424\u0430\u0439\u043b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f", path);
            return;
        }
        long start = System.currentTimeMillis();
        if (mirrors && !Strings.isVoid(Ini.UpdateMirrors)) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(output);
            writer.putSignature();
            String root = new File(Ini.PatchPath).getAbsolutePath();
            writer.putAnsi(5, path.substring(root.length() + 1));
            for (String m : Ini.UpdateMirrors.split("\\|")) {
                writer.putAnsi(8, m);
            }
            writer.flush();
            this.sendResult(output.internalBuffer(), output.size());
            this.writeAuditEvent(maj, min, rel, start, "\u0437\u0430\u043f\u0440\u043e\u0441\u0438\u043b \u0441\u043f\u0438\u0441\u043e\u043a \u0437\u0435\u0440\u043a\u0430\u043b \u0434\u043b\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f");
            return;
        }
        try (FileInputStream stream = new FileInputStream(file);){
            int chunkSize;
            byte[] chunk = new byte[1024];
            while ((chunkSize = stream.read(chunk)) >= 0) {
                if (chunkSize == 0) continue;
                this.sendChunk(chunk, chunkSize);
            }
        }
        this.writeAuditEvent(maj, min, rel, start, "\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u043b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435");
        this.sendResult();
    }

    private void writeAuditEvent(int maj, int min, int rel, long start, String act) {
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.EVENTS);
        if (journal.containsAuditableEvent(0)) {
            AuditJournal.EventParams params = new AuditJournal.EventParams();
            params.startTime = start;
            params.stopTime = System.currentTimeMillis();
            params.loginId = this.client().getLoginId();
            params.userId = this.client().getUserId();
            params.remark = String.format("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c %s %s \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0441 \u0432\u0435\u0440\u0441\u0438\u0438 %s \u0434\u043e \u0432\u0435\u0440\u0441\u0438\u0438 %d.%d.%d", this.client().getUserName(), act, this.client().getVersion().toString(), maj, min, rel);
            params.code = 5;
            params.nodeId = 2.0;
            journal.registrateEvent(this.ssContext, params);
        }
    }
}

